<?php
/**
 * Header file for the Ecohorbor WordPress theme.
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>

		

<?php
if(is_front_page()) { ?>
   <style>
   	.sticky-head.header-sticky .full-bar-search-toggle { color: #3b7532 !important; }
   </style>
   <?php
}else{ ?>
<style>
	.primary-menu a.mega-menu-link {
    color: #3d7a38 !important;
    font-weight: bold !important;
}
header .navbar > div > ul.nav.pull-right > li .full-bar-search-toggle { color: #3b7532 !important; }
.sticky-head .hamburger span { background: #3b7532 !important; }
</style>
<?php } ?>

<link rel="stylesheet" href="<?php echo site_url(); ?>/wp-content/themes/ecohorbor/custom.css">
	</head>

	<body <?php body_class(); ?>>

		<?php wp_body_open(); // For wp wp_body_open action hook ?>

		<?php
			/*
			* Set ecohorbor page meta
			*/
			if( is_singular() ){
				Ecohorbor_Wp_Elements::$ecohorbor_page_options = get_post_meta( get_the_ID(), 'ecohorbor_post_meta', true );
			}
			$keys = array(
				'chk' => 'general-chk',
				'fields' => array(
					'site_layout' => 'site-layout'
				)			
			);
			$layout = Ecohorbor_Wp_Elements::ecohorbor_get_meta_and_option_values( $keys );
			$pageloader_opt = Ecohorbor_Wp_Elements::ecohorbor_options('page-loader-option');
		?>

			<div class="ecohorbor-body-inner <?php
			  if( $layout['site_layout'] == 'boxed' ) {
			 	echo esc_attr( 'container' ); 
			} else if ( $layout['site_layout'] == 'wider' ) {
				echo esc_attr( 'container-fluid' );
			}
			?>">
		
			<?php if( $pageloader_opt == '1' ) : ?>
			<div class="page-loader"><span class="page-loader-divider"></span></div>
			<?php endif; ?>	

			<?php
			/*
			 * Ecohorbor Header Before Action 
			 * 10 - ecohorbor_mobile_header
			 */
			do_action( 'ecohorbor_header_before' );
			?>
			
			<?php
			/*
			 * Ecohorbor Header Action 
			 * 10 - ecohorbor_desktop_header
			 */
			do_action( 'ecohorbor_header' );
			?>
			
			<?php
			/*
			 * Ecohorbor Header After Action 
			 * 10 - ecohorbor_header_slider
			 */
			do_action( 'ecohorbor_header_after' );
			?>