<?php 

class Ecohorbor_Plugin_Info {
	
	private static $_parent_instance = null;
	
	public function __construct() {
		require_once ECOHORBOR_DIR . '/admin/theme-plugins/tgm-init.php';
	}
		
	public static function ecohorbor_get_plugins(){
		return get_plugins();
	}
		
	public static function ecohorbor_does_plugin_require_update( $file_path ) {
		$repo_updates = get_site_transient( 'update_plugins' );
		$available_version = '';
		if ( isset( $repo_updates->response[ $file_path ]->new_version ) ) {
			$available_version = $repo_updates->response[ $file_path ]->new_version;			
		}
		return $available_version;
	}
		
	public static function ecohorbor_tgm_install(){
		
		if ( ! isset( $_POST['ecohorbor_bulk_nonce'] ) || ! wp_verify_nonce( $_POST['ecohorbor_bulk_nonce'], 'ecohorbor-bulk-plugin-install' ) ) wp_die("failed");
				
		require_once ECOHORBOR_DIR . '/admin/theme-plugins/tgm-init.php';			
		$plugins = isset( $_POST['plugins'] ) ? $_POST['plugins'] : TGM_Plugin_Activation::$instance->plugins;
		if( isset( $_POST['ecohorbor_bulk_plugins'] ) ) {
			$bulk_plugins = $_POST['ecohorbor_bulk_plugins'];
			$bulk_action = isset( $_POST['ecohorbor_bulk_action'] ) && ! empty( $_POST['ecohorbor_bulk_action'] ) ? sanitize_text_field( $_POST['ecohorbor_bulk_action'] ) : 'install';
		
			$tgm = new TGM_Plugin_Activation;			
			$tgm->plugins = $plugins;
			if( $bulk_action == 'install' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->ecohorbor_do_plugin_install( $plugin_name );
				}
			}elseif( $bulk_action == 'active' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->ecohorbor_do_plugin_activate( $plugin_name );
				}
			}elseif( $bulk_action == 'install-active' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->ecohorbor_do_plugin_install( $plugin_name, true );
				}
			}elseif( $bulk_action == 'deactive' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->ecohorbor_force_deactivation( $plugin_name );
				}
			}
		}
		wp_die("success");
	}
	
	public static function ecohorbor_plugin_link( $item ) {
		
		include_once ABSPATH . 'wp-admin/includes/plugin.php';

		$installed_plugins = Ecohorbor_Plugin_Info::ecohorbor_get_plugins();
		$item['sanitized_plugin'] = $item['name'];
		 $is_plug_act = 'is_plugin_active';
		 
		if ( $is_plug_act( $item['file_path'] ) ) {
			
			$available_version = $item['source'] == 'repo' ? Ecohorbor_Plugin_Info::ecohorbor_does_plugin_require_update( $item['file_path'] ) : $item['version'];
			
			if ( version_compare( $available_version, $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
				$actions = array(
					'update' => sprintf(
						'<a href="%1$s" class="ecohorbor-btn btn-default" title="%3$s %2$s">%3$s</a>',
						wp_nonce_url(
							add_query_arg(
								array(
									'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
									'plugin'		=> urlencode( $item['slug'] ),
									'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
									'plugin_source' => urlencode( $item['source'] ),
									'tgmpa-update' 	=> 'update-plugin',
									'version' 		=> urlencode( $item['version'] ),
									'return_url' 	=> 'ecohorbor-plugins'
								),
								admin_url( TGM_Plugin_Activation::$instance->parent_slug )
							),
							'tgmpa-update',
							'tgmpa-nonce'
						),
						$item['sanitized_plugin'],
						esc_html__( 'Update', 'ecohorbor' )
					),
				);
			}else{
				$actions = array(
					'deactivate' => sprintf(
						'<a href="%1$s" class="ecohorbor-btn btn-default" title="%3$s %2$s">%3$s</a>',
						esc_url( add_query_arg(
							array(
								'plugin'					=> urlencode( $item['slug'] ),
								'plugin_name'		  		=> urlencode( $item['sanitized_plugin'] ),
								'plugin_source'				=> urlencode( $item['source'] ),
								'ecohorbor-deactivate'	   		=> 'deactivate-plugin',
								'ecohorbor-deactivate-nonce' 	=> wp_create_nonce( 'ecohorbor-deactivate' ),
							),
							admin_url( 'admin.php?page=ecohorbor-plugins' )
						) ),
						$item['sanitized_plugin'],
						esc_html__( 'Deactivate', 'ecohorbor' )
					),
				);
			}
		}elseif ( ! isset( $installed_plugins[$item['file_path']] ) ) {
			$actions = array(
				'install' => sprintf(
					'<a href="%1$s" class="ecohorbor-btn btn-default" title="%3$s %2$s">%3$s</a>',
					esc_url( wp_nonce_url(
						add_query_arg(
							array(
								'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
								'plugin'		=> urlencode( $item['slug'] ),
								'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
								'plugin_source' => urlencode( $item['source'] ),
								'tgmpa-install' => 'install-plugin',
								'return_url' 	=> 'ecohorbor-plugins'
							),
							admin_url( TGM_Plugin_Activation::$instance->parent_slug )
						),
						'tgmpa-install',
						'tgmpa-nonce'
					) ),
					$item['sanitized_plugin'],
					esc_html__( 'Install', 'ecohorbor' )
				),
			);
		}elseif ( is_plugin_inactive( $item['file_path'] ) ) {

			if ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
				$actions = array(
					'update' => sprintf(
						'<a href="%1$s" class="ecohorbor-btn btn-default" title="%3$s %2$s">%3$s</a>',
						wp_nonce_url(
							add_query_arg(
								array(
									'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
									'plugin'		=> urlencode( $item['slug'] ),
									'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
									'plugin_source' => urlencode( $item['source'] ),
									'tgmpa-update' 	=> 'update-plugin',
									'version' 		=> urlencode( $item['version'] ),
									'return_url' 	=> 'ecohorbor-plugins'
								),
								admin_url( TGM_Plugin_Activation::$instance->parent_slug )
							),
							'tgmpa-update',
							'tgmpa-nonce'
						),
						$item['sanitized_plugin'],
						esc_html__( 'Update', 'ecohorbor' )
					),
				);
			} else {
				$actions = array(
					'activate' => sprintf(
						'<a href="%1$s" class="ecohorbor-btn btn-default" title="%3$s %2$s">%3$s</a>',
						esc_url( add_query_arg(
							array(
								'plugin'			   	=> urlencode( $item['slug'] ),
								'plugin_name'		  	=> urlencode( $item['sanitized_plugin'] ),
								'plugin_source'			=> urlencode( $item['source'] ),
								'ecohorbor-activate'	   		=> 'activate-plugin',
								'ecohorbor-activate-nonce' 	=> wp_create_nonce( 'ecohorbor-activate' ),
							),
							admin_url( 'admin.php?page=ecohorbor-plugins' )
						) ),
						$item['sanitized_plugin'],
						esc_html__( 'Activate', 'ecohorbor' )
					),
				);
			}
		}elseif ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
			$actions = array(
				'update' => sprintf(
					'<a href="%1$s" class="ecohorbor-btn btn-default" title="%3$s %2$s">%3$s</a>',
					wp_nonce_url(
						add_query_arg(
							array(
								'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
								'plugin'		=> urlencode( $item['slug'] ),
								'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
								'plugin_source' => urlencode( $item['source'] ),
								'tgmpa-update' 	=> 'update-plugin',
								'version' 		=> urlencode( $item['version'] ),
								'return_url' 	=> 'ecohorbor-plugins'
							),
							admin_url( TGM_Plugin_Activation::$instance->parent_slug )
						),
						'tgmpa-update',
						'tgmpa-nonce'
					),
					$item['sanitized_plugin'],
					esc_html__( 'Update', 'ecohorbor' )
				),
			);
		}
		
		return $actions;
	}
	
	public static function get_parent_instance() {
		if ( is_null( self::$_parent_instance ) ) {
			self::$_parent_instance = new self();
		}
		return self::$_parent_instance;
	}
	
}

class Ecohorbor_Plugins {
	
	private static $_instance = null;

	public function __construct() {
		Ecohorbor_Plugin_Info::get_parent_instance();
		add_action( 'admin_menu', array( $this, 'ecohorbor_admin_menu' ) );
	}
	
	public static function ecohorbor_admin_menu(){
		add_submenu_page( 
			'ecohorbor-welcome', 
			esc_html__( 'Theme Plugins', 'ecohorbor' ),
			esc_html__( 'Theme Plugins', 'ecohorbor' ), 
			'manage_options', 
			'ecohorbor-plugins', 
			array( 'Ecohorbor_Plugins', 'ecohorbor_plugins_admin_page' )
		);		
	}
	
	public static function ecohorbor_plugins_admin_page(){

		$ecohorbor_theme = wp_get_theme(); 
		
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p><strong>Important Notice for Existing Users:</strong> We’ve made a significant update to the theme by removing the email and address fields while introducing flexible HTML fields for greater customization. If needed, you can now add these details manually using the new HTML fields. <a href="https://zozothemes.com/update-notice" target="_blank">Learn more about this update</a>.</p>';
		echo '</div>';
		?>
		<div class="ecohorbor-settings-wrap">	
			<div class="ecohorbor-header-bar">
				<div class="ecohorbor-header-left">
					<div class="ecohorbor-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="ecohorbor-logo">
					</div><!-- .ecohorbor-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Ecohorbor Plugins', 'ecohorbor' ); ?><span class="ecohorbor-version"><?php echo esc_html( $ecohorbor_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<?php
						include_once ABSPATH . 'wp-admin/includes/plugin.php';
						$is_ecohorbor_addon_active = class_exists( 'Ecohorbor_Addon' );
						//$is_ecohorbor_addon_active = is_plugin_active('ecohorbor/ecohorbor.php');
						$current_theme = wp_get_theme();
						$is_theme_active = ($current_theme->get('Name') === 'Ecohorbor');
						$verfied_stat = get_option('verified_purchase_status');

						if ($is_ecohorbor_addon_active) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-options') . '"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						} else {
							echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Ecohorbor Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						}
						if ($verfied_stat) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-plugins') . '" class="active-page"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						} else {
							echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Ecohorbor theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						}
						?>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="<?php echo esc_url('https://docs.zozothemes.com/ecohorbor/');?>" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="<?php echo esc_url('https://zozothemes.com/forum/')?>" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .ecohorbor-header-left -->
				<div class="ecohorbor-header-right">
					<a href="<?php echo class_exists( 'Ecohorbor_Addon' ) ? esc_url( admin_url( 'admin.php?page=ecohorbor-importer' ) ) : '#'; ?>" class="button ecohorbor-btn"><?php esc_html_e( 'Import Demo', 'ecohorbor' ); ?></a>
				</div><!-- .ecohorbor-header-right -->
			</div><!-- .ecohorbor-header-bar -->
			
			<div class="ecohorbor-inner-wrap">
			<?php 
				require_once ECOHORBOR_DIR . '/admin/theme-plugins/tgm-init.php';			
				$plugins = TGM_Plugin_Activation::$instance->plugins;
				$plugin_custom_order = array(
					'elementor' 		=> $plugins['elementor'],
					'ecohorbor-addon' 	=> $plugins['ecohorbor-addon'],
					'classic-elementor-addons-pro' => $plugins['classic-elementor-addons-pro'],
					'cea-post-types' => $plugins['cea-post-types'],
					'zozo-header-footer' => $plugins['zozo-header-footer'],					
					'cea-magazine' => $plugins['cea-magazine'],
					'revslider'			=> $plugins['revslider'],
					'contact-form-7' 	=> $plugins['contact-form-7'],
					'charitable' 	=> $plugins['charitable'],
					'woocommerce' 	=> $plugins['woocommerce'],
					'envato-market' 	=> $plugins['envato-market'],
				);
			
				$installed_plugins = Ecohorbor_Plugin_Info::ecohorbor_get_plugins();
				
				if( isset( $_GET['ecohorbor-deactivate'] ) && $_GET['ecohorbor-deactivate'] == 'deactivate-plugin' ) {
					check_admin_referer( 'ecohorbor-deactivate', 'ecohorbor-deactivate-nonce' );
					$plugins = TGM_Plugin_Activation::$instance->plugins;
					foreach( $plugins as $plugin ) {
						if( $plugin['slug'] == $_GET['plugin'] ) {
							deactivate_plugins( $plugin['file_path'] );
						}
					}
				}
				if( isset( $_GET['ecohorbor-activate'] ) && $_GET['ecohorbor-activate'] == 'activate-plugin' ) {
					check_admin_referer( 'ecohorbor-activate', 'ecohorbor-activate-nonce' );
					$plugins = TGM_Plugin_Activation::$instance->plugins;
					foreach( $plugins as $plugin ) {
						if( $plugin['slug'] == $_GET['plugin'] ) {
							activate_plugin( $plugin['file_path'] );
						}
					}
				}
				$plugins = $plugin_custom_order;
				
				?>
			
				<div class="ecohorbor-settings-tabs">
					<div id="ecohorbor-general" class="ecohorbor-settings-tab ecohorbor-elements-list active">
						<div class="container">
							<form id="multi-plugins-active-form" method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=ecohorbor-plugins' ) ); ?>" enctype="multipart/form-data">
								<input type="hidden" name="action" value="ecohorbor_tgm_install" />
								<?php wp_nonce_field( 'ecohorbor-bulk-plugin-install', 'ecohorbor_bulk_nonce' ); ?>
								<p class="ecohorbor-settings-msg">
									<span class="multi-select-wrap">
										<input type="checkbox" class="bulk-select-all" /> <?php echo esc_html__('Bulk Select', 'ecohorbor'); ?>
									</span>
									<select class="bulk-plugins-action-trigger btn btn-default" name="ecohorbor_bulk_action">
										<option value="install"><?php echo esc_html__('Install', 'ecohorbor'); ?></option>
										<option value="active"><?php echo esc_html__('Activate', 'ecohorbor'); ?></option>
										<option value="deactive"><?php echo esc_html__('Deactivate', 'ecohorbor'); ?></option>
									</select>
									<a href="#" class="button ecohorbor-bulk-action"><?php echo esc_html__('Apply', 'ecohorbor'); ?></a>
									<img src="<?php echo esc_url( ECOHORBOR_URI . '/admin/assets/images/loader.gif' ); ?>" alt="<?php echo esc_attr_e('Loader', 'ecohorbor'); ?>" class="bulk-process-loader" />
								</p>
								<?php echo wp_nonce_field( 'ecohorbor_activate_nonce', 'ecohorbor-multi-plugin*^*' ); ?>
							</form>
							<div class="row multi-cols">
							<?php
								$active_action = '';
								if( isset( $_GET['plugin_status'] ) ) {
									$active_action = $_GET['plugin_status'];
								}
								$req_plugs = array();						
					
								foreach( $plugins as $plugin ):
									$class = '';
									$plugin_status = '';
									$active_action_class = '';
									$file_path = $plugin['file_path'];
									$plugin_action = Ecohorbor_Plugin_Info::ecohorbor_plugin_link( $plugin );
									foreach( $plugin_action as $action => $value ) {
										if( $active_action == $action ) {
											$active_action_class = ' plugin-' .$active_action. '';
										}
									}
									
									$is_plug_act = 'is_plugin_active';
									if( $is_plug_act( $file_path ) ) {
										$plugin_status = 'active';
										$class = ' active';
										$req_plugs[] = esc_html( $plugin['slug'] );
									}
									
									$class .= $active_action_class;
							?>
								<div class="col-4<?php echo esc_attr( $class ); ?>">
									<div class="media admin-box ecohorbor-plugins-box">
										<div class="admin-box-icon p-0 mr-3">
											<span class="plugin-image-wrap"><img src="<?php echo esc_url( $plugin['image_url'] ); ?>" alt="<?php echo esc_attr( $plugin['name'] ); ?>" /></span>								
										</div>
										<div class="media-body admin-box-info">
											<h3 class="admin-box-title"><?php echo esc_html( $plugin['name'] ); ?></h3>
											<div class="admin-box-content">
												<?php if( $plugin['required'] ): ?>
												<div class="plugin-required"><span class="dashicons dashicons-star-filled" title="<?php echo esc_attr__('Required', 'ecohorbor'); ?>"></span></div>
												<?php endif; ?>
												<?php if( isset( $installed_plugins[$plugin['file_path']] ) ): ?> 
												<div class="plugin-info"><?php 
													$current_version = $installed_plugins[$plugin['file_path']]['Version'];
													$available_version = $current_version;
													if( $plugin['source'] == 'repo' ){
														$available_version = Ecohorbor_Plugin_Info::ecohorbor_does_plugin_require_update( $plugin['file_path'] );
													}
												?>
													<?php echo sprintf( 'v%s | %s', $installed_plugins[$plugin['file_path']]['Version'], $installed_plugins[$plugin['file_path']]['Author'] ); ?>
												</div>
												<?php endif; ?>
												<div class="theme-actions--">
													<?php foreach( $plugin_action as $action ) { echo ( ''. $action ); } ?>
												</div>
												<?php $available_version = '';
												      $current_version = '';
													if( $plugin['source'] == 'repo' && version_compare( $available_version, $current_version, '>' ) ): ?>
													<div class="theme-update"><?php echo esc_html__('Update Available: Version', 'ecohorbor'); ?> <?php echo esc_attr( $available_version ); ?></div>
												<?php
												elseif( isset( $plugin_action['update'] ) && $plugin_action['update'] ): ?>
													<div class="theme-update"><?php echo esc_html__('Update Available: Version', 'ecohorbor'); ?> <?php echo esc_attr( $plugin['version'] ); ?></div>
												<?php endif; ?>
												
												<span class="multi-active-wrap"><input type="checkbox" class="bulk-activator" value="<?php echo esc_attr( $plugin['slug'] ); ?>" /></span>
												
											</div>
										</div>
									</div>
								</div><!-- .col -->
							<?php endforeach; ?>
							</div><!-- .row -->
						</div><!-- .container -->
					</div><!-- .ecohorbor-settings-tab -->
				</div><!-- .ecohorbor-settings-tabs -->
			
			</div><!-- .ecohorbor-inner-wrap -->
		</div><!-- .ecohorbor-settings-wrap -->
	<?php
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Ecohorbor_Plugins::get_instance();

//Plugin ajax functions
add_action( 'wp_ajax_ecohorbor_tgm_install', array( 'Ecohorbor_Plugin_Info', 'ecohorbor_tgm_install' ) );
add_action( 'wp_ajax_nopriv_ecohorbor_tgm_install', array( 'Ecohorbor_Plugin_Info', 'ecohorbor_tgm_install' )  );
