<?php 

class Ecohorbor_Admin_Class {
	
	private static $_instance = null;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'ecohorbor_admin_menu' ) );		
		add_action( 'admin_menu', array( $this, 'change_admin_menu_name' ), 99 );
		add_action( 'admin_enqueue_scripts', array( $this, 'ecohorbor_framework_admin_scripts' ), 10 );
		
		//Call plugin page
		$this->ecohorbor_plugin_menu_connect();
	}
	
	public static function ecohorbor_framework_admin_scripts(){
		if( isset( $_GET['page'] ) && ( $_GET['page'] == 'ecohorbor-welcome' || $_GET['page'] == 'ecohorbor-options' || $_GET['page'] == 'ecohorbor-sidebars' || $_GET['page'] == 'ecohorbor-fonts' || $_GET['page'] == 'ecohorbor-plugins' || $_GET['page'] == 'ecohorbor-importer' || $_GET['page'] == 'ecohorbor-verification' ) ){
			wp_enqueue_style( 'ecohorbor-admin', get_template_directory_uri() . '/admin/assets/css/ecohorbor-admin-page.css', array(), '1.0', 'all' );
		}
		if( isset( $_GET['page'] ) && $_GET['page'] == 'ecohorbor-welcome' ) {
			wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl-carousel.min.css', array(), '2.3.4', 'all' );
			wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), '2.3.4', true );
		}
		wp_enqueue_style( 'ecohorbor-admin-common', get_template_directory_uri() . '/admin/assets/css/ecohorbor-admin-common.css', array(), '1.0', 'all' );	
		wp_enqueue_script( 'ecohorbor-admin-js', esc_url( get_template_directory_uri() . '/admin/assets/js/ecohorbor-admin-script.js' ), array( 'jquery' ), '1.0' );
		wp_enqueue_style( 'bootstrap-icons', ECOHORBOR_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
		if( isset( $_GET['page'] ) && $_GET['page'] == 'ecohorbor-plugins' ){
			require_once ECOHORBOR_DIR . '/admin/theme-plugins/tgm-init.php';			
			$plugins = TGM_Plugin_Activation::$instance->plugins;
			$args = array( 'tgm_plugins' => $plugins );
			$admin_local_args = apply_filters( 'ecohorbor_admin_local_js_args', $args );
			wp_localize_script('ecohorbor-admin-js', 'ecohorbor_admin_ajax_var', $admin_local_args );
		}
		
		if( isset( $_GET['page'] ) && $_GET['page'] == 'ecohorbor-verification' ){
			$html = '<p><strong>This purchase code already registered with another domain</strong></p><p>Please go to your previous working environment and deactivate the purchase code to use it again ( WP dashboard -> Ecohorbor -> Token Verification -> click on the button "Deactivate" ).</p>';
			$args = array( 'already_used' => $html );
			$admin_local_args = apply_filters( 'ecohorbor_admin_local_js_args', $args );
			wp_localize_script('ecohorbor-admin-js', 'ecohorbor_admin_ajax_var', $admin_local_args );
		}
	}
	
	public static function ecohorbor_admin_menu(){
		add_menu_page( 
			esc_html__( 'Ecohorbor', 'ecohorbor' ),
			esc_html__( 'Ecohorbor', 'ecohorbor' ),
			'manage_options',
			'ecohorbor-welcome', 
			array( 'Ecohorbor_Admin_Class', 'ecohorbor_admin_page' ),
			get_template_directory_uri() . '/assets/images/brand-icon.png',
			6
		);
		add_submenu_page( 
			'ecohorbor-welcome', 
			esc_html__( 'Token Verification', 'ecohorbor' ),
			esc_html__( 'Token Verification', 'ecohorbor' ), 
			'manage_options', 
			'ecohorbor-verification', 
			array( 'Ecohorbor_Admin_Class', 'ecohorbor_verification_admin_page' )
		);
	}
	
	public static function change_admin_menu_name(){
		global $submenu;
		if(isset($submenu['ecohorbor-welcome'])){
			$submenu['ecohorbor-welcome'][0][0] = esc_html__( 'Welcome', 'ecohorbor' );
		}
	}
	
	public static function ecohorbor_admin_page(){
	
		$ecohorbor_theme = wp_get_theme();
		
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p><strong>Important Notice for Existing Users:</strong> We’ve made a significant update to the theme by removing the email and address fields while introducing flexible HTML fields for greater customization. If needed, you can now add these details manually using the new HTML fields. <a href="https://zozothemes.com/update-notice" target="_blank">Learn more about this update</a>.</p>';
		echo '</div>';
		?>
		<div class="ecohorbor-settings-wrap">
			<div class="ecohorbor-header-bar">
				<div class="ecohorbor-header-left">
					<div class="ecohorbor-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="ecohorbor-logo">
					</div><!-- .ecohorbor-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Ecohorbor', 'ecohorbor' ); ?><span class="ecohorbor-version"><?php echo esc_html( $ecohorbor_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<?php
						include_once ABSPATH . 'wp-admin/includes/plugin.php';
						$is_ecohorbor_addon_active = class_exists('Ecohorbor_Addon');
						//$is_ecohorbor_addon_active = is_plugin_active('ecohorbor/ecohorbor.php');
						$current_theme = wp_get_theme();
						$is_theme_active = ($current_theme->get('Name') === 'Ecohorbor');
						$verfied_stat = get_option('verified_purchase_status');

						if ($is_ecohorbor_addon_active) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-options') . '"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						} else {
							echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Ecohorbor Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						}
						if ($verfied_stat) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-plugins') . '"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						} else {
							echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Ecohorbor theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						}
						?>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="<?php echo esc_url('https://docs.zozothemes.com/ecohorbor/');?>" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="<?php echo esc_url('https://zozothemes.com/forum/');?>" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .ecohorbor-header-left -->
				<div class="ecohorbor-header-right">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=ecohorbor-verification' ) ) ?>" class="button ecohorbor-btn"><?php esc_html_e( 'Verify Token', 'ecohorbor' ); ?></a>
				</div><!-- .ecohorbor-header-right -->
			</div><!-- .ecohorbor-header-bar -->
			
			<div class="ecohorbor-settings-tabs">
				<div id="ecohorbor-general" class="ecohorbor-settings-tab ecohorbor-elements-list active">
					<div class="container">
						<div class="row">
							<div class="col-8">
								<div class="row">
									<div class="col-6 mb-4">
										<div class="banner-img-wrap">
											<img class="ecohorbor-preview-img img-fluid" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/banner.png' ); ?>" alt="essential-addons-for-elementor-featured">
										</div>
									</div><!-- .col -->
									<div class="col-6 mb-4">
										<div class="media admin-box">
											<div class="admin-box-icon mr-3">
												<span class="dashicons dashicons-admin-generic"></span>								
											</div>
											<div class="media-body admin-box-info">
												<h3 class="admin-box-title"><?php esc_html_e( 'Requirements', 'ecohorbor' ); ?></h3>
												<div class="admin-box-content">
												<?php
													$php_version = phpversion();
													$php_version_class = version_compare( $php_version, '8.2.0', '>=') ? ' success' : ' warning';
													$wp_version = get_bloginfo('version');
													$wp_version_class = version_compare( $wp_version, '6.7.2', '>=') ? ' success' : ' warning';
													
													ob_start();
													phpinfo(INFO_MODULES);
													$info = ob_get_contents();
													ob_end_clean();
													$info = stristr($info, 'Client API version');
													preg_match('/[1-9].[0-9].[1-9][0-9]/', $info, $match);
													$mysql_version = $match[0]; 
													$mysql_version_class = version_compare( $mysql_version, '8.0', '>=') ? ' success' : ' warning';
													
													$post_max_size = ini_get('post_max_size');
													$post_max = str_replace("M","",$post_max_size);
													$post_max_class = $post_max >= 10 ? ' success' : ' warning';
													
													$max_execution_time = ini_get('max_execution_time');
													$max_exe_class = $max_execution_time >= 300 ? ' success' : ' warning';
													
													$max_input_vars = ini_get('max_input_vars');
													$max_input_class = $max_input_vars >= 2000 ? ' success' : ' warning';
													
												?>
													<table class="ecohorbor-admin-table no-spacing-table">
														<thead>
															<tr>
																<td><?php esc_html_e( 'Core', 'ecohorbor' ); ?></td>
																<td><?php esc_html_e( 'Required', 'ecohorbor' ); ?></td>
																<td><?php esc_html_e( 'Current', 'ecohorbor' ); ?></td>
																<td><?php esc_html_e( 'Status', 'ecohorbor' ); ?></td>
															</tr>
														</thead>
														<tbody>
															<tr>
																<td><?php esc_html_e( 'PHP', 'ecohorbor' ); ?></td>
																<td>8.2.0</td>
																<td><?php echo esc_html( $php_version ); ?></td>
																<td class="text-center"><span class="requirement-icon <?php echo esc_attr( $php_version_class ); ?>"></span></td>
															</tr>
															<tr>
																<td><?php esc_html_e( 'MySQL', 'ecohorbor' ); ?></td>
																<td>8.0</td>
																<td><?php echo esc_html( $mysql_version ); ?></td>
																<td class="text-center"><span class="requirement-icon <?php echo esc_attr( $mysql_version_class ); ?>"></span></td>
															</tr>
															<tr>
																<td><?php esc_html_e( 'WordPress', 'ecohorbor' ); ?></td>
																<td>6.7.2</td>
																<td><?php echo esc_html( $wp_version ); ?></td>
																<td class="text-center"><span class="requirement-icon <?php echo esc_attr( $wp_version_class ); ?>"></span></td>
															</tr>															
															<tr>
																<td><?php esc_html_e( 'post_max_size', 'ecohorbor' ); ?></td>
																<td>10M</td>
																<td><?php echo esc_html( $post_max_size ); ?></td>
																<td class="text-center"><span class="requirement-icon <?php echo esc_attr( $post_max_class ); ?>"></span></td>
															</tr>
															<tr>
																<td><?php esc_html_e( 'max_input_vars', 'ecohorbor' ); ?></td>
																<td>2000</td>
																<td><?php echo esc_html( $max_input_vars ); ?></td>
																<td class="text-center"><span class="requirement-icon <?php echo esc_attr( $max_input_class ); ?>"></span></td>
															</tr>
															<tr>
																<td><?php esc_html_e( 'max_execution_time', 'ecohorbor' ); ?></td>
																<td>300</td>
																<td><?php echo esc_html( $max_execution_time ); ?></td>
																<td class="text-center"><span class="requirement-icon <?php echo esc_attr( $max_exe_class ); ?>"></span></td>
															</tr>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div><!-- .col -->
									<div class="col-6 mb-4">
										<div class="media admin-box">
											<div class="admin-box-icon mr-3">
												<span class="dashicons dashicons-media-document"></span>								
											</div>
											<div class="media-body admin-box-info">
												<h3 class="admin-box-title"><?php esc_html_e( 'Documention', 'ecohorbor' ); ?></h3>
												<div class="admin-box-content">
													<?php esc_html_e( 'Get started by spending some time with the documentation to get familiar with Ecohorbor. Build awesome websites for you or your clients with ease.', 'ecohorbor' ); ?>
												</div>
												<a href="<?php echo esc_url( __( 'https://docs.zozothemes.com/ecohorbor/', 'ecohorbor' ) );?> " class="ecohorbor-btn btn-default" target="__blank"><?php esc_html_e( 'Go Here', 'ecohorbor' ); ?></a>
											</div>
										</div>
									</div><!-- .col -->
									<div class="col-6">
										<div class="media admin-box">
											<div class="admin-box-icon mr-3">
												<span class="dashicons dashicons-admin-users"></span>								
											</div>
											<div class="media-body admin-box-info">
												<h3 class="admin-box-title"><?php esc_html_e( 'Need Help?', 'ecohorbor' ); ?></h3>
												<div class="admin-box-content">
													<?php esc_html_e( 'Stuck with something? Get help from the community on WordPress.org Forum initiate a live chat at Ecohorbors website and get support.', 'ecohorbor' ); ?>
												</div>
												<a href="<?php echo esc_url( __( 'https://zozothemes.com/knowledge-base/', 'ecohorbor' ) );?>" class="ecohorbor-btn btn-default" target="__blank"><?php esc_html_e( 'Get Support', 'ecohorbor' ); ?></a>
											</div>
										</div>
									</div><!-- .col -->
									<div class="col-6 mb-4">
									    <div class="media admin-box">
									        <div class="admin-box-icon mr-3">
									            <span class="dashicons dashicons-video-alt3"></span>
									        </div>
									        <div class="media-body admin-box-info">
									            <h3 class="admin-box-title"><?php esc_html_e('Video Tutorials?', 'ecohorbor'); ?></h3>
									            <div class="admin-box-content">
									                <?php esc_html_e('Get started by spending some time with the Video tutorials to get familiar with Ecohorbor. Here is a full video tutorial to how to setup a theme.', 'ecohorbor'); ?>
									            </div>
									            <a href="<?php echo esc_url( __('https://zozothemes.com/knowledge-base/', 'ecohorbor' ));?>" class="ecohorbor-btn btn-default" target="__blank"><?php esc_html_e('Click Here', 'ecohorbor'); ?></a>
									        </div>
									    </div>
									</div>

									<div class="col-12">								
										<div class="admin-box-slide-wrap text-center">	
											<?php										
												//Banner
											?>
										</div>
									</div><!-- .col -->
								</div><!-- .row -->
							</div><!-- .col -->
							<div class="col-4">
							<?php
								if( !class_exists( 'Zozothemes_API' ) ){
									require_once ECOHORBOR_DIR . '/admin/class.zozo-api.php';
								}
								$zozo_api = new Zozothemes_API;
								$response = $zozo_api->get_response();
							?>
								<div class="admin-box">
									<div class="admin-box-info">
										<h3 class="admin-box-title"><?php esc_html_e( 'Live Updates', 'ecohorbor' ); ?></h3>
										<div class="admin-box-pro text-center">
											
										</div>									
											<div class="full-logo-wrap"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand.png' ); ?>" alt="ecohorbor-logo"></div>
										
										<h3 class="admin-box-title my-4"><?php esc_html_e( 'Featured Themes', 'ecohorbor' ); ?></h3>
										<div class="admin-box-slide-wrap">
										<?php	
										if( !is_wp_error( $response ) ){										
											if( !empty( $response ) && isset( $response['products'] ) ) {
												echo '<div class="owl-carousel">';
												foreach( $response['products'] as $key => $product ){
													echo '<a href="'. esc_url( $product['link'] ) .'" target="_blank"><img src="'. esc_url( $product['img'] ) .'" alt="'. esc_url( $product['alt'] ) .'"></a>';
												}
												echo '</div>';
											}
										}else{ ?>
											<p><?php esc_html_e( 'Featured products will show here..', 'ecohorbor' ); ?></p>
										<?php
										}
										?>
										</div>
									</div>
								</div>
							</div>
						</div><!-- .row -->
					</div><!-- .container -->
				</div><!-- .ecohorbor-settings-tab -->
			</div><!-- .ecohorbor-settings-tabs -->
			
		</div><!-- .ecohorbor-settings-wrap -->
		<?php
	}

	public static function ecohorbor_verification_admin_page(){		
	
		$ecohorbor_theme = wp_get_theme();		
	?>
		<div class="ecohorbor-settings-wrap">
		
			<div class="ecohorbor-header-bar">
				<div class="ecohorbor-header-left">
					<div class="ecohorbor-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="ecohorbor-logo">
					</div><!-- .ecohorbor-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Purchase Code Verification', 'ecohorbor' ); ?><span class="ecohorbor-version"><?php echo esc_html( $ecohorbor_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<?php
						include_once ABSPATH . 'wp-admin/includes/plugin.php';
						$is_ecohorbor_addon_active = class_exists('Ecohorbor_Addon');
						//$is_ecohorbor_addon_active = is_plugin_active('ecohorbor/ecohorbor.php');
						$current_theme = wp_get_theme();
						$is_theme_active = ($current_theme->get('Name') === 'Ecohorbor');
						$verfied_stat = get_option('verified_purchase_status');
						
						if ($is_ecohorbor_addon_active) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-options') . '"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						} else {
							echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Ecohorbor Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						}
						if ($verfied_stat) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-plugins') . '"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						} else {
							echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Ecohorbor theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						}
						?>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="<?php echo esc_url( 'https://zozothemes.com/knowledge-base/' ); ?>" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="<?php echo esc_url( 'https://zozothemes.com/knowledge-base/'); ?>" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="<?php echo esc_url( 'https://docs.zozothemes.com/ecohorbor/'); ?>" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="<?php echo esc_url( 'https://zozothemes.com/knowledge-base/'); ?>" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="<?php echo esc_url( 'https://zozothemes.com/forum/'); ?>" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .ecohorbor-header-left -->
				<div class="ecohorbor-header-right">
					<a href="<?php echo esc_url( 'https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-' ); ?>" target="_blank" class="button ecohorbor-btn"><?php esc_html_e( 'Get Purchase Code', 'ecohorbor' ); ?></a>
				</div><!-- .ecohorbor-header-right -->
			</div><!-- .ecohorbor-header-bar -->
			
			<div class="ecohorbor-inner-wrap">
				<div class="ecohorbor-settings-tabs">
					<div id="ecohorbor-general" class="ecohorbor-settings-tab ecohorbor-elements-list active">
						<div class="container">
							<?php 
								$verfied_stat = get_option('verified_purchase_status');
							?>
							<div class="zozo-envato-registration-form-wrap">
								<?php if( !$verfied_stat ): ?>
								<h2 class="text-center"><?php esc_html_e( "Activate your Licence", "ecohorbor" ); ?></h2>
								<p class="text-center"><?php esc_html_e( "Welcome and thank you for Choosing Ecohorbor Theme!
								The Ecohorbor theme needs to be activated to enable demo import installation and customer support service.", "ecohorbor" ); ?></p>	
								<a href="<?php echo esc_url( 'https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-' ); ?>" target="_blank"><?php esc_html_e( "How to find purchase code?", "ecohorbor" ); ?></a>
								<form id="zozo-envato-registration-form" class="zozo-envato-registration-form" method="post">
									<?php wp_nonce_field( 'ecohorbor_theme_verify^%&^%', 'zozo_verify_nonce' ); ?>
									<div class="form-fields">
										<div class="zozo-input-group">
											<input type="text" name="zozo_registration_email" value="" placeholder="<?php esc_attr_e( 'Enter E-mail address', 'ecohorbor' ); ?>">
											<input type="text" name="zozo_purchase_code" value="" placeholder="<?php esc_attr_e( 'Enter your theme purchase code', 'ecohorbor' ); ?>">
										</div>
										<div class="submit-group">
											<input type="submit" name="submit" id="submit" class="button ecohorbor-btn" value="<?php esc_attr_e( 'Activate', 'ecohorbor' ); ?>" />
											<span class="process-loader"><img src="<?php echo esc_url( ECOHORBOR_URI . '/admin/assets/images/loader.gif' ); ?>" alt="<?php esc_attr_e( 'Loader', 'ecohorbor' ) ?>" /></span>
										</div>
									</div>
									<div class="verfication-alert text-center"><span class="verfication-txt"></span></div>
								</form>
								<?php else: ?>
								<div class="theme-activated-wrap text-center">
									<h2><?php esc_html_e( 'Thank you!', 'ecohorbor' ) ?></h2>
									<p><strong><?php esc_html_e( 'Your theme\'s license is activated successfully.', 'ecohorbor' ) ?></strong></p>
								</div>
								<form id="zozo-envato-deactivation-form" class="zozo-envato-deactivation-form text-center" method="post">
									<?php wp_nonce_field( 'ecohorbor_theme_deactivate^%&^%', 'zozo_deactivate_nonce' ); ?>
									<div class="submit-group">
										<input type="submit" name="submit" class="button ecohorbor-btn" value="<?php esc_attr_e( 'Deactivate', 'ecohorbor' ); ?>" />
										<span class="process-loader"><img src="<?php echo esc_url( ECOHORBOR_URI . '/admin/assets/images/loader.gif' ); ?>" alt="<?php esc_attr_e( 'Loader', 'ecohorbor' ) ?>" /></span>
									</div>
								</form>
								<?php endif; ?>
								
								<div class="registration-token-instruction">
									<p class="text-center"><strong><?php esc_html_e( '1 license = 1 domain = 1 website', 'ecohorbor' ); ?></strong></p>
									<p class="text-center"><?php printf( '%1$s <a href="%2$s" target="_blank">%3$s</a>',
										esc_html__( 'You can always buy more licences for this product:', 'ecohorbor' ),
										esc_url( 'https://themeforest.net/user/zozothemes/portfolio' ),
										esc_html__( 'ThemeForest ZOZOTHEMES', 'ecohorbor' )
										); ?>
									</p>
									<h5> Please <a href="<?php echo admin_url('admin.php?page=ecohorbor-plugins'); ?>" style="font-size:14px;">Activate Required Plugins</a>, before demo import.</h5>
									<p class="text-left notice-wrap"><span class="info-notice"><?php esc_html_e( 'Notice', 'ecohorbor' ); ?></span><?php esc_html_e( 'If you are developing a website in the staging site means, While moving to the production site, please deactivate the license in staging and activate it in the Production site.', 'ecohorbor' ); ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php
	}
	
	public static function ecohorbor_plugin_menu_connect(){
		require_once ECOHORBOR_DIR . '/admin/class.token-verification.php';
		$verfied_stat = Zozo_Purchase_Code_Verification::check_theme_activated();
		if( !empty( $verfied_stat ) && !is_array( $verfied_stat ) ) {
			require_once ECOHORBOR_DIR . '/admin/class.plugin-settings.php';	
		}
	}
	
	public static function ecohorbor_theme_verification(){
		
		$nonce = isset( $_POST['zozo_verify_nonce'] ) ? sanitize_text_field( $_POST['zozo_verify_nonce'] ) : '';	  
		if ( ! wp_verify_nonce( $nonce, 'ecohorbor_theme_verify^%&^%' ) )
			wp_die ( esc_html__( 'Busted', 'ecohorbor' ) );
		
		if( isset( $_POST['zozo_registration_email'] ) && !empty( $_POST['zozo_purchase_code'] ) ){
			require_once ECOHORBOR_DIR . '/admin/class.token-verification.php';
			$verfy_obj = new Zozo_Purchase_Code_Verification;
			$status = $verfy_obj->verify_token();
			wp_send_json($status);
		}
		
		wp_die('finished');
	}
	
	public static function ecohorbor_theme_deactivate(){
			
		$nonce = isset( $_POST['zozo_deactivate_nonce'] ) ? sanitize_text_field( $_POST['zozo_deactivate_nonce'] ) : '';	  
		if ( ! wp_verify_nonce( $nonce, 'ecohorbor_theme_deactivate^%&^%' ) )
			wp_die ( esc_html__( 'Busted', 'ecohorbor' ) );
				
		require_once ECOHORBOR_DIR . '/admin/class.token-verification.php';
		$verfy_obj = new Zozo_Purchase_Code_Verification;
		$status = $verfy_obj->deactivate_api_call();
		wp_send_json($status);
		
		wp_die('finished');
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Ecohorbor_Admin_Class::get_instance();

//Theme verification ajax functions
add_action( 'wp_ajax_ecohorbor_theme_verify', array( 'Ecohorbor_Admin_Class', 'ecohorbor_theme_verification' ) );
add_action( 'wp_ajax_nopriv_ecohorbor_theme_verify', array( 'Ecohorbor_Admin_Class', 'ecohorbor_theme_verification' )  );

//Theme deactivate
add_action( 'wp_ajax_ecohorbor_theme_deactivate', array( 'Ecohorbor_Admin_Class', 'ecohorbor_theme_deactivate' ) );
add_action( 'wp_ajax_nopriv_ecohorbor_theme_deactivate', array( 'Ecohorbor_Admin_Class', 'ecohorbor_theme_deactivate' )  );