(function ($) {
    $.fn.conditionize = function (options) {
        var settings = $.extend({
            updateOn: "change",
            onload: true,
            ifTrue: "show",
            ifFalse: "hide"
        }, options);
        if (Array.isArray(settings.updateOn)) {
            settings.updateOn = settings.updateOn.join(" ")
        }

        function prepareActions(e) {
            if (!e || e === "ignore") {
                return []
            }
            if (typeof e === "string") {
                e = [e]
            }
            if (typeof e === "function") {
                e = [e]
            }
            if (Array.isArray(e) && e.every(function (e) {
                return typeof e === "string" && $.fn.conditionize.actions.hasOwnProperty(e.split(":")[0]) || typeof e === "function"
            })) {
                return e
            }
            throw new TypeError("Incorrect action type for ifTrue or ifFalse." + "ifTrue/ifFalse must be either a string with default action name," + 'i.e. one of "show", "hide", "clear", "trigger" or a function with ' + "one argument ($section);  or array consisting of them.")
        }
        settings.ifTrue = prepareActions(settings.ifTrue);
        settings.ifFalse = prepareActions(settings.ifFalse);
        var handler = function (e, i) {
            var t;
            if (e) {
                t = settings.ifTrue
            } else {
                t = settings.ifFalse
            }
            t.forEach(function (e) {
                if (typeof e === "string") {
                    if (e.startsWith("trigger")) {
                        if (e === "trigger") {
                            $.fn.conditionize.actions.trigger(i, settings.updateOn)
                        } else {
                            $.fn.conditionize.actions.trigger(i, e.slice(8))
                        }
                    } else {
                        $.fn.conditionize.actions[e](i)
                    }
                } else {
                    if (typeof e === "function") {
                        e(i)
                    }
                }
            })
        };
        return this.each(function () {
            var $section = $(this);
            var cond = $(this).data("condition");
            var allFields = [];
            cond = cond.replace($.fn.conditionize.re, function (e, i) {
                var t = i.substring(0, 1) === "#" ? i : "[name='" + i + "']";
                if ($(t).length) {
                    if (allFields.indexOf(t) === -1) {
                        allFields.push(t)
                    }
                    return '$.fn.conditionize.getValue("' + t + '")'
                } else {
                    return i
                }
            });
            allFields.forEach(function (field) {
                $(field).on(settings.updateOn, function () {
                    handler(eval(cond), $section)
                })
            });
            if (settings.onload) {
                if (document.readyState === "complete") {
                    handler(eval(cond), $section)
                } else {
                    $(window).on("load", function () {
                        handler(eval(cond), $section)
                    })
                }
            }
        })
    };
    $.extend($.fn.conditionize, {
        re: new RegExp("(#?[a-z0-9_\\[\\]-]+)" + "(?:(?=([^\"]*\"[^\"]*\")*[^\"]*$)(?=([^']*'[^']*')*[^']*$))", "gi"),
        getValue: function (e) {
            var i;
            if ($(e).attr("type") === "radio") {
                i = $(e + ":checked").val()
            } else {
                i = $(e).map(function () {
                    if ($(this).attr("type") === "checkbox") {
                        return this.checked ? this.value : false
                    } else {
                        return $(this).val()
                    }
                }).get();
                if (i.length === 1) {
                    i = i[0]
                }
            }
            return i
        },
        actions: {
            show: function (e) {
                e.removeClass('shortcode-addons-hidden-control')
            },
            hide: function (e) {
                e.addClass('shortcode-addons-hidden-control')
            },
            clearFields: function (e) {
                e.find("select, input").each(function () {
                    if ($(this).attr("type") === "radio" || $(this).attr("type") === "checkbox") {
                        $(this).prop("checked", false)
                    } else {
                        $(this).val("")
                    }
                    $(this).trigger("change")
                })
            },
            trigger: function (i, e) {
                e = e.replace(",", " ");
                e.split(" ").forEach(function (e) {
                    i.trigger(e)
                })
            }
        }
    })
})(jQuery);