<?php

// Woocommerce
Ecohorbor_Options::ecohorbor_set_section( array(
	'title'      => esc_html__( 'Woocommerce', 'ecohorbor-addon' ),
	'id'         => 'woocommerce-tab',
	'config_id'  => '',
) );

Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Shop', 'ecohorbor-addon' ),
	'id'         => 'shop-tab',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'shop-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Shop Page Title Settings', 'ecohorbor-addon' ),
			'desc'	=> esc_html__( 'This is settings for shop page title.', 'ecohorbor-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'shop-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Shop Page Title', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Shop Page title section.', 'ecohorbor-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'shop-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Shop Page Title Elements', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Shop Page Title section using a drag-and-drop interface.', 'ecohorbor-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'ecohorbor-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'ecohorbor-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'ecohorbor-addon' )
				)
			),
		),
		array(
			'id'			=> 'shop-title-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Shop Page Title Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Set the color for the title of the shop page.', 'ecohorbor-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-desc-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Shop Page Title Description Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Set the color for the description of the shop page.', 'ecohorbor-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Shop Page Title Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Set the color for the hyperlinks of the shop page title. Like breadcrumbs color.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Shop Page Title Padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the shop page Title section.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Shop Page Title Background Options', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose background settings for the Shop Page Title section, including color, image, size, etc.', 'ecohorbor-addon' ),
			'required'		=> array( 'shop-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'shop-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Shop Page Layout Settings', 'ecohorbor-addon' ),
			'desc'	=> esc_html__( 'This is settings for shop page layout.', 'ecohorbor-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'shop-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Shop Single Post Sidebar Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose the position of the shop page sidebar, such as left, right, both or no-sidebar (full-width).', 'ecohorbor-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'shop-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Shop Page Right Widgets Area', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the shop page.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'shop-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Shop Page Left Widgets Area', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the shop page.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'shop-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );

Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Product', 'ecohorbor-addon' ),
	'id'         => 'product-tab',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'product-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Product Page Title Settings', 'ecohorbor-addon' ),
			'desc'	=> esc_html__( 'This is settings for product page title.', 'ecohorbor-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'product-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Product Page Title', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Product Page title section.', 'ecohorbor-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'product-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Product Page Title Elements', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Product Page Title section using a drag-and-drop interface.', 'ecohorbor-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'ecohorbor-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'ecohorbor-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'ecohorbor-addon' )
				)
			),
		),
		array(
			'id'			=> 'product-title-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Product Page Title Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Set the color for the title of the Product page.', 'ecohorbor-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-desc-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Product Page Title Description Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Set the color for the description of the Product page.', 'ecohorbor-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Product Page Title Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Set the color for the hyperlinks of the Product page title. Like breadcrumbs color.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Product Page Title Padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the product page Title section.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Product Page Title Background', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose background settings for the Product Page Title section, including color, image, size, etc.', 'ecohorbor-addon' ),
			'required'		=> array( 'product-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'product-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Product Page Layout Settings', 'ecohorbor-addon' ),
			'desc'	=> esc_html__( 'This is settings for product page layout.', 'ecohorbor-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'product-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Product Single Post Sidebar Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose the position of the product page sidebar, such as left, right, both or no-sidebar (full-width).', 'ecohorbor-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'product-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Product Page Right Widgets Area', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the product page.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'product-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Product Page Left Widgets Area', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the product page.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'product-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );

Ecohorbor_Options::ecohorbor_set_end_section( array(
	'id'		=> 'woocommerce-end'	
));