<?php

/**
 * Ecohorbor Theme Options
 * @since 1.0.0
 */
final class Ecohorbor_Plugin_Options { //ecohorbor_admin_menu_out
	
	private static $_instance = null;
	
	public function __construct() {	
		add_action( 'admin_menu', array( $this, 'ecohorbor_addon_options_menu' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'ecohorbor_framework_admin_scripts' ) );
		$this->init();

		//import
		add_action( 'wp_ajax_bridddge-theme-option-import', array( $this, 'ecohorbor_redux_themeopt_import' ) );

		//export
		add_action('wp_ajax_ecohorbor-theme-options-export', array( $this, 'ecohorbor_theme_options_export' ) );
		
	}
	
	public static function ecohorbor_addon_options_menu(){
		add_submenu_page( 
			'ecohorbor-welcome', 
			esc_html__( 'Theme Options', 'ecohorbor-addon' ),
			esc_html__( 'Theme Options', 'ecohorbor-addon' ), 
			'manage_options', 
			'ecohorbor-options', 
			array( 'Ecohorbor_Plugin_Options', 'ecohorbor_options_admin_page' )
		);
	}
	
	public static function ecohorbor_framework_admin_scripts(){
		if( isset( $_GET['page'] ) && $_GET['page'] == 'ecohorbor-options' ){
			wp_enqueue_style( 'font-awesome', ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/css/font-awesome.min.css', array(), '4.7.0', 'all' );			
			wp_enqueue_style( 'bootstrap-icons', ECOHORBOR_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
			
			wp_enqueue_media();
			wp_enqueue_style( 'ecohorbor_theme_options_css', ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/css/theme-options.css', array(), '1.0', 'all' );
			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker-alpha', ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/js/wp-color-picker-alpha.min.js', array( 'jquery', 'wp-color-picker' ), '3.0.0' );
			wp_enqueue_script( 'ecohorbor_theme_options_js', ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/js/theme-options.js',  array( 'jquery' ), '1.0', true );

			wp_localize_script( 'ecohorbor_theme_options_js', 'ecohorbor_ajax_object',
				array(
					'import_nonce' => wp_create_nonce( 'ecohorbor-import-*&^F&' ),
					'export_nonce' => wp_create_nonce( 'ecohorbor-export-&^%$)' ),
				)
			);

			require_once ECOHORBOR_ADDON_DIR . 'admin/extension/theme-options/googlefonts.php';
			$google_fonts = Ecohorbor_Google_Fonts_Function::$_google_fonts;
			$google_fonts_arr = json_decode( $google_fonts, true );
			
			$extra_gf = array(
				"Spartan" => array(
					"variants" => array(
						array( "id" => "400", "name" => "Thin 100" ),
						array( "id" => "400", "name" => "Extra-light 200" ),
						array( "id" => "400", "name" => "Light 300" ),
						array( "id" => "400", "name" => "Regular 400" ),
						array( "id" => "400", "name" => "Medium 500" ),
						array( "id" => "400", "name" => "Semi-bold 600" ),
						array( "id" => "400", "name" => "Bold 700" ),
						array( "id" => "400", "name" => "Extra-bold 800" ),
						array( "id" => "400", "name" => "Black 900" )
					)
				)
			);
			if( is_array( $extra_gf ) && !empty( $extra_gf ) ){
				foreach( $extra_gf as $font => $details ) $google_fonts_arr[$font] = $details;
			}
			
			$google_fonts = json_encode( $google_fonts_arr );
			$google_fonts_vars = array(
				'google_fonts' => $google_fonts,
				'standard_font_variants' => Ecohorbor_Google_Fonts_Function::$_standard_font_variants,
				'font_variants_default' => esc_html__( 'Font Weight &amp; Style', 'ecohorbor-addon' ),
				'font_sub_default' => esc_html__( 'Font Subsets', 'ecohorbor-addon' )
			);
			wp_localize_script( 'ecohorbor_theme_options_js', 'google_fonts_vars', $google_fonts_vars );
			
		}
	}
	
	public function init() {
		require_once( ECOHORBOR_ADDON_DIR . 'admin/extension/theme-options/framework.php' );
		Ecohorbor_Options::$opt_name = 'ecohorbor_options';
	}
		
	public static function ecohorbor_options_admin_page(){	
		$ecohorbor_theme = wp_get_theme();
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p><strong>Important Notice for Existing Users:</strong> We’ve made a significant update to the theme by removing the email and address fields while introducing flexible HTML fields for greater customization. If needed, you can now add these details manually using the new HTML fields. <a href="https://zozothemes.com/update-notice" target="_blank">Learn more about this update</a>.</p>';
		echo '</div>';
		?>	
		<form method="post" action="#" enctype="multipart/form-data" id="ecohorbor-plugin-form-wrapper">
			<div class="ecohorbor-settings-wrap">
			<div class="ecohorbor-header-bar">
				<div class="ecohorbor-header-left">
					<div class="ecohorbor-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="ecohorbor-logo">
					</div><!-- .ecohorbor-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Ecohorbor Options', 'ecohorbor-addon' ); ?><span class="ecohorbor-version"><?php echo esc_attr( $ecohorbor_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<?php
						include_once(ABSPATH . 'wp-admin/includes/plugin.php');
						$is_ecohorbor_addon_active = is_plugin_active('ecohorbor-addon/ecohorbor-addon.php');
						$current_theme = wp_get_theme();
						$is_theme_active = ($current_theme->get('Name') === 'Ecohorbor');
						$verfied_stat = get_option('verified_purchase_status');

						if ($is_ecohorbor_addon_active) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-options') . '" class="active-page"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						} else {
							echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Ecohorbor Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						}
						if ($verfied_stat) {
							echo '<a href="' . admin_url('admin.php?page=ecohorbor-plugins') . '"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						} else {
							echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Ecohorbor theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						}
						?>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="https://docs.zozothemes.com/ecohorbor/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .ecohorbor-header-left -->
				<div class="ecohorbor-header-right">
					<button type="submit" class="button ecohorbor-btn"><?php esc_html_e( 'Save Settings', 'ecohorbor-addon' ); ?></button>
				</div><!-- .ecohorbor-header-right -->
			</div><!-- .ecohorbor-header-bar -->	
				
				<div class="ecohorbor-inner-wrap">
						
					<?php
						if ( isset( $_POST['save_ecohorbor_theme_options'] ) && wp_verify_nonce( $_POST['save_ecohorbor_theme_options'], 'ecohorbor_theme_options*&^&*$' ) ) {
							update_option( 'ecohorbor_options', $_POST['ecohorbor_options'] );
							require_once ( ECOHORBOR_ADDON_DIR . 'admin/extension/theme-options/theme-options-css.php' );
						}
						//Get updated theme option
						Ecohorbor_Options::$ecohorbor_options = get_option('ecohorbor_options');
						
						if( class_exists( 'Classic_Elementor_Addon' ) ){
							add_action( 'ecohorbor_custom_template_options', function(){
								require_once ECOHORBOR_ADDON_DIR . 'admin/extension/theme-options/cea-config.php';
							});
						}
						//Theme config
						require_once ECOHORBOR_ADDON_DIR . 'admin/extension/theme-options/config.php';
					?>
					<div class="ecohorbor-admin-content-wrap">
						<?php wp_nonce_field( 'ecohorbor_theme_options*&^&*$', 'save_ecohorbor_theme_options' ); ?>
						<div class="ecohorbor-tab">
							<div class="ecohorbor-tab-list">
								<ul class="tablinks-list">
									<?php Ecohorbor_Options::ecohorbor_put_section(); 
										if (is_plugin_active('classic-elementor-addons-pro/index.php')): ?>
											<div class="ecohorbor-navigation-buttons">
												<a href="<?php echo admin_url('admin.php?page=classic-addons'); ?>" target="_blank" class="button ecohorbor-btn"><i class="fa fa-caret-square-o-left" aria-hidden="true"></i><?php esc_html_e('CEA Plugin Options', 'ecohorbor'); ?></a>
											</div>
										<?php endif; 
									?>
								</ul>
							</div><!-- .ecohorbor-tab-list -->
							<div class="ecohorbor-tab-contents">
								
							<!-- <a href="https://docs.zozothemes.com/ecohorbor/" target="_blank" class="docs-tooltip" title="Documentation"><span class="dashicons dashicons-editor-help theme-info"></span></a> -->
								<?php Ecohorbor_Options::ecohorbor_put_field(); ?>
							</div><!-- .ecohorbor-tab-contents -->
						</div><!-- .ecohorbor-tab -->					
					</div><!-- .ecohorbor-admin-content-wrap -->					
				</div><!-- .ecohorbor-inner-wrap -->
			</div><!-- .ecohorbor-settings-wrap -->
			<div class="ecohorbor-db-footer">
					<div class="ecohorbor-db-footer-top">
						<nav class="ecohorbor-db-footer-menu">
						<div class="copyright-text-wrap">Copyrights  © <script>document.write(new Date().getFullYear())</script> Designed by 
						<a href="https://zozothemes.com/" class="theme-color" target="_blank">Zozothemes <span class="heart-color">♥</span></a></div>
							<ul>
								<li>
									<a href="https://docs.zozothemes.com/ecohorbor/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Documentation', 'ecohorbor-addon' ); ?></a>
								</li>
								<li>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Video Tutorials', 'ecohorbor--addon' ); ?></a>
								</li>
								<li>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Submit A Ticket', 'ecohorbor--addon' ); ?></a>
								</li>
							</ul>
						</nav>
					</div>
			</div>
		</form>	
	<?php
	}

	public static function ecohorbor_theme_options_export(){
		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : '';
		if ( ! wp_verify_nonce( $nonce, 'ecohorbor-export-&^%$)' ) )
			die ( esc_html__( 'Busted!', 'ecohorbor-addon' ) );
		
		$ecohorbor_options = get_option( 'ecohorbor_options');
		$ecohorbor_options = is_array( $ecohorbor_options ) ? array_map( 'stripslashes_deep', $ecohorbor_options ) : stripslashes( $ecohorbor_options );
		echo json_encode( $ecohorbor_options );
		
		exit;
	}

	public static function ecohorbor_redux_themeopt_import(){
		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : ''; //Sanitize
		if ( ! wp_verify_nonce( $nonce, 'ecohorbor-import-*&^F&' ) )
			die ( esc_html__( 'Busted', 'ecohorbor-addon' ) );
		
		$json_data = isset( $_POST['json_data'] ) ? stripslashes( urldecode( $_POST['json_data'] ) ) : '';
		$theme_opt_arr = json_decode( $json_data, true );
		if( !empty( $theme_opt_arr ) ){
			update_option( 'ecohorbor_options', $theme_opt_arr );
		}
		
		wp_die('success');
	}
	
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

}

Ecohorbor_Plugin_Options::instance();