<?php

Ecohorbor_Options::$ecohorbor_options = get_post_meta( get_the_ID(), 'ecohorbor_post_meta', true );

// General
Ecohorbor_Options::ecohorbor_set_section( array(
	'title'      => esc_html__( 'General', 'ecohorbor-addon' ),
	'id'         => 'general-tab',
	'config_id'  => '',
) );

Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Site General', 'ecohorbor-addon' ),
	'id'         => 'site-general',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'general-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Site General Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit site general settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'site-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Site Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose site layout either wide or boxed.', 'ecohorbor-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'general-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'content-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Content Padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Assign content padding. If need no padding means just leave this empty. Example 10 10 10 10', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'general-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-slider',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Header Slider', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Enter shortcode for header slider.', 'ecohorbor-addon' ),
			'default'		=> '',
		)		
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Logo Settings', 'ecohorbor-addon' ),
	'id'         => 'site-logo',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'logo-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Site General Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit site logo settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'logo-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Logo Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is settings for site logo.', 'ecohorbor-addon' ),
			'seperator'		=> 'after',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Default Logo', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose site logo image.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Site Logo Maximum Width', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is maximum width of logo. if you want original width leave this field empty.', 'ecohorbor-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo-desc',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable Site Logo Description', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is logo description options for this site. You can enable or disable.', 'ecohorbor-addon' ),
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'sticky-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Sticky Logo', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose site sticky logo image.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'sticky-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Sticky Logo Maximum Width', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is maximum width of sticky logo. if you want original width leave this field empty.', 'ecohorbor-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Mobile Logo', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose site mobile logo image.', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Mobile Logo Maximum Width', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is maximum width of mobile logo. if you want original width leave this field empty.', 'ecohorbor-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
	)
) );

Ecohorbor_Options::ecohorbor_set_end_section( array(
	'id'		=> 'general-tab-end'	
));

$ecohorbor_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
$ecohorbor_nav_menus = array( "none" => esc_html__( "None", "ecohorbor-addon" ) );
foreach( $ecohorbor_menus as $menu ){
	$ecohorbor_nav_menus[$menu->slug] = $menu->name;
}

// Header
Ecohorbor_Options::ecohorbor_set_section( array(
	'title'      => esc_html__( 'Site Header', 'ecohorbor-addon' ),
	'id'         => 'header-tab',
	'config_id'  => '',
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'General', 'ecohorbor-addon' ),
	'id'         => 'header-general',
	'fields'	 => array(
		array(
			'id'			=> 'header-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-one-page-menu',
			'type'			=> 'select',
			'title'			=> esc_html__( 'One Page Menu', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header settings options.', 'ecohorbor-addon' ),
			'choices'		=> $ecohorbor_nav_menus,
			'default'		=> 'none'
		),
		array(
			'id'			=> 'header-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Header Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose header layout either wide or boxed.', 'ecohorbor-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Header Bars', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'These are header items. Drag which items you want to display normal and sticky.', 'ecohorbor-addon' ),
			'default'		=> array(
				'normal' => array(
					'topbar' => esc_html__( 'Header Top', 'ecohorbor-addon' ),
					'logobar' => esc_html__( 'Header Middle', 'ecohorbor-addon' )
				),
				'sticky' => array(
					'navbar' => esc_html__( 'Header Bottom', 'ecohorbor-addon' )
				),
				'disabled' => array(
				)
			),
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-absolute',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Header Absolute', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Enable/Disable header absolute. Like floating on slider', 'ecohorbor-addon' ),
			'default'		=> false,
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'search-type',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Search Toggle Modal', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Slect search box type', 'ecohorbor-addon' ),
			'choices'		=> array(
				'1'	=> esc_html__( 'Full Screen Search', 'ecohorbor-addon' ),
				'2' => esc_html__( 'Text Box Toggle Search', 'ecohorbor-addon' ),
				'3' => esc_html__( 'Full Bar Toggle Search', 'ecohorbor-addon' ),
				'4' => esc_html__( 'Bottom Seach Box Toggle', 'ecohorbor-addon' )
			),
			'default'		=> '1',
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Style Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header style settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Border', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is border setting for header', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header margin', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		)
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Header Top', 'ecohorbor-addon' ),
	'id'         => 'header-topbar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-topbar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Top Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header top settings.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'topbar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__( 'Custom Text 1', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    		=> 'topbar-custom-text-1',
							'type'  		=> 'textarea',
							'title' 		=> esc_html__( 'Custom Text 1', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the top bar of the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'topbar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Custom Text 2', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the top bar of the site.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'topbar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'topbar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable' => true,
				),
				'topbar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'ecohorbor-addon'),
					'description' => esc_html__( 'Adds a vertical bar (|) between elements to visually separate them.', 'ecohorbor-addon' ),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'ecohorbor-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','ecohorbor-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'ecohorbor-addon' ),
						),
						array(
							'id'	=> 'signin-register-text',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'ecohorbor-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'ecohorbor-addon' ),
				),
				'center' => array(
				),
				'right' => array(
				),
				'disabled' => array(
					'search' 		        => esc_html__( 'Search', 'ecohorbor-addon' ),
					'social'	 			=> esc_html__( 'Social', 'ecohorbor-addon' ),
					'address' 				=> esc_html__( 'Address', 'ecohorbor-addon' ),
					'email' 				=> esc_html__( 'Email', 'ecohorbor-addon' ),
					'signin' 	    		=> esc_html__( 'Signin/Register', 'ecohorbor-addon' ),
					'custom-text-2'  		=> esc_html__( 'Custom Text 2', 'ecohorbor-addon' ),
					'top-menu' 				=> esc_html__( 'Top Menu', 'ecohorbor-addon' ),
					'topbar-spacer-1' 		=> esc_html__( 'Spacer 1', 'ecohorbor-addon' ),
					'topbar-spacer-2'		=> esc_html__( 'Spacer 2', 'ecohorbor-addon' ),
					'topbar-spacer-3'		=> esc_html__( 'Spacer 3', 'ecohorbor-addon' ),
					'topbar-html-1' 		=> esc_html__( 'HTML 1', 'ecohorbor-addon' ),
					'topbar-html-2'			=> esc_html__( 'HTML 2', 'ecohorbor-addon' ),
					'topbar-html-3' 		=> esc_html__( 'HTML 3', 'ecohorbor-addon' ),
					'topbar-html-4' 		=> esc_html__( 'HTML 4', 'ecohorbor-addon' ),
					'topbar-html-5' 		=> esc_html__( 'HTML 5', 'ecohorbor-addon' ),
					'topbar_delimiter1' 	=> esc_html__('|', 'ecohorbor-addon'),
					'topbar_delimiter2' 	=> esc_html__('|', 'ecohorbor-addon'),
					'topbar_delimiter3' 	=> esc_html__('|', 'ecohorbor-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'ecohorbor-addon'),
				), 
			),
			'required'		=> array( 'header-topbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Top Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header top styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-topbar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Top Style Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header top style settings.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-topbar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Top Height', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is height property of header top.', 'ecohorbor-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Top Sticky Height', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky topbar.', 'ecohorbor-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-topbar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Top Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header top', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Top Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header top', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Top Border', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is border setting for header top', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Top padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header top', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Top margin', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header top', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-topbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Top Sticky Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header top sticky styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Top Sticky Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header top on sticky', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Top Sticky Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header top on sticky', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),	
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Header Middle', 'ecohorbor-addon' ),
	'id'         => 'header-logobar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-logobar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Middle Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header middle settings.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'logobar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__( 'Custom Text 1 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar-custom-text-1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Custom Text 1', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the Header Middle of the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'logobar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Custom Text 2', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the Header Middle of the site.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'logobar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    		=> 'logobar_html_1',
							'type'  		=> 'textarea',
							'title' 		=> esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'ecohorbor-addon'),
							'description' => esc_html( 'Set the spacer width to control layout spacing.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'ecohorbor-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','ecohorbor-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'ecohorbor-addon' ),
						),
						array(
							'id'	=> 'signin-register-text',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'ecohorbor-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'right' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'ecohorbor-addon' ),
				),
				'center' => array(
				),
				'left' => array(
				),
				'disabled' => array(
					'logo' 					=> esc_html__( 'Logo', 'ecohorbor-addon' ),
					'search'				=> esc_html__( 'Search', 'ecohorbor-addon' ),
					'social'	 			=> esc_html__( 'Social', 'ecohorbor-addon' ),
					'address' 				=> esc_html__( 'Address', 'ecohorbor-addon' ),
					'email' 				=> esc_html__( 'Email', 'ecohorbor-addon' ),
					'secondary-bar' 		=> esc_html__( 'Secondary Bar', 'ecohorbor-addon' ),
					'signin' 				=> esc_html__( 'Signin/Register', 'ecohorbor-addon' ),
					'custom-text-2'			=> esc_html__( 'Custom Text 2', 'ecohorbor-addon' ),
					'primary-menu' 			=> esc_html__( 'Primary Menu', 'ecohorbor-addon' ),
					'logobar-spacer-1' 		=> esc_html__( 'Spacer 1', 'ecohorbor-addon' ),
					'logobar-spacer-2'		=> esc_html__( 'Spacer 2', 'ecohorbor-addon' ),
					'logobar-spacer-3'		=> esc_html__( 'Spacer 3', 'ecohorbor-addon' ),
					'logobar-html-1' 		=> esc_html__( 'HTML 1', 'ecohorbor-addon' ),
					'logobar-html-2'		=> esc_html__( 'HTML 2', 'ecohorbor-addon' ),
					'logobar-html-3' 		=> esc_html__( 'HTML 3', 'ecohorbor-addon' ),
					'logobar-html-4' 		=> esc_html__( 'HTML 4', 'ecohorbor-addon' ),
					'logobar-html-5' 		=> esc_html__( 'HTML 5', 'ecohorbor-addon' ),
					'logobar_delimiter1' 	=> esc_html__( '|', 'ecohorbor-addon'),
					'logobar_delimiter2' 	=> esc_html__( '|', 'ecohorbor-addon'),
					'logobar_delimiter3' 	=> esc_html__( '|', 'ecohorbor-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'ecohorbor-addon'),
				),
			),
			'required'		=> array( 'header-logobar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Middle Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header middle styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-logobar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Middle Style Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header middle bar style settings.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-logobar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Middle Height', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is height property of header middle.', 'ecohorbor-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Middle Sticky Height', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky logobar.', 'ecohorbor-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-logobar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Middle Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header middle', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header middle', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Middle Border', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is border setting for header middle', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Middle padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header middle', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Middle margin', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header middle', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-logobar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Middle Sticky Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header middle sticky styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Middle Sticky Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header middle on sticky', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Middle Sticky Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header middle on sticky', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Header Bottom', 'ecohorbor-addon' ),
	'id'         => 'header-navbar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-navbar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Bottom Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header navbar settings.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'            => 'navbar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__('Custom Text 1 Editor', 'ecohorbor-addon'),
					'fields'      => array(
						array(
							'id'    => 'navbar-custom-text-1',
							'type'  => 'textarea',
							'title' => esc_html__('Custom Text 1', 'ecohorbor-addon'),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the nav bar of the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'navbar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Custom Text 2', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the nav bar of the site.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'navbar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'ecohorbor-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'ecohorbor-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'ecohorbor-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'ecohorbor-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'ecohorbor-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'ecohorbor-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'ecohorbor-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'ecohorbor-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'ecohorbor-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'ecohorbor-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'ecohorbor-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'ecohorbor-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','ecohorbor-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'ecohorbor-addon' ),
						),
						array(
							'id'	=> 'signin-register-text',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'ecohorbor-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'ecohorbor-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'ecohorbor-addon' ),
				),
				'center' => array(
				),
				'right' => array(
				),
				'disabled' => array(
					'logo' => esc_html__( 'Logo', 'ecohorbor-addon' ),
					'search' => esc_html__( 'Search', 'ecohorbor-addon' ),
					'social'	 	=> esc_html__( 'Social', 'ecohorbor-addon' ),
					'address' 		=> esc_html__( 'Address', 'ecohorbor-addon' ),
					'email' 		=> esc_html__( 'Email', 'ecohorbor-addon' ),
					'secondary-bar' => esc_html__( 'Secondary Bar', 'ecohorbor-addon' ),
					'signin' 		=> esc_html__( 'Signin/Register', 'ecohorbor-addon' ),
					'custom-text-2' => esc_html__( 'Custom Text 2', 'ecohorbor-addon' ),
					'primary-menu' 			=> esc_html__( 'Primary Menu', 'ecohorbor-addon' ),
					'navbar-spacer-1' 		=> esc_html__( 'Spacer 1', 'ecohorbor-addon' ),
					'navbar-spacer-2'		=> esc_html__( 'Spacer 2', 'ecohorbor-addon' ),
					'navbar-spacer-3'		=> esc_html__( 'Spacer 3', 'ecohorbor-addon' ),
					'navbar-html-1' 		=> esc_html__( 'HTML 1', 'ecohorbor-addon' ),
					'navbar-html-2'			=> esc_html__( 'HTML 2', 'ecohorbor-addon' ),
					'navbar-html-3' 		=> esc_html__( 'HTML 3', 'ecohorbor-addon' ),
					'navbar-html-4' 		=> esc_html__( 'HTML 4', 'ecohorbor-addon' ),
					'navbar-html-5' 		=> esc_html__( 'HTML 5', 'ecohorbor-addon' ),
					'navbar_delimiter1' 	=> esc_html__('|', 'ecohorbor-addon'),
					'navbar_delimiter2' 	=> esc_html__('|', 'ecohorbor-addon'),
					'navbar_delimiter3' 	=> esc_html__('|', 'ecohorbor-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'ecohorbor-addon'),
				),
			),
			'required'		=> array( 'header-navbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Bottom Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header navbar styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-navbar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Bottom Style Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit Header Middle style settings.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-navbar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Bottom Height', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is height property of header navbar.', 'ecohorbor-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Bottom Sticky Height', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky navbar.', 'ecohorbor-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-navbar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Bottom Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header navbar', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header navbar', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Bottom Border', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is border setting for header navbar', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Bottom padding', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header navbar', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header Bottom margin', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header navbar', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-navbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Bottom Sticky Styles', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header navbar sticky styles.', 'ecohorbor-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Bottom Sticky Link Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header navbar on sticky', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Bottom Sticky Background Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background setting for header navbar on sticky', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_end_section( array(
	'id'		=> 'header-tab-end'	
));

//Layout Settings
Ecohorbor_Options::ecohorbor_set_section( array(
	'title'      => esc_html__( 'Layout', 'ecohorbor-addon' ),
	'id'         => 'post-layout',
	'config_id'  => '',
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Page Title', 'ecohorbor-addon' ),
	'id'         => 'page-title-options',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'page-title-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Page Title', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit page title options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'page-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Enable or disable blog page title section', 'ecohorbor-addon' ),
			'default'		=> true,
			'required'		=> array( 'page-title-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'page-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Blog Page Title Elements', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'These are blog page title elements. Drag which items you want to display left, center and right part.', 'ecohorbor-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'ecohorbor-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'ecohorbor-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'ecohorbor-addon' )
				)
			),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Page Title Background', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background settings of page title.', 'ecohorbor-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-overlaycolor',
			'type'			=> 'color',
			'alpha'			=> true,
			'title'			=> esc_html__( 'Page Title Overlay Color', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This color will be displayed as in Page title overlaycolor. Choose light colors to make it displayed over the image.', 'ecohorbor-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-custom-class',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Page Title Custom Class', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is setting for add custom class name to page title wrapper.', 'ecohorbor-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Sidebar Layout', 'ecohorbor-addon' ),
	'id'         => 'sidebar-layout-options',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'sidebar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Sidebar', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit sidebar layout options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Sidebar Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose sidebar layout.', 'ecohorbor-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar',
			'required'		=> array( 'sidebar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Right Widgets Area', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widget for right widget area', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Left Widgets Area', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widget for left widget area', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );
Ecohorbor_Options::ecohorbor_set_end_section( array(
	'id'		=> 'post-layout-end'	
));

// Footer
Ecohorbor_Options::ecohorbor_set_section( array(
	'title'      => esc_html__( 'Site Footer', 'ecohorbor-addon' ),
	'id'         => 'footer-tab',
	'config_id'  => '',
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'General', 'ecohorbor-addon' ),
	'id'         => 'footer-general',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose footer layout either wide or boxed.', 'ecohorbor-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'footer-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Footer Items', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'These are footer items. Drag which items you want to display Enabled and Disabled.', 'ecohorbor-addon' ),
			'default'		=> array(
				'enabled' => array(
					'footer-middle' => esc_html__( 'Footer Widgets', 'ecohorbor-addon' ),
					'footer-bottom' => esc_html__( 'Copyright Section', 'ecohorbor-addon' )
				),
				'disabled' => array(
					'footer-top' => esc_html__( 'Footer Top', 'ecohorbor-addon' ),
				)
			),
			'required'		=> array( 'footer-chk', '=', array( 'custom' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Footer Top', 'ecohorbor-addon' ),
	'id'         => 'footer-insta',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'insta-footer-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Top Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit insta footer settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'insta-footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Top Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose insta footer layout either wide or boxed.', 'ecohorbor-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'insta-footer-chk', '=', array( 'custom' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Footer Widgets', 'ecohorbor-addon' ),
	'id'         => 'footer-widgets',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-middle-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Widgets Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer middle settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'widgets-footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Widgets Footer Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widgets footer layout either wide or boxed.', 'ecohorbor-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'boxed',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widgets-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Widgets Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose footer widgets layout.', 'ecohorbor-addon' ),
			'items'		=> array(
				'3-3-3-3' => array(
					'title' => esc_html__( 'Column 3/3/3/3', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-3-3.png'
				),
				'3-3-6' => array(
					'title' => esc_html__( 'Column 3/3/6', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-6.png'
				),
				'12' => array(
					'title' => esc_html__( 'Column 12', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-12.png'
				),
				'4-4-4' => array(
					'title' => esc_html__( 'Column 4/4/4', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-4-4.png'
				),
				'4-8' => array(
					'title' => esc_html__( 'Column4/8', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-8.png'
				),
				'6-3-3' => array(
					'title' => esc_html__( 'Column 6/3/3', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-6-3-3.png'
				),
				'8-4' => array(
					'title' => esc_html__( 'Column 8/4', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-8-4.png'
				)
			),
			'default' => '12',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widget-1',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 1', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 1', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widget-2',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 2', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 2', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '!=', array( '12' ) )
		),
		array(
			'id'			=> 'footer-widget-3',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 3', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 3', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3', '3-3-6', '4-4-4', '6-3-3' ) )
		),
		array(
			'id'			=> 'footer-widget-4',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 4', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 4', 'ecohorbor-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Copyright Section', 'ecohorbor-addon' ),
	'id'         => 'copyright-section',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-bottom-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Widgets Settings', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer middle settings options.', 'ecohorbor-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'ecohorbor-addon' ),
				'custom'	=> esc_html__( 'Custom', 'ecohorbor-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'footer-bottom-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Bottom Layout', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'Choose footer bottom layout either wide or boxed.', 'ecohorbor-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'boxed',
			'required'		=> array( 'footer-bottom-chk', '=', array( 'custom' ) )
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_end_section( array(
	'id'		=> 'footer-end'	
));


/*
//All Fields
Ecohorbor_Options::ecohorbor_set_section( array(
	'title'      => esc_html__( 'All Fields', 'ecohorbor-addon' ),
	'id'         => 'all-fields'
) );
Ecohorbor_Options::ecohorbor_set_sub_section( array(
	'title'      => esc_html__( 'Fields', 'ecohorbor-addon' ),
	'id'         => 'un-fields-tab',
	'fields'	 => array(
		array(
			'id'			=> 'test_text_field',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Text Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is text field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_textarea_field',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Textarea Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is textarea field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_select_field',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Select Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is select field', 'ecohorbor-addon' ),
			'choices'		=> array(
				'1'	=> 'One',
				'2'	=> 'Two',
				'3'	=> 'Three'
			),
			'default'		=> '2'
		),
		array(
			'id'			=> 'test_color_field',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Color Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is color field', 'ecohorbor-addon' ),
			'alpha'			=> false,
			'default'		=> '#111111'
		),
		array(
			'id'			=> 'test_link_field',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Link Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is link field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'ajax-trigger-fonts-test',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Google Fonts Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is fonts field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'background_test',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Background Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is background field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'image_test',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Image Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is image field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'border_test',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Border Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is border field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'dimension_test',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Dimension Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is dimension field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'hw_test',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Width/Height Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is width height field', 'ecohorbor-addon' ),
			'only_dimension' => 'both'
		),
		array(
			'id'			=> 'toggle_test',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Toggle Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is toggle field', 'ecohorbor-addon' )
		),
		array(
			'id'			=> 'sidebars_test',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Sidebars Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is sidebars field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'pages_test',
			'type'			=> 'pages',
			'title'			=> esc_html__( 'Pages Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is pages field', 'ecohorbor-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'multicheck_test',
			'type'			=> 'multicheck',
			'title'			=> esc_html__( 'Multi Check Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is multi check box field', 'ecohorbor-addon' ),
			'items'		=> array(
				'one' => esc_html__( 'One', 'ecohorbor-addon' ),
				'two' => esc_html__( 'Two', 'ecohorbor-addon' ),
				'three' => esc_html__( 'Three', 'ecohorbor-addon' ),
				'four' => esc_html__( 'Four', 'ecohorbor-addon' ),
				'five' => esc_html__( 'Five', 'ecohorbor-addon' )
			)
		),
		array(
			'id'			=> 'radioimage_test',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Radio Image Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is radio image field', 'ecohorbor-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'ecohorbor-addon' ),
					'url' => ECOHORBOR_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'left-sidebar'
		),
		array(
			'id'			=> 'dragdrop_test',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Drag Drop Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is drag and drop field', 'ecohorbor-addon' ),
			'default'		=> array(
				'enabled' => array(
					'one' => esc_html__( 'One', 'ecohorbor-addon' ),
					'two' => esc_html__( 'Two', 'ecohorbor-addon' )
				),
				'disabled' => array(
					'three' => esc_html__( 'Three', 'ecohorbor-addon' ),
					'four' => esc_html__( 'Four', 'ecohorbor-addon' ),
					'five' => esc_html__( 'Five', 'ecohorbor-addon' )
				)
			)
		),
		array(
			'id'			=> 'test_label_field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Label Field', 'ecohorbor-addon' ),
			'description'	=> esc_html__( 'This is label field', 'ecohorbor-addon' ),
			'seperator'		=> 'after'
		),
	)
) );
Ecohorbor_Options::ecohorbor_set_end_section( array(
	'id'		=> 'all-fields-end'	
));*/