/*
 * Zozo Megamenu Framework
 * 
 */
( function( $ ) {
	"use strict";
	
	var _cur_menu = '';
	var _cur_json = '';
	var _cur_depth = '';
	var _parent_0 = '';
	var _t_cur_json = '';

	$(document).ready(function() {
		
		$(document).find('.ecohorbor-general-settings-form').magnificPopup({
			type: 'inline',
			preloader: false,
			callbacks: {
				close: function() {
					$("#ecohorbor-general-settings-form").removeClass("megamenu-actived menu-depth-"+_cur_depth);
				},
				beforeOpen: function() {

					_cur_menu = _cur_json = _cur_depth = _t_cur_json = '';

					_cur_menu = "#edit-menu-item-ecohorbor-" + $(this.st.el).data("menu");
					_cur_depth = $(this.st.el).data("depth");
					_cur_json = JSON.parse($(_cur_menu).val());

                    if( _cur_json.icon ) $("select.ecohorbor-menu-icons").val(_cur_json.icon);
                    else $("select.ecohorbor-menu-icons").val(null);

					if( _cur_json.megamenu ) $("input.ecohorbor-megamenu-option").prop( "checked", true );
					else $("input.ecohorbor-megamenu-option").prop( "checked", false );

					if( _cur_json.megamenucol ) $("select.ecohorbor-megamenu-col").val(_cur_json.megamenucol);
					else $("select.ecohorbor-megamenu-col").val('12');

					if( _cur_json.megamenuwidget ) $("select.ecohorbor-megamenu-widget").val(_cur_json.megamenuwidget);
					else $("select.ecohorbor-megamenu-widget").val(null);

					$("#ecohorbor-general-settings-form").addClass("menu-depth-"+_cur_depth);
					if( _cur_depth !== 0 ) {
						_cur_json.megamenu = 0;
						_parent_0 = $(this.st.el).parents("li.menu-item");
						do{
							_parent_0 = $(_parent_0).prev("li.menu-item");
						}while( !$(_parent_0).hasClass("menu-item-depth-0") );
						_t_cur_json = JSON.parse($("#edit-menu-item-ecohorbor-" + $(_parent_0).find(".ecohorbor-general-settings-form").data("menu")).val());
						if( _t_cur_json.megamenu === 1 ) $("#ecohorbor-general-settings-form").addClass("megamenu-actived");
					}

					$("select.ecohorbor-menu-icons").on("change", function(){
						_cur_json.icon = $(this).val();
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});

					$("input.ecohorbor-megamenu-option").on("click", function(){
						_cur_json.megamenu = $(this).prop("checked") ? 1 : 0;
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});

					$("select.ecohorbor-megamenu-col").on("change", function(){
						_cur_json.megamenucol = $(this).val();
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});

					$("select.ecohorbor-megamenu-widget").on("change", function(){
						_cur_json.megamenuwidget = $(this).val();
						$(_cur_menu).val(JSON.stringify(_cur_json));
					});
				}
			}
		});

        var _menu_icons = ecohorbor_object.icons;
        $.each(_menu_icons, function( index, value ) {
            let _icon_code = value[2].replace( "\\", "&#x" );
            $(".ecohorbor-menu-icons").append( '<option value="'+ $.text(value[1]) +'">'+ $.text(value[1].replace('ti-','')) + ' - '+ $.text(_icon_code) +';</option>' );
        });
    });

	
})( jQuery );
