<?php 

class Ecohorbor_Demo_Importer {
	
	private static $_instance = null;
	
	public static $ins_demo_stat;
	
	public static $ins_demo_id;

	public function __construct() {
		
		$this->set_installed_demo_details();
		
		add_action( 'admin_menu', array( $this, 'ecohorbor_addon_admin_menu' ) );
		
		add_action( 'admin_enqueue_scripts', array( $this, 'ecohorbor_enqueue_admin_script' ) );
		
	}
	
	public static function ecohorbor_addon_admin_menu(){
		add_submenu_page( 
			'ecohorbor-welcome', 
			esc_html__( 'Demo Importer', 'ecohorbor-addon' ),
			esc_html__( 'Demo Importer', 'ecohorbor-addon' ), 
			'manage_options', 
			'ecohorbor-importer', 
			array( 'Ecohorbor_Demo_Importer', 'ecohorbor_demo_import_admin_page' )
		);
	}
	
	private function set_installed_demo_details(){
		self::$ins_demo_stat = get_theme_mod( 'ecohorbor_demo_installed' );
		self::$ins_demo_id = get_theme_mod( 'ecohorbor_installed_demo_id' );
	}
	
	public function ecohorbor_enqueue_admin_script(){
		
		if( isset( $_GET['page'] ) && $_GET['page'] == 'ecohorbor-importer' ){
		
			wp_enqueue_style( 'ecohorbor-confirm', ECOHORBOR_ADDON_URL . 'admin/extension/demo-importer/assets/css/jquery-confirm.min.css' );
			wp_enqueue_script( 'ecohorbor-confirm', ECOHORBOR_ADDON_URL . 'admin/extension/demo-importer/assets/js/jquery-confirm.min.js', array( 'jquery' ), '1.0', true ); 
			
			wp_enqueue_script( 'ecohorbor-import-scripts', ECOHORBOR_ADDON_URL . 'admin/extension/demo-importer/assets/js/demo-import.js', array( 'jquery' ), '1.7.5', true ); 
			wp_enqueue_style( 'bootstrap-icons', ECOHORBOR_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
			
			//Import Localize Script
			$demo_import_args = array(
				'admin_ajax_url' => esc_url( admin_url('admin-ajax.php') ),
				'nonce' => wp_create_nonce('ecohorbor-options-import'),		
				'proceed' => esc_html__('Proceed', 'ecohorbor'),
				'cancel' => esc_html__('Cancel', 'ecohorbor'),
				'process' => esc_html__( 'Processing', 'ecohorbor-addon' ),
				'uninstalling' => esc_html__('Uninstalling...', 'ecohorbor'),
				'uninstalled' => esc_html__('Uninstalled.', 'ecohorbor'),
				'unins_pbm' => esc_html__('Uninstall Problem!.', 'ecohorbor'),
				'downloading' => esc_html__('Demo import process running...', 'ecohorbor'), 
				'ecohorbor_import_url' => admin_url( 'admin.php?page=ecohorbor-importer' ),
				'regenerate_thumbnails_url' => admin_url( 'plugin-install.php?tab=plugin-information&plugin=regenerate-thumbnails' )				
			);
			$demo_import_args = apply_filters( 'ecohorbor_demo_import_args', $demo_import_args );
			wp_localize_script( 'ecohorbor-import-scripts', 'ecohorbor_admin_ajax_var', $demo_import_args );
		}
		
	}
	
	public static function ecohorbor_demo_div_generater( $demo_array ){
		
		$ins_demo_stat = self::$ins_demo_stat;
		$ins_demo_id = self::$ins_demo_id;
		
		$demo_class = '';
		if( $ins_demo_stat == 1 ){
			if( $ins_demo_id == $demo_array['demo_id'] ){
				$demo_class .= ' demo-actived';
			}else{
				$demo_class .= ' demo-inactive';
			}
		}else{
			$demo_class .= ' demo-active';
		}
	
		$revslider = isset( $demo_array['revslider'] ) && $demo_array['revslider'] != '' ? $demo_array['revslider'] : '';
		$media_parts = isset( $demo_array['media_parts'] ) && $demo_array['media_parts'] != '' ? $demo_array['media_parts'] : '';
		
		?>
		
		
		<div class="admin-box demo-wrap">
			<div class="install-plugin-wrap theme zozothemes-demo-item<?php echo esc_attr( $demo_class ); ?>">
				<div class="install-plugin-inner">
				
					<div class="zozo-demo-import-loader zozo-preview-<?php echo esc_attr( $demo_array['demo_id'] ); ?>"><i class="dashicons dashicons-admin-generic"></i></div>
					
					<div class="installation-progress">
						<span class="progress-text"></span>
						<div class="progress">
							<div class="progress-bar" style="width:0%"></div>
						</div>
					</div>
				
					<div class="theme-screenshot zozotheme-screenshot">
						<a href="<?php echo esc_url( $demo_array['demo_url'] ); ?>" target="_blank"><img src="<?php echo esc_url( ECOHORBOR_ADDON_URL . 'admin/extension/demo-importer/assets/images/demo/' . $demo_array['demo_img'] ); ?>" class="demo-img" /></a>
					</div>
					<div class="install-plugin-right">
						<div class="install-plugin-right-inner">
							<h3 class="theme-name" id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>"><?php echo esc_attr( $demo_array['demo_name'] ); ?></h3>
							
							<a href="#" class="theme-demo-install-custom"><?php esc_html_e( "Custom Choice", "ecohorbor" ); ?></a>
							
							<div class="theme-demo-install-parts" id="<?php echo esc_attr( 'demo-install-parts-'. $demo_array['demo_id'] ); ?>">
							
								<div class="demo-install-instructions">
									<ul class="install-instructions">
										<li><strong><?php esc_html_e( "General", "ecohorbor" ); ?></strong></li>
										<li><?php esc_html_e( 'Choose "Media" -> All the media\'s are ready to be import.', "ecohorbor" ); ?></li>
										<li><?php esc_html_e( 'Choose "Theme Options" -> Theme options are ready to be import.', "ecohorbor" ); ?></li>
										<li><?php esc_html_e( 'Choose "Widgets" -> Custom sidebars and widgets are ready to be import.', "ecohorbor" ); ?></li>
										<?php if( $revslider ) : ?>
										<li><?php esc_html_e( 'Choose "Revolution Sliders" -> Revolution slides are ready to be import.', "ecohorbor" ); ?></li>
										<?php endif; ?>
										<li><?php esc_html_e( 'Choose "All Posts" -> Posts, menus, custom post types are ready to be import.', "ecohorbor" ); ?></li>
										<li><p class="lead"><strong>*</strong><?php esc_html_e( 'If you check "All Posts" and Uncheck any of page, then menu will not imported.', "ecohorbor" ); ?></p></li>
										
										<li><strong><?php esc_html_e( "Pages", "ecohorbor" ); ?></strong></li>
										<li><?php esc_html_e( 'Choose pages which you want to show on your site. If you choose all the pages and check "All Post" menu will be import. If any one will not check even page or All posts, then menu will not import.', "ecohorbor" ); ?></li>
									</ul>
								</div>
							
								<div class="zozo-col-3">
									<h5><?php esc_html_e( "General", "ecohorbor" ); ?></h5>
									<?php
									if( isset( $demo_array['general'] )	 ){
										echo '<ul class="general-install-parts-list">';
										foreach( $demo_array['general'] as $key => $value ){
											echo '<li><input type="checkbox" value="'. esc_attr( $key ) .'" data-text="'. esc_attr( $value ) .'" /> '. esc_html( $value ) .'</li>';
										}
										echo '</ul>';
									}						
									?>
								</div><!-- .zozo-col-3 -->
								<div class="zozo-col-3">
									<h5><?php esc_html_e( "Pages", "ecohorbor" ); ?></h5>
									<?php
									if( isset( $demo_array['pages'] )	 ){
										echo '<ul class="page-install-parts-list">';
										foreach( $demo_array['pages'] as $key => $value ){
											echo '<li><input type="checkbox" value="'. esc_attr( $key ) .'" data-text="'. esc_attr( $value ) .'" /> '. esc_html( $value ) .'</li>';
										}
										echo '</ul>';
									}						
									?>
								</div><!-- .zozo-col-3 -->
								<a href="#" class="theme-demo-install-checkall"><?php esc_html_e( "Check/Uncheck All", "ecohorbor" ); ?></a>
								<p><?php esc_html_e( "Leave empty/uncheck all to full install.", "ecohorbor" ); ?></p>
							</div><!-- .theme-demo-install-parts -->
							<div class="theme-actions theme-buttons">
								<a class="button button-primary button-install-demo" data-demo-id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>" data-revslider="<?php echo esc_attr( $revslider ); ?>" data-media="<?php echo esc_attr( $media_parts ); ?>" href="#">
								<?php esc_html_e( "Import", "ecohorbor" ); ?>
								</a>
								<a class="button button-primary button-uninstall-demo" data-demo-id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>" href="#">
								<?php esc_html_e( "Uninstall", "ecohorbor" ); ?>
								</a>
								<a class="button button-primary button-preview-demo" target="_blank" href="<?php echo esc_url( $demo_array['demo_url'] ); ?>">
								<?php esc_html_e( "Preview", "ecohorbor" ); ?>
								</a>
							</div>
							
						</div><!-- .install-plugin-right-inner -->
					</div><!-- .install-plugin-right -->
				</div>
			</div><!-- .admin-box -->
		<?php
	}
	
	public static function ecohorbor_demo_import_admin_page(){
		$ecohorbor_theme = wp_get_theme();
	?>
		<div class="ecohorbor-settings-wrap">
		
			<?php wp_nonce_field( 'ecohorbor_demo_import_*&^^$#(*', 'ecohorbor_demo_import_nonce' ); ?>
		
			<div class="ecohorbor-header-bar">
				<div class="ecohorbor-header-left">
					<div class="ecohorbor-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="ecohorbor-logo">
					</div><!-- .ecohorbor-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Ecohorbor Demo Importer', 'ecohorbor-addon' ); ?></h2>
					<div class="nav-theme-options">
						<a href="<?php echo admin_url('admin.php?page=ecohorbor-options'); ?>"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>
						<a href="<?php echo admin_url('admin.php?page=ecohorbor-plugins')?>"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="https://docs.zozothemes.com/ecohorbor/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .ecohorbor-header-left -->
				<div class="ecohorbor-header-right">
					<a href="<?php echo esc_url( 'https://wordpress.zozothemes.com/ecohorbor/' ); ?>" target="_blank" class="button ecohorbor-btn"><?php esc_html_e( 'Live Demo', 'ecohorbor-addon' ); ?></a>
				</div><!-- .ecohorbor-header-right -->
			</div><!-- .ecohorbor-header-bar -->
			
			<div class="ecohorbor-settings-tabs ecohorbor-demo-import-wrap">
				<div id="ecohorbor-general" class="ecohorbor-settings-tab active">
					<div class="container">
						<div class="row">
							<div class="col-6">							
							<?php
								
								//Demo Classic
								$demo_array = array(
									'demo_id' 	=> 'demo',
									'demo_name' => esc_html__( 'Ecohorbor Main Demo', 'ecohorbor-addon' ),
									'demo_img'	=> 'demo-1.jpg',
									'demo_url'	=> 'https://wordpress.zozothemes.com/ecohorbor/',
									'revslider'	=> '6',
									'media_parts'	=> '32',
									'general'	=> array(
										'media' 		=> esc_html__( "Media", "ecohorbor" ),
										'theme-options' => esc_html__( "Theme Options", "ecohorbor" ),
										'widgets' 		=> esc_html__( "Widgets", "ecohorbor" ),
										'revslider' 	=> esc_html__( "Revolution Sliders", "ecohorbor" ),
										'post' 			=> esc_html__( "All Posts", "ecohorbor" )
									),
									'pages'=> array(
										'1'		=> esc_html__( "2 Columns + Sidebar", "ecohorbor" ),
										'2'	=> esc_html__( "3 Columns", "ecohorbor" ),						
										'3'	=> esc_html__( "4 Columns Fullwidth", "ecohorbor" ),
										'4'	=> esc_html__( "About Us", "ecohorbor" ),
										'5'	=> esc_html__( "Blog Grid + Overlay", "ecohorbor" ),
										'6'	=> esc_html__( "Blog List", "ecohorbor" ),
										'7'	=> esc_html__( "Contact Us", "ecohorbor" ),
										'8'	=> esc_html__( "Donation", "ecohorbor" ),
										'9'	=> esc_html__( "Frequently Asked Question", "ecohorbor" ),
										'10'	=> esc_html__( "Home", "ecohorbor" ),
										'11' 	=> esc_html__( "Home 2", "ecohorbor" ),
										'12'		=> esc_html__( "Home 3", "ecohorbor" ),
										'13' 	=> esc_html__( "Home 4", "ecohorbor" ),
										'14' 	=> esc_html__( "Home 5", "ecohorbor" ),
										'15'		=> esc_html__( "Home Landing Page", "ecohorbor" ),
										'16' 	=> esc_html__( "Our Team", "ecohorbor" ),
										'17'		=> esc_html__( "Portfolio", "ecohorbor" ),
										'18' 	=> esc_html__( "Portfolio Grid 2", "ecohorbor" ),
										'19' 	=> esc_html__( "Portfolio Grid 3", "ecohorbor" ),
										'20'	=> esc_html__( "Portfolio Grid 4", "ecohorbor" ),						
										'21'	=> esc_html__( "Portfolio Masonry", "ecohorbor" ),
										'22'	=> esc_html__( "Privacy Policy", "ecohorbor" ),
										'23'	=> esc_html__( "Refund and Returns Policy", "ecohorbor" ),
										'24'	=> esc_html__( "Services", "ecohorbor" ),
										'25'	=> esc_html__( "2 Columns", "ecohorbor" ),
										'26'	=> esc_html__( "Service Classic Pro", "ecohorbor" ),
										'27'	=> esc_html__( "Service Classic Style", "ecohorbor" ),
										'28'	=> esc_html__( "Service Modern Style", "ecohorbor" ),
										'29'	=> esc_html__( "Testimonial", "ecohorbor" ),
										'30'	=> esc_html__( "Blog", "ecohorbor" ),
										'31'	=> esc_html__( "Campaigns Grid", "ecohorbor" )
									)
									
								);
								self::ecohorbor_demo_div_generater( $demo_array );								
							?>
							
								<div class="theme-requirements" data-requirements="<?php 
									printf( '<h2>%1$s</h2> <p>%2$s</p> <h3>%3$s</h3> <ol><li>%4$s</li></ol>', 
										esc_html__( 'WARNING:', 'ecohorbor-addon' ), 
										esc_html__( 'Importing demo content will give you pages, posts, theme options, sidebars and other settings. This will replicate the live demo. Clicking this option will replace your current theme options and widgets. It can also take a minutes to complete.', 'ecohorbor-addon' ),
										esc_html__( 'DEMO REQUIREMENTS:', 'ecohorbor-addon' ),
										esc_html__( 'Memory Limit of 128 MB and max execution time (php time limit) of 300 seconds.', 'ecohorbor-addon' )
									);
								?>">
								</div>							
								
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	<?php
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Ecohorbor_Demo_Importer::get_instance();

/* Demo Import AJAX */
if( ! function_exists('ecohorbor_demo_import_fun') ) {
    function ecohorbor_demo_import_fun() {
		
		if( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( $_POST['nonce'], 'ecohorbor_demo_import_*&^^$#(*' ) ) {
			echo "!security issue";
			wp_die(); 
		}
		
		$process = isset( $_POST['process'] ) ? sanitize_text_field($_POST['process']) : '';
		
		if( $process ){
			
			include ECOHORBOR_ADDON_DIR . 'admin/extension/demo-importer/zozo-importer.php';
			
			if( $process == 'permission' ){
				ecohorborZozoImporterModule::ecohorbor_check_file_access_permission();
			}elseif( $process == 'general_download' ){
				ecohorborZozoImporterModule::ecohorbor_general_file_ajax();
			}elseif( $process == 'xml_download' ){
				ecohorborZozoImporterModule::ecohorbor_xml_file_ajax();
			}elseif( $process == 'general_install' ){
				ecohorborZozoImporterModule::ecohorbor_general_file_install_ajax();
			}elseif( $process == 'xml_install' ){
				ecohorborZozoImporterModule::ecohorbor_xml_file_install_ajax();
			}elseif( $process == 'final' ){
				ecohorborZozoImporterModule::ecohorbor_import_set_default_settings();
			}elseif( $process == 'uninstall' ){
				ecohorborZozoImporterModule::ecohorbor_uninstall_demo();
			}
			
		}
		
		wp_die();
		
    }
    add_action('wp_ajax_ecohorbor_demo_import', 'ecohorbor_demo_import_fun');
}