<?php
class ControllerProductCategory extends Controller {
	public function index() {
		$this->load->language('product/category');

		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		if (isset($this->request->get['filter'])) {
			$filter = $this->request->get['filter'];
		} else {
			$filter = '';
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'p.sort_order';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = (int)$this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['limit'])) {
			$limit = (int)$this->request->get['limit'];
		} else {
			$limit = $this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit');
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		if (isset($this->request->get['path'])) {
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$path = '';

			$parts = explode('_', (string)$this->request->get['path']);

			$category_id = (int)array_pop($parts);

			foreach ($parts as $path_id) {
				if (!$path) {
					$path = (int)$path_id;
				} else {
					$path .= '_' . (int)$path_id;
				}

				$category_info = $this->model_catalog_category->getCategory($path_id);

				if ($category_info) {
					$data['breadcrumbs'][] = array(
						'text' => $category_info['name'],
						'href' => $this->url->link('product/category', 'path=' . $path . $url)
					);
				}
			}
		} else {
			$category_id = 0;
		}

		$category_info = $this->model_catalog_category->getCategory($category_id);

		if ($category_info) {
			$this->document->setTitle($category_info['meta_title']);
			$this->document->setDescription($category_info['meta_description']);
			$this->document->setKeywords($category_info['meta_keyword']);

			$data['heading_title'] = $category_info['name'];

			$data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));

			// Set the last category breadcrumb
			$data['breadcrumbs'][] = array(
				'text' => $category_info['name'],
				'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'])
			);

			if ($category_info['image']) {
				$data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_category_height'));
			} else {
				$data['thumb'] = '';
			}

			$data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
			$data['compare'] = $this->url->link('product/compare');

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['categories'] = array();

			$results = $this->model_catalog_category->getCategories($category_id);

			foreach ($results as $result) {
				$filter_data = array(
					'filter_category_id'  => $result['category_id'],
					'filter_sub_category' => true
				);

				$data['categories'][] = array(
					'name' => $result['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
					'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '_' . $result['category_id'] . $url)
				);
			}

			$data['products'] = array();
		
		    /* OWC start owc_core_productpageenhanced_hooks.xml */ 
				/* HOOK_PRODUCTPAGEENHANCED_BEFORE_PRODUCT_LOOP */ 
		
		/* OWC start owc_productpageenhanced_short_description.xml */			 
		/* Product list settings */
		$owc_productpageenhanced_show_short_description   = 0; 		
    $owc_productpageenhanced_is_module                = 0; 	  
    $owc_short_description                            = "";
    $owc_description                                  = "";
  	$filetype                                         = "";    
				
		if ($this->OwcLoader->OwcProductPageEnhancedShortDescription->checkStatus()) {
		  
		  $filetype = explode('_', basename(__FILE__));
  		$filetype = str_replace(".php", "", $filetype[sizeof($filetype)-1]);	  	
  		
			$owc_productpageenhanced_show_short_description     = $this->OwcLoader->OwcProductPageEnhanced->getShowHideOnPageAndModules('owc_productpageenhanced_sd_show_', $filetype, isset($owc_productpageenhanced_sd_show_override) ? $owc_productpageenhanced_sd_show_override : 0); 		
      $owc_productpageenhanced_is_module                  = in_array($filetype, array('featured', 'special', 'bestseller', 'latest', 'product'));
			if (strpos(basename(__FILE__), 'owc_listallproducts_catalog_module') !== false) {
				$owc_productpageenhanced_is_module = true;
			}  	  		 
		}		
		/* OWC end owc_productpageenhanced_short_description.xml */ 
		
		
		/* OWC start owc_productpageenhanced.xml */		
		if($this->config->get('owc_productpageenhanced_module_status')){
		  if ($this->config->get('owc_productpageenhanced_include_css')) {
		    if ($this->OwcLoader->OwcBase->isJournal3()) {
		      $this->document->addStyle('catalog/view/theme/default/stylesheet/owc/owc_productpageenhanced.css');
		    } else {
		      $this->document->addStyle('catalog/view/theme/default/stylesheet/owc/owc_productpageenhanced.css?v=' . OwcProductPageEnhanced::VERSION);
		    }  
		  }
		  if ($this->config->get('owc_productpageenhanced_include_js_equal_heights')) {
		    if ($this->OwcLoader->OwcBase->isJournal3()) {
		      $this->document->addScript('catalog/view/javascript/owc/owc_productpageenhanced-eh.js');
		    } else {
		      $this->document->addScript('catalog/view/javascript/owc/owc_productpageenhanced-eh.js?v=' . OwcProductPageEnhanced::VERSION);
		    }
		  }  
		}
		/* OWC end owc_productpageenhanced.xml */ 
		
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		

			$filter_data = array(
				'filter_category_id' => $category_id,
				'filter_filter'      => $filter,
				'sort'               => $sort,
				'order'              => $order,
				'start'              => ($page - 1) * $limit,
				'limit'              => $limit
			);

			$product_total = $this->model_catalog_product->getTotalProducts($filter_data);

			$results = $this->model_catalog_product->getProducts($filter_data);

			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height'));
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if (!is_null($result['special']) && (float)$result['special'] >= 0) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					$tax_price = (float)$result['special'];
				} else {
					$special = false;
					$tax_price = (float)$result['price'];
				}
	
				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format($tax_price, $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = (int)$result['rating'];
				} else {
					$rating = false;
				}


		    /* OWC start owc_core_productpageenhanced_hooks.xml */

		/* OWC start owc_productpageenhanced_short_description.xml */
		/* Product list settings */
		if ($this->OwcLoader->OwcProductPageEnhancedShortDescription->checkStatus() && $owc_productpageenhanced_show_short_description) {					
		  $product_array = $this->OwcLoader->OwcHelper->getProductArray(get_defined_vars(), $filetype, $product_str);
			if (isset($product_array)) {				 
			  $owc_short_description = $this->OwcLoader->OwcProductPageEnhancedShortDescription->formatShortDescription($product_array, false);
			  $owc_description    	 = utf8_substr(strip_tags(html_entity_decode($this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'description'), ENT_QUOTES, 'UTF-8')), 0, $this->config->get('owc_productpageenhanced_sd_long_length')) . '..';
			  $description           = utf8_substr(strip_tags(html_entity_decode($this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'description'), ENT_QUOTES, 'UTF-8')), 0, $this->config->get('config_product_description_length')) . '..';
			  ${$product_str}['owc_short_description'] = $this->OwcLoader->OwcProductPageEnhancedShortDescription->renderProductListPage($owc_short_description, $owc_description, $description, $owc_productpageenhanced_show_short_description, $owc_productpageenhanced_is_module);						
			} 			
		} 
		/* OWC end owc_productpageenhanced_short_description.xml */
		
				/* HOOK_PRODUCTPAGEENHANCED_BEFORE_PRODUCT_ADD_TO_ARRAY */
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		

			$percent = round((($result['price'] -  $result['special'])/$result['price']) * 100 ,0). '%';
            
				$data['products'][] = array(

			'percent' 	  => $percent,
            
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,

		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_ADD_TO_ARRAY */

		  /* OWC start owc_productpageenhanced_short_description.xml */
			'short_description'      => $this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'owc_short_description'),
			/* OWC end owc_productpageenhanced_short_description.xml */
			
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
					'tax'         => $tax,
					'minimum'     => $result['minimum'] > 0 ? $result['minimum'] : 1,
					'rating'      => $result['rating'],
					'href'        => $this->url->link('product/product', 'path=' . $this->request->get['path'] . '&product_id=' . $result['product_id'] . $url)
				);
			}

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['sorts'] = array();

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_default'),
				'value' => 'p.sort_order-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.sort_order&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_asc'),
				'value' => 'pd.name-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_name_desc'),
				'value' => 'pd.name-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=DESC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_asc'),
				'value' => 'p.price-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_price_desc'),
				'value' => 'p.price-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=DESC' . $url)
			);

			if ($this->config->get('config_review_status')) {
				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_desc'),
					'value' => 'rating-DESC',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=DESC' . $url)
				);

				$data['sorts'][] = array(
					'text'  => $this->language->get('text_rating_asc'),
					'value' => 'rating-ASC',
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=ASC' . $url)
				);
			}

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_asc'),
				'value' => 'p.model-ASC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=ASC' . $url)
			);

			$data['sorts'][] = array(
				'text'  => $this->language->get('text_model_desc'),
				'value' => 'p.model-DESC',
				'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=DESC' . $url)
			);

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			$data['limits'] = array();

			$limits = array_unique(array($this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

			sort($limits);

			foreach($limits as $value) {
				$data['limits'][] = array(
					'text'  => $value,
					'value' => $value,
					'href'  => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=' . $value)
				);
			}

			$url = '';

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = $page;
			$pagination->limit = $limit;
			$pagination->url = $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&page={page}');

			$data['pagination'] = $pagination->render();

			$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

			// http://googlewebmastercentral.blogspot.com/2011/09/pagination-with-relnext-and-relprev.html
			if ($page == 1) {
			    $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id']), 'canonical');
			} else {
				$this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'] . '&page='. $page), 'canonical');
			}
			
			if ($page > 1) {
			    $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'] . (($page - 2) ? '&page='. ($page - 1) : '')), 'prev');
			}

			if ($limit && ceil($product_total / $limit) > $page) {
			    $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'] . '&page='. ($page + 1)), 'next');
			}

			$data['sort'] = $sort;
			$data['order'] = $order;
			$data['limit'] = $limit;

			$data['continue'] = $this->url->link('common/home');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');


		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_BEFORE_VIEW */
		
		/* OWC start owc_productpageenhanced.xml */				
		if (isset($this->data) && is_array($this->data)) {
		  $this->data['html_list_label'] = "";
  		if($this->config->get('owc_productpageenhanced_module_status')){
  		  if (isset($this->session->data['owc_list_before_price_label'])) {
  		    $this->data['html_list_label']  = $this->session->data['owc_list_before_price_label'];
  		  }
  		}
		} else {
		  $data['html_list_label'] = "";
  		if($this->config->get('owc_productpageenhanced_module_status')){
  		  if (isset($this->session->data['owc_list_before_price_label'])) {
  		    $data['html_list_label']  = $this->session->data['owc_list_before_price_label'];
  		  }
  		}
		}		
		/* OWC end owc_productpageenhanced.xml */ 
		
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
			$this->response->setOutput($this->load->view('product/category', $data));
		} else {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/category', $url)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');


		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_BEFORE_VIEW */
		
		/* OWC start owc_productpageenhanced.xml */				
		if (isset($this->data) && is_array($this->data)) {
		  $this->data['html_list_label'] = "";
  		if($this->config->get('owc_productpageenhanced_module_status')){
  		  if (isset($this->session->data['owc_list_before_price_label'])) {
  		    $this->data['html_list_label']  = $this->session->data['owc_list_before_price_label'];
  		  }
  		}
		} else {
		  $data['html_list_label'] = "";
  		if($this->config->get('owc_productpageenhanced_module_status')){
  		  if (isset($this->session->data['owc_list_before_price_label'])) {
  		    $data['html_list_label']  = $this->session->data['owc_list_before_price_label'];
  		  }
  		}
		}		
		/* OWC end owc_productpageenhanced.xml */ 
		
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
			$this->response->setOutput($this->load->view('error/not_found', $data));
		}
	}
}
