<?php
class ControllerExtensionModuleSpecial extends Controller {
	public function index($setting) {
		$this->load->language('extension/module/special');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');


			$this->load->model('catalog/category');
            
		$data['products'] = array();
		
		    /* OWC start owc_core_productpageenhanced_hooks.xml */ 
				/* HOOK_PRODUCTPAGEENHANCED_BEFORE_PRODUCT_LOOP */ 
		
		/* OWC start owc_productpageenhanced_short_description.xml */			 
		/* Product list settings */
		$owc_productpageenhanced_show_short_description   = 0; 		
    $owc_productpageenhanced_is_module                = 0; 	  
    $owc_short_description                            = "";
    $owc_description                                  = "";
  	$filetype                                         = "";    
				
		if ($this->OwcLoader->OwcProductPageEnhancedShortDescription->checkStatus()) {
		  
		  $filetype = explode('_', basename(__FILE__));
  		$filetype = str_replace(".php", "", $filetype[sizeof($filetype)-1]);	  	
  		
			$owc_productpageenhanced_show_short_description     = $this->OwcLoader->OwcProductPageEnhanced->getShowHideOnPageAndModules('owc_productpageenhanced_sd_show_', $filetype, isset($owc_productpageenhanced_sd_show_override) ? $owc_productpageenhanced_sd_show_override : 0); 		
      $owc_productpageenhanced_is_module                  = in_array($filetype, array('featured', 'special', 'bestseller', 'latest', 'product'));
			if (strpos(basename(__FILE__), 'owc_listallproducts_catalog_module') !== false) {
				$owc_productpageenhanced_is_module = true;
			}  	  		 
		}		
		/* OWC end owc_productpageenhanced_short_description.xml */ 
		
		
		/* OWC start owc_productpageenhanced.xml */		
		if($this->config->get('owc_productpageenhanced_module_status')){
		  if ($this->config->get('owc_productpageenhanced_include_css')) {
		    if ($this->OwcLoader->OwcBase->isJournal3()) {
		      $this->document->addStyle('catalog/view/theme/default/stylesheet/owc/owc_productpageenhanced.css');
		    } else {
		      $this->document->addStyle('catalog/view/theme/default/stylesheet/owc/owc_productpageenhanced.css?v=' . OwcProductPageEnhanced::VERSION);
		    }  
		  }
		  if ($this->config->get('owc_productpageenhanced_include_js_equal_heights')) {
		    if ($this->OwcLoader->OwcBase->isJournal3()) {
		      $this->document->addScript('catalog/view/javascript/owc/owc_productpageenhanced-eh.js');
		    } else {
		      $this->document->addScript('catalog/view/javascript/owc/owc_productpageenhanced-eh.js?v=' . OwcProductPageEnhanced::VERSION);
		    }
		  }  
		}
		/* OWC end owc_productpageenhanced.xml */ 
		
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		

		$filter_data = array(
			'sort'  => 'pd.name',
			'order' => 'ASC',
			'start' => 0,
			'limit' => $setting['limit']
		);

		$results = $this->model_catalog_product->getProductSpecials($filter_data);

		if ($results) {
			foreach ($results as $result) {
				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']);
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $setting['width'], $setting['height']);
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if (!is_null($result['special']) && (float)$result['special'] >= 0) {
					$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					$tax_price = (float)$result['special'];
				} else {
					$special = false;
					$tax_price = (float)$result['price'];
				}
	
				if ($this->config->get('config_tax')) {
					$tax = $this->currency->format($tax_price, $this->session->data['currency']);
				} else {
					$tax = false;
				}

				if ($this->config->get('config_review_status')) {
					$rating = $result['rating'];
				} else {
					$rating = false;
				}


		    /* OWC start owc_core_productpageenhanced_hooks.xml */

		/* OWC start owc_productpageenhanced_short_description.xml */
		/* Product list settings */
		if ($this->OwcLoader->OwcProductPageEnhancedShortDescription->checkStatus() && $owc_productpageenhanced_show_short_description) {					
		  $product_array = $this->OwcLoader->OwcHelper->getProductArray(get_defined_vars(), $filetype, $product_str);
			if (isset($product_array)) {				 
			  $owc_short_description = $this->OwcLoader->OwcProductPageEnhancedShortDescription->formatShortDescription($product_array, false);
			  $owc_description    	 = utf8_substr(strip_tags(html_entity_decode($this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'description'), ENT_QUOTES, 'UTF-8')), 0, $this->config->get('owc_productpageenhanced_sd_long_length')) . '..';
			  $description           = utf8_substr(strip_tags(html_entity_decode($this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'description'), ENT_QUOTES, 'UTF-8')), 0, $this->config->get('config_product_description_length')) . '..';
			  ${$product_str}['owc_short_description'] = $this->OwcLoader->OwcProductPageEnhancedShortDescription->renderProductListPage($owc_short_description, $owc_description, $description, $owc_productpageenhanced_show_short_description, $owc_productpageenhanced_is_module);						
			} 			
		} 
		/* OWC end owc_productpageenhanced_short_description.xml */
		
				/* HOOK_PRODUCTPAGEENHANCED_BEFORE_PRODUCT_ADD_TO_ARRAY */
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		

			$percent = round((($result['price'] -  $result['special'])/$result['price']) * 100 ,0). '%';
			$categories = $this->model_catalog_product->getCategories($result['product_id']);
				if($categories){
				    $categories_info = $this->model_catalog_category->getCategory($categories[0]['category_id']);
				    $category_title = $categories_info['name'];
					$category_href = $this->url->link('product/category', 'path=' . $categories_info['category_id']);
				}else{
				    $category_title = 'Uncategorized';
				    $category_href = '';
				}
            
				$data['products'][] = array(

			'percent' 	  => $percent,
			'category_title' => $category_title,
			'category_href' => $category_href,
            
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'description' => utf8_substr(trim(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'))), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
					'price'       => $price,
					'special'     => $special,

		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_ADD_TO_ARRAY */

		  /* OWC start owc_productpageenhanced_short_description.xml */
			'short_description'      => $this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'owc_short_description'),
			/* OWC end owc_productpageenhanced_short_description.xml */
			
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
					'tax'         => $tax,
					'rating'      => $rating,
					'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'])
				);
			}


		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_BEFORE_VIEW */
		
		/* OWC start owc_productpageenhanced.xml */				
		if (isset($this->data) && is_array($this->data)) {
		  $this->data['html_list_label'] = "";
  		if($this->config->get('owc_productpageenhanced_module_status')){
  		  if (isset($this->session->data['owc_list_before_price_label'])) {
  		    $this->data['html_list_label']  = $this->session->data['owc_list_before_price_label'];
  		  }
  		}
		} else {
		  $data['html_list_label'] = "";
  		if($this->config->get('owc_productpageenhanced_module_status')){
  		  if (isset($this->session->data['owc_list_before_price_label'])) {
  		    $data['html_list_label']  = $this->session->data['owc_list_before_price_label'];
  		  }
  		}
		}		
		/* OWC end owc_productpageenhanced.xml */ 
		
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
			return $this->load->view('extension/module/special', $data);
		}
	}
}