<?php
class ControllerAccountWishList extends Controller {
	public function index() {
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/wishlist', '', true);

			$this->response->redirect($this->url->link('account/login', '', true));
		}

		$this->load->language('account/wishlist');

		$this->load->model('account/wishlist');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		if (isset($this->request->get['remove'])) {
			// Remove Wishlist
			$this->model_account_wishlist->deleteWishlist($this->request->get['remove']);

			$this->session->data['success'] = $this->language->get('text_remove');

			$this->response->redirect($this->url->link('account/wishlist'));
		}

		$this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => $this->url->link('account/account', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('account/wishlist')
		);

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['products'] = array();
		
		    /* OWC start owc_core_productpageenhanced_hooks.xml */ 
				/* HOOK_PRODUCTPAGEENHANCED_BEFORE_PRODUCT_LOOP */ 
		
		/* OWC start owc_productpageenhanced_short_description.xml */			 
		/* Product list settings */
		$owc_productpageenhanced_show_short_description   = 0; 		
    $owc_productpageenhanced_is_module                = 0; 	  
    $owc_short_description                            = "";
    $owc_description                                  = "";
  	$filetype                                         = "";    
				
		if ($this->OwcLoader->OwcProductPageEnhancedShortDescription->checkStatus()) {
		  
		  $filetype = explode('_', basename(__FILE__));
  		$filetype = str_replace(".php", "", $filetype[sizeof($filetype)-1]);	  	
  		
			$owc_productpageenhanced_show_short_description     = $this->OwcLoader->OwcProductPageEnhanced->getShowHideOnPageAndModules('owc_productpageenhanced_sd_show_', $filetype, isset($owc_productpageenhanced_sd_show_override) ? $owc_productpageenhanced_sd_show_override : 0); 		
      $owc_productpageenhanced_is_module                  = in_array($filetype, array('featured', 'special', 'bestseller', 'latest', 'product'));
			if (strpos(basename(__FILE__), 'owc_listallproducts_catalog_module') !== false) {
				$owc_productpageenhanced_is_module = true;
			}  	  		 
		}		
		/* OWC end owc_productpageenhanced_short_description.xml */ 
		
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		

		$results = $this->model_account_wishlist->getWishlist();

		foreach ($results as $result) {
			$product_info = $this->model_catalog_product->getProduct($result['product_id']);

			if ($product_info) {
				if ($product_info['image']) {
					$image = $this->model_tool_image->resize($product_info['image'], $this->config->get('theme_' . $this->config->get('config_theme') . '_image_wishlist_width'), $this->config->get('theme_' . $this->config->get('config_theme') . '_image_wishlist_height'));
				} else {
					$image = false;
				}

				if ($product_info['quantity'] <= 0) {
					$stock = $product_info['stock_status'];
				} elseif ($this->config->get('config_stock_display')) {
					$stock = $product_info['quantity'];
				} else {
					$stock = $this->language->get('text_instock');
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}

				if ((float)$product_info['special']) {
					$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$special = false;
				}


		    /* OWC start owc_core_productpageenhanced_hooks.xml */

		/* OWC start owc_productpageenhanced_short_description.xml */
		/* Product list settings */
		if ($this->OwcLoader->OwcProductPageEnhancedShortDescription->checkStatus() && $owc_productpageenhanced_show_short_description) {					
		  $product_array = $this->OwcLoader->OwcHelper->getProductArray(get_defined_vars(), $filetype, $product_str);
			if (isset($product_array)) {				 
			  $owc_short_description = $this->OwcLoader->OwcProductPageEnhancedShortDescription->formatShortDescription($product_array, false);
			  $owc_description    	 = utf8_substr(strip_tags(html_entity_decode($this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'description'), ENT_QUOTES, 'UTF-8')), 0, $this->config->get('owc_productpageenhanced_sd_long_length')) . '..';
			  $description           = utf8_substr(strip_tags(html_entity_decode($this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'description'), ENT_QUOTES, 'UTF-8')), 0, $this->config->get('config_product_description_length')) . '..';
			  ${$product_str}['owc_short_description'] = $this->OwcLoader->OwcProductPageEnhancedShortDescription->renderProductListPage($owc_short_description, $owc_description, $description, $owc_productpageenhanced_show_short_description, $owc_productpageenhanced_is_module);						
			} 			
		} 
		/* OWC end owc_productpageenhanced_short_description.xml */
		
				/* HOOK_PRODUCTPAGEENHANCED_BEFORE_PRODUCT_ADD_TO_ARRAY */
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
				$data['products'][] = array(
					'product_id' => $product_info['product_id'],
					'thumb'      => $image,
					'name'       => $product_info['name'],
					'model'      => $product_info['model'],
					'stock'      => $stock,
					'price'      => $price,
					'special'    => $special,

		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_ADD_TO_ARRAY */

		  /* OWC start owc_productpageenhanced_short_description.xml */
			'short_description'      => $this->OwcLoader->OwcHelper->getProductArrayField(get_defined_vars(), $filetype,  'owc_short_description'),
			/* OWC end owc_productpageenhanced_short_description.xml */
			
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
					'href'       => $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
					'remove'     => $this->url->link('account/wishlist', 'remove=' . $product_info['product_id'])
				);
			} else {
				$this->model_account_wishlist->deleteWishlist($result['product_id']);
			}
		}

		$data['continue'] = $this->url->link('account/account', '', true);

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');


		    /* OWC start owc_core_productpageenhanced_hooks.xml */
				/* HOOK_PRODUCTPAGEENHANCED_PRODUCT_BEFORE_VIEW */
				/* OWC end owc_core_productpageenhanced_hooks.xml */
		
		$this->response->setOutput($this->load->view('account/wishlist', $data));
	}

	public function add() {
		$this->load->language('account/wishlist');

		$json = array();

		if (isset($this->request->post['product_id'])) {
			$product_id = $this->request->post['product_id'];
		} else {
			$product_id = 0;
		}

		$this->load->model('catalog/product');

		$product_info = $this->model_catalog_product->getProduct($product_id);

		if ($product_info) {
			if ($this->customer->isLogged()) {
				// Edit customers cart
				$this->load->model('account/wishlist');

				$this->model_account_wishlist->addWishlist($this->request->post['product_id']);

				$json['success'] = sprintf($this->language->get('text_success'), $this->url->link('product/product', 'product_id=' . (int)$this->request->post['product_id']), $product_info['name'], $this->url->link('account/wishlist'));

				$json['total'] = sprintf($this->language->get('text_wishlist'), $this->model_account_wishlist->getTotalWishlist());
			} else {
				if (!isset($this->session->data['wishlist'])) {
					$this->session->data['wishlist'] = array();
				}

				$this->session->data['wishlist'][] = $this->request->post['product_id'];

				$this->session->data['wishlist'] = array_unique($this->session->data['wishlist']);

				$json['success'] = sprintf($this->language->get('text_login'), $this->url->link('account/login', '', true), $this->url->link('account/register', '', true), $this->url->link('product/product', 'product_id=' . (int)$this->request->post['product_id']), $product_info['name'], $this->url->link('account/wishlist'));

				$json['total'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
