<?php
/**
 * Elementor cms icon picker control.
 *
 * @since 1.0.0
 */
class Elementor_Theme_Core_Repeater_Control extends \Elementor\Base_Data_Control {

    /**
     * Get emoji one area control type.
     *
     * Retrieve the control type, in this case `cms_icons`.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Control type.
     */
    public function get_type() {
        return 'cms_repeater';
    }

    /**
     * Enqueue emoji one area control scripts and styles.
     *
     * Used to register and enqueue custom scripts and styles used by the emoji one
     * area control.
     *
     * @since 1.0.0
     * @access public
     */
    public function enqueue() {
        wp_enqueue_style('jquery.fonticonpicker.min.css', ETC_URL . 'assets/lib/iconpicker/css/jquery.fonticonpicker.min.css', array(), 'all');
        wp_enqueue_style('jquery.fonticonpicker.grey.min.css', ETC_URL . 'assets/lib/iconpicker/themes/grey-theme/jquery.fonticonpicker.grey.min.css', array(), 'all');
        wp_enqueue_style('etc-repeater-css', ETC_URL . 'assets/css/etc-repeater.css', array(), 'all');

        wp_enqueue_script('jquery.fonticonpicker.js', ETC_URL . 'assets/lib/iconpicker/jquery.fonticonpicker.js', array('jquery'));
        wp_register_script('etc-repeater-js', ETC_URL . 'assets/js/etc-repeater.js', array('jquery', 'jquery.fonticonpicker.js'), '1.0.0');
        wp_enqueue_script( 'etc-repeater-js' );
    }

    /**
     * Get emoji one area control default settings.
     *
     * Retrieve the default settings of the emoji one area control. Used to return
     * the default settings while initializing the emoji one area control.
     *
     * @since 1.0.0
     * @access protected
     *
     * @return array Control default settings.
     */
    protected function get_default_settings() {
        return [
            'label_block' => true,
            'fontawesome_icons' => $this->get_fontawesome_icons(),
            'controls' => [],
        ];
    }

    /**
     * Render emoji one area control output in the editor.
     *
     * Used to generate the control HTML in the editor using Underscore JS
     * template. The variables for the class are available using `data` JS
     * object.
     *
     * @since 1.0.0
     * @access public
     */
    public function content_template() {
        $control_uid = $this->get_control_uid();
        ?>
        <div class="elementor-control-field">
            <# if ( data.label ) { #>
                <label for="<?php echo esc_attr( $control_uid ); ?>" class="elementor-control-title">{{{ data.label }}}</label>
            <# } #>
            <div class="elementor-control-input-wrapper">
                <textarea id="<?php echo esc_attr( $control_uid ); ?>" class="elementor-control-tag-area" data-setting="{{ data.name }}" style="display: none;">{{{ data.controlValue }}}</textarea>
                <div class="etc-group">
                    
                </div>
                <div class="etc-group-actions" style="text-align: center;">
                    <button type="button" class="elementor-button elementor-button-default etc-group-add">
                        <i class="eicon-plus" aria-hidden="true"></i>
                        <span><?php esc_html_e('Add Item', ETC_TEXT_DOMAIN)?></span>
                    </button>
                </div>
            </div>
        </div>
        <# if ( data.description ) { #>
        <div class="elementor-control-field-description">{{{ data.description }}}</div>
        <# } #>
        <?php
    }

    function get_fontawesome_icons(){
        // Categorized icons ( you can also output simple array ( key=> value ), where key = icon class, value = icon readable name ).
        /**
         * @version 5.13.0
         */
        $icons = array(
            'Solid' => array(
                array("fas fa-ad" =>  "Ad"),
                array("fas fa-address-book" => "Address Book"),
                array("fas fa-address-card" => "Address Card"),
                array("fas fa-adjust" =>  "Adjust"),
                array("fas fa-air-freshener" => "Air Freshener"),
                array("fas fa-align-center" => "Align Center"),
                array("fas fa-align-justify" => "Align Justify"),
                array("fas fa-align-left" => "Align Left"),
                array("fas fa-align-right" => "Align Right"),
                array("fas fa-allergies" =>  "Allergies"),
                array("fas fa-ambulance" =>  "Ambulance"),
                array("fas fa-american-sign-language-interpreting" => "American Sign Language Interpreting"),
                array("fas fa-anchor" =>  "Anchor"),
                array("fas fa-angle-double-down" => "Angle Double Down"),
                array("fas fa-angle-double-left" => "Angle Double Left"),
                array("fas fa-angle-double-right" => "Angle Double Right"),
                array("fas fa-angle-double-up" => "Angle Double Up"),
                array("fas fa-angle-down" => "Angle Down"),
                array("fas fa-angle-left" => "Angle Left"),
                array("fas fa-angle-right" => "Angle Right"),
                array("fas fa-angle-up" =>  "Angle Up"),
                array("fas fa-angry" =>  "Angry"),
                array("fas fa-ankh" =>  "Ankh"),
                array("fas fa-apple-alt" =>  "Apple Alt"),
                array("fas fa-archive" =>  "Archive"),
                array("fas fa-archway" =>  "Archway"),
                array("fas fa-arrow-alt-circle-down" => "Arrow Alt Circle Down"),
                array("fas fa-arrow-alt-circle-left" => "Arrow Alt Circle Left"),
                array("fas fa-arrow-alt-circle-right" => "Arrow Alt Circle Right"),
                array("fas fa-arrow-alt-circle-up" => "Arrow Alt Circle Up"),
                array("fas fa-arrow-circle-down" => "Arrow Circle Down"),
                array("fas fa-arrow-circle-left" => "Arrow Circle Left"),
                array("fas fa-arrow-circle-right" => "Arrow Circle Right"),
                array("fas fa-arrow-circle-up" => "Arrow Circle Up"),
                array("fas fa-arrow-down" => "Arrow Down"),
                array("fas fa-arrow-left" => "Arrow Left"),
                array("fas fa-arrow-right" => "Arrow Right"),
                array("fas fa-arrow-up" =>  "Arrow Up"),
                array("fas fa-arrows-alt" => "Arrows Alt"),
                array("fas fa-arrows-alt-h" => "Arrows Alt H"),
                array("fas fa-arrows-alt-v" => "Arrows Alt V"),
                array("fas fa-assistive-listening-systems" => "Assistive Listening Systems"),
                array("fas fa-asterisk" =>  "Asterisk"),
                array("fas fa-at" =>  "At"),
                array("fas fa-atlas" =>  "Atlas"),
                array("fas fa-atom" =>  "Atom"),
                array("fas fa-audio-description" => "Audio Description"),
                array("fas fa-award" =>  "Award"),
                array("fas fa-baby" =>  "Baby"),
                array("fas fa-baby-carriage" => "Baby Carriage"),
                array("fas fa-backspace" =>  "Backspace"),
                array("fas fa-backward" =>  "Backward"),
                array("fas fa-bacon" =>  "Bacon"),
                array("fas fa-bahai" =>  "Bahai"),
                array("fas fa-balance-scale" => "Balance Scale"),
                array("fas fa-balance-scale-left" => "Balance Scale Left"),
                array("fas fa-balance-scale-right" => "Balance Scale Right"),
                array("fas fa-ban" =>  "Ban"),
                array("fas fa-band-aid" =>  "Band Aid"),
                array("fas fa-barcode" =>  "Barcode"),
                array("fas fa-bars" =>  "Bars"),
                array("fas fa-baseball-ball" => "Baseball Ball"),
                array("fas fa-basketball-ball" => "Basketball Ball"),
                array("fas fa-bath" =>  "Bath"),
                array("fas fa-battery-empty" => "Battery Empty"),
                array("fas fa-battery-full" => "Battery Full"),
                array("fas fa-battery-half" => "Battery Half"),
                array("fas fa-battery-quarter" => "Battery Quarter"),
                array("fas fa-battery-three-quarters" => "Battery Three Quarters"),
                array("fas fa-bed" =>  "Bed"),
                array("fas fa-beer" =>  "Beer"),
                array("fas fa-bell" =>  "Bell"),
                array("fas fa-bell-slash" => "Bell Slash"),
                array("fas fa-bezier-curve" => "Bezier Curve"),
                array("fas fa-bible" =>  "Bible"),
                array("fas fa-bicycle" =>  "Bicycle"),
                array("fas fa-biking" =>  "Biking"),
                array("fas fa-binoculars" => "Binoculars"),
                array("fas fa-biohazard" =>  "Biohazard"),
                array("fas fa-birthday-cake" => "Birthday Cake"),
                array("fas fa-blender" =>  "Blender"),
                array("fas fa-blender-phone" => "Blender Phone"),
                array("fas fa-blind" =>  "Blind"),
                array("fas fa-blog" =>  "Blog"),
                array("fas fa-bold" =>  "Bold"),
                array("fas fa-bolt" =>  "Bolt"),
                array("fas fa-bomb" =>  "Bomb"),
                array("fas fa-bone" =>  "Bone"),
                array("fas fa-bong" =>  "Bong"),
                array("fas fa-book" =>  "Book"),
                array("fas fa-book-dead" =>  "Book Dead"),
                array("fas fa-book-medical" => "Book Medical"),
                array("fas fa-book-open" =>  "Book Open"),
                array("fas fa-book-reader" => "Book Reader"),
                array("fas fa-bookmark" =>  "Bookmark"),
                array("fas fa-border-all" => "Border All"),
                array("fas fa-border-none" => "Border None"),
                array("fas fa-border-style" => "Border Style"),
                array("fas fa-bowling-ball" => "Bowling Ball"),
                array("fas fa-box" =>  "Box"),
                array("fas fa-box-open" =>  "Box Open"),
                array("fas fa-box-tissue" => "Box Tissue"),
                array("fas fa-boxes" =>  "Boxes"),
                array("fas fa-braille" =>  "Braille"),
                array("fas fa-brain" =>  "Brain"),
                array("fas fa-bread-slice" => "Bread Slice"),
                array("fas fa-briefcase" =>  "Briefcase"),
                array("fas fa-briefcase-medical" => "Briefcase Medical"),
                array("fas fa-broadcast-tower" => "Broadcast Tower"),
                array("fas fa-broom" =>  "Broom"),
                array("fas fa-brush" =>  "Brush"),
                array("fas fa-bug" =>  "Bug"),
                array("fas fa-building" =>  "Building"),
                array("fas fa-bullhorn" =>  "Bullhorn"),
                array("fas fa-bullseye" =>  "Bullseye"),
                array("fas fa-burn" =>  "Burn"),
                array("fas fa-bus" =>  "Bus"),
                array("fas fa-bus-alt" =>  "Bus Alt"),
                array("fas fa-business-time" => "Business Time"),
                array("fas fa-calculator" => "Calculator"),
                array("fas fa-calendar" =>  "Calendar"),
                array("fas fa-calendar-alt" => "Calendar Alt"),
                array("fas fa-calendar-check" => "Calendar Check"),
                array("fas fa-calendar-day" => "Calendar Day"),
                array("fas fa-calendar-minus" => "Calendar Minus"),
                array("fas fa-calendar-plus" => "Calendar Plus"),
                array("fas fa-calendar-times" => "Calendar Times"),
                array("fas fa-calendar-week" => "Calendar Week"),
                array("fas fa-camera" =>  "Camera"),
                array("fas fa-camera-retro" => "Camera Retro"),
                array("fas fa-campground" => "Campground"),
                array("fas fa-candy-cane" => "Candy Cane"),
                array("fas fa-cannabis" =>  "Cannabis"),
                array("fas fa-capsules" =>  "Capsules"),
                array("fas fa-car" =>  "Car"),
                array("fas fa-car-alt" =>  "Car Alt"),
                array("fas fa-car-battery" => "Car Battery"),
                array("fas fa-car-crash" =>  "Car Crash"),
                array("fas fa-car-side" =>  "Car Side"),
                array("fas fa-caravan" =>  "Caravan"),
                array("fas fa-caret-down" => "Caret Down"),
                array("fas fa-caret-left" => "Caret Left"),
                array("fas fa-caret-right" => "Caret Right"),
                array("fas fa-caret-square-down" => "Caret Square Down"),
                array("fas fa-caret-square-left" => "Caret Square Left"),
                array("fas fa-caret-square-right" => "Caret Square Right"),
                array("fas fa-caret-square-up" => "Caret Square Up"),
                array("fas fa-caret-up" =>  "Caret Up"),
                array("fas fa-carrot" =>  "Carrot"),
                array("fas fa-cart-arrow-down" => "Cart Arrow Down"),
                array("fas fa-cart-plus" =>  "Cart Plus"),
                array("fas fa-cash-register" => "Cash Register"),
                array("fas fa-cat" =>  "Cat"),
                array("fas fa-certificate" => "Certificate"),
                array("fas fa-chair" =>  "Chair"),
                array("fas fa-chalkboard" => "Chalkboard"),
                array("fas fa-chalkboard-teacher" => "Chalkboard Teacher"),
                array("fas fa-charging-station" => "Charging Station"),
                array("fas fa-chart-area" => "Chart Area"),
                array("fas fa-chart-bar" =>  "Chart Bar"),
                array("fas fa-chart-line" => "Chart Line"),
                array("fas fa-chart-pie" =>  "Chart Pie"),
                array("fas fa-check" =>  "Check"),
                array("fas fa-check-circle" => "Check Circle"),
                array("fas fa-check-double" => "Check Double"),
                array("fas fa-check-square" => "Check Square"),
                array("fas fa-cheese" =>  "Cheese"),
                array("fas fa-chess" =>  "Chess"),
                array("fas fa-chess-bishop" => "Chess Bishop"),
                array("fas fa-chess-board" => "Chess Board"),
                array("fas fa-chess-king" => "Chess King"),
                array("fas fa-chess-knight" => "Chess Knight"),
                array("fas fa-chess-pawn" => "Chess Pawn"),
                array("fas fa-chess-queen" => "Chess Queen"),
                array("fas fa-chess-rook" => "Chess Rook"),
                array("fas fa-chevron-circle-down" => "Chevron Circle Down"),
                array("fas fa-chevron-circle-left" => "Chevron Circle Left"),
                array("fas fa-chevron-circle-right" => "Chevron Circle Right"),
                array("fas fa-chevron-circle-up" => "Chevron Circle Up"),
                array("fas fa-chevron-down" => "Chevron Down"),
                array("fas fa-chevron-left" => "Chevron Left"),
                array("fas fa-chevron-right" => "Chevron Right"),
                array("fas fa-chevron-up" => "Chevron Up"),
                array("fas fa-child" =>  "Child"),
                array("fas fa-church" =>  "Church"),
                array("fas fa-circle" =>  "Circle"),
                array("fas fa-circle-notch" => "Circle Notch"),
                array("fas fa-city" =>  "City"),
                array("fas fa-clinic-medical" => "Clinic Medical"),
                array("fas fa-clipboard" =>  "Clipboard"),
                array("fas fa-clipboard-check" => "Clipboard Check"),
                array("fas fa-clipboard-list" => "Clipboard List"),
                array("fas fa-clock" =>  "Clock"),
                array("fas fa-clone" =>  "Clone"),
                array("fas fa-closed-captioning" => "Closed Captioning"),
                array("fas fa-cloud" =>  "Cloud"),
                array("fas fa-cloud-download-alt" => "Cloud Download Alt"),
                array("fas fa-cloud-meatball" => "Cloud Meatball"),
                array("fas fa-cloud-moon" => "Cloud Moon"),
                array("fas fa-cloud-moon-rain" => "Cloud Moon Rain"),
                array("fas fa-cloud-rain" => "Cloud Rain"),
                array("fas fa-cloud-showers-heavy" => "Cloud Showers Heavy"),
                array("fas fa-cloud-sun" =>  "Cloud Sun"),
                array("fas fa-cloud-sun-rain" => "Cloud Sun Rain"),
                array("fas fa-cloud-upload-alt" => "Cloud Upload Alt"),
                array("fas fa-cocktail" =>  "Cocktail"),
                array("fas fa-code" =>  "Code"),
                array("fas fa-code-branch" => "Code Branch"),
                array("fas fa-coffee" =>  "Coffee"),
                array("fas fa-cog" =>  "Cog"),
                array("fas fa-cogs" =>  "Cogs"),
                array("fas fa-coins" =>  "Coins"),
                array("fas fa-columns" =>  "Columns"),
                array("fas fa-comment" =>  "Comment"),
                array("fas fa-comment-alt" => "Comment Alt"),
                array("fas fa-comment-dollar" => "Comment Dollar"),
                array("fas fa-comment-dots" => "Comment Dots"),
                array("fas fa-comment-medical" => "Comment Medical"),
                array("fas fa-comment-slash" => "Comment Slash"),
                array("fas fa-comments" =>  "Comments"),
                array("fas fa-comments-dollar" => "Comments Dollar"),
                array("fas fa-compact-disc" => "Compact Disc"),
                array("fas fa-compass" =>  "Compass"),
                array("fas fa-compress" =>  "Compress"),
                array("fas fa-compress-alt" => "Compress Alt"),
                array("fas fa-compress-arrows-alt" => "Compress Arrows Alt"),
                array("fas fa-concierge-bell" => "Concierge Bell"),
                array("fas fa-cookie" =>  "Cookie"),
                array("fas fa-cookie-bite" => "Cookie Bite"),
                array("fas fa-copy" =>  "Copy"),
                array("fas fa-copyright" =>  "Copyright"),
                array("fas fa-couch" =>  "Couch"),
                array("fas fa-credit-card" => "Credit Card"),
                array("fas fa-crop" =>  "Crop"),
                array("fas fa-crop-alt" =>  "Crop Alt"),
                array("fas fa-cross" =>  "Cross"),
                array("fas fa-crosshairs" => "Crosshairs"),
                array("fas fa-crow" =>  "Crow"),
                array("fas fa-crown" =>  "Crown"),
                array("fas fa-crutch" =>  "Crutch"),
                array("fas fa-cube" =>  "Cube"),
                array("fas fa-cubes" =>  "Cubes"),
                array("fas fa-cut" =>  "Cut"),
                array("fas fa-database" =>  "Database"),
                array("fas fa-deaf" =>  "Deaf"),
                array("fas fa-democrat" =>  "Democrat"),
                array("fas fa-desktop" =>  "Desktop"),
                array("fas fa-dharmachakra" => "Dharmachakra"),
                array("fas fa-diagnoses" =>  "Diagnoses"),
                array("fas fa-dice" =>  "Dice"),
                array("fas fa-dice-d20" =>  "Dice D20"),
                array("fas fa-dice-d6" =>  "Dice D6"),
                array("fas fa-dice-five" =>  "Dice Five"),
                array("fas fa-dice-four" =>  "Dice Four"),
                array("fas fa-dice-one" =>  "Dice One"),
                array("fas fa-dice-six" =>  "Dice Six"),
                array("fas fa-dice-three" => "Dice Three"),
                array("fas fa-dice-two" =>  "Dice Two"),
                array("fas fa-digital-tachograph" => "Digital Tachograph"),
                array("fas fa-directions" => "Directions"),
                array("fas fa-disease" =>  "Disease"),
                array("fas fa-divide" =>  "Divide"),
                array("fas fa-dizzy" =>  "Dizzy"),
                array("fas fa-dna" =>  "Dna"),
                array("fas fa-dog" =>  "Dog"),
                array("fas fa-dollar-sign" => "Dollar Sign"),
                array("fas fa-dolly" =>  "Dolly"),
                array("fas fa-dolly-flatbed" => "Dolly Flatbed"),
                array("fas fa-donate" =>  "Donate"),
                array("fas fa-door-closed" => "Door Closed"),
                array("fas fa-door-open" =>  "Door Open"),
                array("fas fa-dot-circle" => "Dot Circle"),
                array("fas fa-dove" =>  "Dove"),
                array("fas fa-download" =>  "Download"),
                array("fas fa-drafting-compass" => "Drafting Compass"),
                array("fas fa-dragon" =>  "Dragon"),
                array("fas fa-draw-polygon" => "Draw Polygon"),
                array("fas fa-drum" =>  "Drum"),
                array("fas fa-drum-steelpan" => "Drum Steelpan"),
                array("fas fa-drumstick-bite" => "Drumstick Bite"),
                array("fas fa-dumbbell" =>  "Dumbbell"),
                array("fas fa-dumpster" =>  "Dumpster"),
                array("fas fa-dumpster-fire" => "Dumpster Fire"),
                array("fas fa-dungeon" =>  "Dungeon"),
                array("fas fa-edit" =>  "Edit"),
                array("fas fa-egg" =>  "Egg"),
                array("fas fa-eject" =>  "Eject"),
                array("fas fa-ellipsis-h" => "Ellipsis H"),
                array("fas fa-ellipsis-v" => "Ellipsis V"),
                array("fas fa-envelope" =>  "Envelope"),
                array("fas fa-envelope-open" => "Envelope Open"),
                array("fas fa-envelope-open-text" => "Envelope Open Text"),
                array("fas fa-envelope-square" => "Envelope Square"),
                array("fas fa-equals" =>  "Equals"),
                array("fas fa-eraser" =>  "Eraser"),
                array("fas fa-ethernet" =>  "Ethernet"),
                array("fas fa-euro-sign" =>  "Euro Sign"),
                array("fas fa-exchange-alt" => "Exchange Alt"),
                array("fas fa-exclamation" => "Exclamation"),
                array("fas fa-exclamation-circle" => "Exclamation Circle"),
                array("fas fa-exclamation-triangle" => "Exclamation Triangle"),
                array("fas fa-expand" =>  "Expand"),
                array("fas fa-expand-alt" => "Expand Alt"),
                array("fas fa-expand-arrows-alt" => "Expand Arrows Alt"),
                array("fas fa-external-link-alt" => "External Link Alt"),
                array("fas fa-external-link-square-alt" => "External Link Square Alt"),
                array("fas fa-eye" =>  "Eye"),
                array("fas fa-eye-dropper" => "Eye Dropper"),
                array("fas fa-eye-slash" =>  "Eye Slash"),
                array("fas fa-fan" =>  "Fan"),
                array("fas fa-fast-backward" => "Fast Backward"),
                array("fas fa-fast-forward" => "Fast Forward"),
                array("fas fa-faucet" =>  "Faucet"),
                array("fas fa-fax" =>  "Fax"),
                array("fas fa-feather" =>  "Feather"),
                array("fas fa-feather-alt" => "Feather Alt"),
                array("fas fa-female" =>  "Female"),
                array("fas fa-fighter-jet" => "Fighter Jet"),
                array("fas fa-file" =>  "File"),
                array("fas fa-file-alt" =>  "File Alt"),
                array("fas fa-file-archive" => "File Archive"),
                array("fas fa-file-audio" => "File Audio"),
                array("fas fa-file-code" =>  "File Code"),
                array("fas fa-file-contract" => "File Contract"),
                array("fas fa-file-csv" =>  "File Csv"),
                array("fas fa-file-download" => "File Download"),
                array("fas fa-file-excel" => "File Excel"),
                array("fas fa-file-export" => "File Export"),
                array("fas fa-file-image" => "File Image"),
                array("fas fa-file-import" => "File Import"),
                array("fas fa-file-invoice" => "File Invoice"),
                array("fas fa-file-invoice-dollar" => "File Invoice Dollar"),
                array("fas fa-file-medical" => "File Medical"),
                array("fas fa-file-medical-alt" => "File Medical Alt"),
                array("fas fa-file-pdf" =>  "File Pdf"),
                array("fas fa-file-powerpoint" => "File Powerpoint"),
                array("fas fa-file-prescription" => "File Prescription"),
                array("fas fa-file-signature" => "File Signature"),
                array("fas fa-file-upload" => "File Upload"),
                array("fas fa-file-video" => "File Video"),
                array("fas fa-file-word" =>  "File Word"),
                array("fas fa-fill" =>  "Fill"),
                array("fas fa-fill-drip" =>  "Fill Drip"),
                array("fas fa-film" =>  "Film"),
                array("fas fa-filter" =>  "Filter"),
                array("fas fa-fingerprint" => "Fingerprint"),
                array("fas fa-fire" =>  "Fire"),
                array("fas fa-fire-alt" =>  "Fire Alt"),
                array("fas fa-fire-extinguisher" => "Fire Extinguisher"),
                array("fas fa-first-aid" =>  "First Aid"),
                array("fas fa-fish" =>  "Fish"),
                array("fas fa-fist-raised" => "Fist Raised"),
                array("fas fa-flag" =>  "Flag"),
                array("fas fa-flag-checkered" => "Flag Checkered"),
                array("fas fa-flag-usa" =>  "Flag Usa"),
                array("fas fa-flask" =>  "Flask"),
                array("fas fa-flushed" =>  "Flushed"),
                array("fas fa-folder" =>  "Folder"),
                array("fas fa-folder-minus" => "Folder Minus"),
                array("fas fa-folder-open" => "Folder Open"),
                array("fas fa-folder-plus" => "Folder Plus"),
                array("fas fa-font" =>  "Font"),
                array("fas fa-football-ball" => "Football Ball"),
                array("fas fa-forward" =>  "Forward"),
                array("fas fa-frog" =>  "Frog"),
                array("fas fa-frown" =>  "Frown"),
                array("fas fa-frown-open" => "Frown Open"),
                array("fas fa-funnel-dollar" => "Funnel Dollar"),
                array("fas fa-futbol" =>  "Futbol"),
                array("fas fa-gamepad" =>  "Gamepad"),
                array("fas fa-gas-pump" =>  "Gas Pump"),
                array("fas fa-gavel" =>  "Gavel"),
                array("fas fa-gem" =>  "Gem"),
                array("fas fa-genderless" => "Genderless"),
                array("fas fa-ghost" =>  "Ghost"),
                array("fas fa-gift" =>  "Gift"),
                array("fas fa-gifts" =>  "Gifts"),
                array("fas fa-glass-cheers" => "Glass Cheers"),
                array("fas fa-glass-martini" => "Glass Martini"),
                array("fas fa-glass-martini-alt" => "Glass Martini Alt"),
                array("fas fa-glass-whiskey" => "Glass Whiskey"),
                array("fas fa-glasses" =>  "Glasses"),
                array("fas fa-globe" =>  "Globe"),
                array("fas fa-globe-africa" => "Globe Africa"),
                array("fas fa-globe-americas" => "Globe Americas"),
                array("fas fa-globe-asia" => "Globe Asia"),
                array("fas fa-globe-europe" => "Globe Europe"),
                array("fas fa-golf-ball" =>  "Golf Ball"),
                array("fas fa-gopuram" =>  "Gopuram"),
                array("fas fa-graduation-cap" => "Graduation Cap"),
                array("fas fa-greater-than" => "Greater Than"),
                array("fas fa-greater-than-equal" => "Greater Than Equal"),
                array("fas fa-grimace" =>  "Grimace"),
                array("fas fa-grin" =>  "Grin"),
                array("fas fa-grin-alt" =>  "Grin Alt"),
                array("fas fa-grin-beam" =>  "Grin Beam"),
                array("fas fa-grin-beam-sweat" => "Grin Beam Sweat"),
                array("fas fa-grin-hearts" => "Grin Hearts"),
                array("fas fa-grin-squint" => "Grin Squint"),
                array("fas fa-grin-squint-tears" => "Grin Squint Tears"),
                array("fas fa-grin-stars" => "Grin Stars"),
                array("fas fa-grin-tears" => "Grin Tears"),
                array("fas fa-grin-tongue" => "Grin Tongue"),
                array("fas fa-grin-tongue-squint" => "Grin Tongue Squint"),
                array("fas fa-grin-tongue-wink" => "Grin Tongue Wink"),
                array("fas fa-grin-wink" =>  "Grin Wink"),
                array("fas fa-grip-horizontal" => "Grip Horizontal"),
                array("fas fa-grip-lines" => "Grip Lines"),
                array("fas fa-grip-lines-vertical" => "Grip Lines Vertical"),
                array("fas fa-grip-vertical" => "Grip Vertical"),
                array("fas fa-guitar" =>  "Guitar"),
                array("fas fa-h-square" =>  "H Square"),
                array("fas fa-hamburger" =>  "Hamburger"),
                array("fas fa-hammer" =>  "Hammer"),
                array("fas fa-hamsa" =>  "Hamsa"),
                array("fas fa-hand-holding" => "Hand Holding"),
                array("fas fa-hand-holding-heart" => "Hand Holding Heart"),
                array("fas fa-hand-holding-medical" => "Hand Holding Medical"),
                array("fas fa-hand-holding-usd" => "Hand Holding Usd"),
                array("fas fa-hand-holding-water" => "Hand Holding Water"),
                array("fas fa-hand-lizard" => "Hand Lizard"),
                array("fas fa-hand-middle-finger" => "Hand Middle Finger"),
                array("fas fa-hand-paper" => "Hand Paper"),
                array("fas fa-hand-peace" => "Hand Peace"),
                array("fas fa-hand-point-down" => "Hand Point Down"),
                array("fas fa-hand-point-left" => "Hand Point Left"),
                array("fas fa-hand-point-right" => "Hand Point Right"),
                array("fas fa-hand-point-up" => "Hand Point Up"),
                array("fas fa-hand-pointer" => "Hand Pointer"),
                array("fas fa-hand-rock" =>  "Hand Rock"),
                array("fas fa-hand-scissors" => "Hand Scissors"),
                array("fas fa-hand-sparkles" => "Hand Sparkles"),
                array("fas fa-hand-spock" => "Hand Spock"),
                array("fas fa-hands" =>  "Hands"),
                array("fas fa-hands-helping" => "Hands Helping"),
                array("fas fa-hands-wash" => "Hands Wash"),
                array("fas fa-handshake" =>  "Handshake"),
                array("fas fa-handshake-alt-slash" => "Handshake Alt Slash"),
                array("fas fa-handshake-slash" => "Handshake Slash"),
                array("fas fa-hanukiah" =>  "Hanukiah"),
                array("fas fa-hard-hat" =>  "Hard Hat"),
                array("fas fa-hashtag" =>  "Hashtag"),
                array("fas fa-hat-cowboy" => "Hat Cowboy"),
                array("fas fa-hat-cowboy-side" => "Hat Cowboy Side"),
                array("fas fa-hat-wizard" => "Hat Wizard"),
                array("fas fa-hdd" =>  "Hdd"),
                array("fas fa-head-side-cough" => "Head Side Cough"),
                array("fas fa-head-side-cough-slash" => "Head Side Cough Slash"),
                array("fas fa-head-side-mask" => "Head Side Mask"),
                array("fas fa-head-side-virus" => "Head Side Virus"),
                array("fas fa-heading" =>  "Heading"),
                array("fas fa-headphones" => "Headphones"),
                array("fas fa-headphones-alt" => "Headphones Alt"),
                array("fas fa-headset" =>  "Headset"),
                array("fas fa-heart" =>  "Heart"),
                array("fas fa-heart-broken" => "Heart Broken"),
                array("fas fa-heartbeat" =>  "Heartbeat"),
                array("fas fa-helicopter" => "Helicopter"),
                array("fas fa-highlighter" => "Highlighter"),
                array("fas fa-hiking" =>  "Hiking"),
                array("fas fa-hippo" =>  "Hippo"),
                array("fas fa-history" =>  "History"),
                array("fas fa-hockey-puck" => "Hockey Puck"),
                array("fas fa-holly-berry" => "Holly Berry"),
                array("fas fa-home" =>  "Home"),
                array("fas fa-horse" =>  "Horse"),
                array("fas fa-horse-head" => "Horse Head"),
                array("fas fa-hospital" =>  "Hospital"),
                array("fas fa-hospital-alt" => "Hospital Alt"),
                array("fas fa-hospital-symbol" => "Hospital Symbol"),
                array("fas fa-hospital-user" => "Hospital User"),
                array("fas fa-hot-tub" =>  "Hot Tub"),
                array("fas fa-hotdog" =>  "Hotdog"),
                array("fas fa-hotel" =>  "Hotel"),
                array("fas fa-hourglass" =>  "Hourglass"),
                array("fas fa-hourglass-end" => "Hourglass End"),
                array("fas fa-hourglass-half" => "Hourglass Half"),
                array("fas fa-hourglass-start" => "Hourglass Start"),
                array("fas fa-house-damage" => "House Damage"),
                array("fas fa-house-user" => "House User"),
                array("fas fa-hryvnia" =>  "Hryvnia"),
                array("fas fa-i-cursor" =>  "I Cursor"),
                array("fas fa-ice-cream" =>  "Ice Cream"),
                array("fas fa-icicles" =>  "Icicles"),
                array("fas fa-icons" =>  "Icons"),
                array("fas fa-id-badge" =>  "Id Badge"),
                array("fas fa-id-card" =>  "Id Card"),
                array("fas fa-id-card-alt" => "Id Card Alt"),
                array("fas fa-igloo" =>  "Igloo"),
                array("fas fa-image" =>  "Image"),
                array("fas fa-images" =>  "Images"),
                array("fas fa-inbox" =>  "Inbox"),
                array("fas fa-indent" =>  "Indent"),
                array("fas fa-industry" =>  "Industry"),
                array("fas fa-infinity" =>  "Infinity"),
                array("fas fa-info" =>  "Info"),
                array("fas fa-info-circle" => "Info Circle"),
                array("fas fa-italic" =>  "Italic"),
                array("fas fa-jedi" =>  "Jedi"),
                array("fas fa-joint" =>  "Joint"),
                array("fas fa-journal-whills" => "Journal Whills"),
                array("fas fa-kaaba" =>  "Kaaba"),
                array("fas fa-key" =>  "Key"),
                array("fas fa-keyboard" =>  "Keyboard"),
                array("fas fa-khanda" =>  "Khanda"),
                array("fas fa-kiss" =>  "Kiss"),
                array("fas fa-kiss-beam" =>  "Kiss Beam"),
                array("fas fa-kiss-wink-heart" => "Kiss Wink Heart"),
                array("fas fa-kiwi-bird" =>  "Kiwi Bird"),
                array("fas fa-landmark" =>  "Landmark"),
                array("fas fa-language" =>  "Language"),
                array("fas fa-laptop" =>  "Laptop"),
                array("fas fa-laptop-code" => "Laptop Code"),
                array("fas fa-laptop-house" => "Laptop House"),
                array("fas fa-laptop-medical" => "Laptop Medical"),
                array("fas fa-laugh" =>  "Laugh"),
                array("fas fa-laugh-beam" => "Laugh Beam"),
                array("fas fa-laugh-squint" => "Laugh Squint"),
                array("fas fa-laugh-wink" => "Laugh Wink"),
                array("fas fa-layer-group" => "Layer Group"),
                array("fas fa-leaf" =>  "Leaf"),
                array("fas fa-lemon" =>  "Lemon"),
                array("fas fa-less-than" =>  "Less Than"),
                array("fas fa-less-than-equal" => "Less Than Equal"),
                array("fas fa-level-down-alt" => "Level Down Alt"),
                array("fas fa-level-up-alt" => "Level Up Alt"),
                array("fas fa-life-ring" =>  "Life Ring"),
                array("fas fa-lightbulb" =>  "Lightbulb"),
                array("fas fa-link" =>  "Link"),
                array("fas fa-lira-sign" =>  "Lira Sign"),
                array("fas fa-list" =>  "List"),
                array("fas fa-list-alt" =>  "List Alt"),
                array("fas fa-list-ol" =>  "List Ol"),
                array("fas fa-list-ul" =>  "List Ul"),
                array("fas fa-location-arrow" => "Location Arrow"),
                array("fas fa-lock" =>  "Lock"),
                array("fas fa-lock-open" =>  "Lock Open"),
                array("fas fa-long-arrow-alt-down" => "Long Arrow Alt Down"),
                array("fas fa-long-arrow-alt-left" => "Long Arrow Alt Left"),
                array("fas fa-long-arrow-alt-right" => "Long Arrow Alt Right"),
                array("fas fa-long-arrow-alt-up" => "Long Arrow Alt Up"),
                array("fas fa-low-vision" => "Low Vision"),
                array("fas fa-luggage-cart" => "Luggage Cart"),
                array("fas fa-lungs" =>  "Lungs"),
                array("fas fa-lungs-virus" => "Lungs Virus"),
                array("fas fa-magic" =>  "Magic"),
                array("fas fa-magnet" =>  "Magnet"),
                array("fas fa-mail-bulk" =>  "Mail Bulk"),
                array("fas fa-male" =>  "Male"),
                array("fas fa-map" =>  "Map"),
                array("fas fa-map-marked" => "Map Marked"),
                array("fas fa-map-marked-alt" => "Map Marked Alt"),
                array("fas fa-map-marker" => "Map Marker"),
                array("fas fa-map-marker-alt" => "Map Marker Alt"),
                array("fas fa-map-pin" =>  "Map Pin"),
                array("fas fa-map-signs" =>  "Map Signs"),
                array("fas fa-marker" =>  "Marker"),
                array("fas fa-mars" =>  "Mars"),
                array("fas fa-mars-double" => "Mars Double"),
                array("fas fa-mars-stroke" => "Mars Stroke"),
                array("fas fa-mars-stroke-h" => "Mars Stroke H"),
                array("fas fa-mars-stroke-v" => "Mars Stroke V"),
                array("fas fa-mask" =>  "Mask"),
                array("fas fa-medal" =>  "Medal"),
                array("fas fa-medkit" =>  "Medkit"),
                array("fas fa-meh" =>  "Meh"),
                array("fas fa-meh-blank" =>  "Meh Blank"),
                array("fas fa-meh-rolling-eyes" => "Meh Rolling Eyes"),
                array("fas fa-memory" =>  "Memory"),
                array("fas fa-menorah" =>  "Menorah"),
                array("fas fa-mercury" =>  "Mercury"),
                array("fas fa-meteor" =>  "Meteor"),
                array("fas fa-microchip" =>  "Microchip"),
                array("fas fa-microphone" => "Microphone"),
                array("fas fa-microphone-alt" => "Microphone Alt"),
                array("fas fa-microphone-alt-slash" => "Microphone Alt Slash"),
                array("fas fa-microphone-slash" => "Microphone Slash"),
                array("fas fa-microscope" => "Microscope"),
                array("fas fa-minus" =>  "Minus"),
                array("fas fa-minus-circle" => "Minus Circle"),
                array("fas fa-minus-square" => "Minus Square"),
                array("fas fa-mitten" =>  "Mitten"),
                array("fas fa-mobile" =>  "Mobile"),
                array("fas fa-mobile-alt" => "Mobile Alt"),
                array("fas fa-money-bill" => "Money Bill"),
                array("fas fa-money-bill-alt" => "Money Bill Alt"),
                array("fas fa-money-bill-wave" => "Money Bill Wave"),
                array("fas fa-money-bill-wave-alt" => "Money Bill Wave Alt"),
                array("fas fa-money-check" => "Money Check"),
                array("fas fa-money-check-alt" => "Money Check Alt"),
                array("fas fa-monument" =>  "Monument"),
                array("fas fa-moon" =>  "Moon"),
                array("fas fa-mortar-pestle" => "Mortar Pestle"),
                array("fas fa-mosque" =>  "Mosque"),
                array("fas fa-motorcycle" => "Motorcycle"),
                array("fas fa-mountain" =>  "Mountain"),
                array("fas fa-mouse" =>  "Mouse"),
                array("fas fa-mouse-pointer" => "Mouse Pointer"),
                array("fas fa-mug-hot" =>  "Mug Hot"),
                array("fas fa-music" =>  "Music"),
                array("fas fa-network-wired" => "Network Wired"),
                array("fas fa-neuter" =>  "Neuter"),
                array("fas fa-newspaper" =>  "Newspaper"),
                array("fas fa-not-equal" =>  "Not Equal"),
                array("fas fa-notes-medical" => "Notes Medical"),
                array("fas fa-object-group" => "Object Group"),
                array("fas fa-object-ungroup" => "Object Ungroup"),
                array("fas fa-oil-can" =>  "Oil Can"),
                array("fas fa-om" =>  "Om"),
                array("fas fa-otter" =>  "Otter"),
                array("fas fa-outdent" =>  "Outdent"),
                array("fas fa-pager" =>  "Pager"),
                array("fas fa-paint-brush" => "Paint Brush"),
                array("fas fa-paint-roller" => "Paint Roller"),
                array("fas fa-palette" =>  "Palette"),
                array("fas fa-pallet" =>  "Pallet"),
                array("fas fa-paper-plane" => "Paper Plane"),
                array("fas fa-paperclip" =>  "Paperclip"),
                array("fas fa-parachute-box" => "Parachute Box"),
                array("fas fa-paragraph" =>  "Paragraph"),
                array("fas fa-parking" =>  "Parking"),
                array("fas fa-passport" =>  "Passport"),
                array("fas fa-pastafarianism" => "Pastafarianism"),
                array("fas fa-paste" =>  "Paste"),
                array("fas fa-pause" =>  "Pause"),
                array("fas fa-pause-circle" => "Pause Circle"),
                array("fas fa-paw" =>  "Paw"),
                array("fas fa-peace" =>  "Peace"),
                array("fas fa-pen" =>  "Pen"),
                array("fas fa-pen-alt" =>  "Pen Alt"),
                array("fas fa-pen-fancy" =>  "Pen Fancy"),
                array("fas fa-pen-nib" =>  "Pen Nib"),
                array("fas fa-pen-square" => "Pen Square"),
                array("fas fa-pencil-alt" => "Pencil Alt"),
                array("fas fa-pencil-ruler" => "Pencil Ruler"),
                array("fas fa-people-arrows" => "People Arrows"),
                array("fas fa-people-carry" => "People Carry"),
                array("fas fa-pepper-hot" => "Pepper Hot"),
                array("fas fa-percent" =>  "Percent"),
                array("fas fa-percentage" => "Percentage"),
                array("fas fa-person-booth" => "Person Booth"),
                array("fas fa-phone" =>  "Phone"),
                array("fas fa-phone-alt" =>  "Phone Alt"),
                array("fas fa-phone-slash" => "Phone Slash"),
                array("fas fa-phone-square" => "Phone Square"),
                array("fas fa-phone-square-alt" => "Phone Square Alt"),
                array("fas fa-phone-volume" => "Phone Volume"),
                array("fas fa-photo-video" => "Photo Video"),
                array("fas fa-piggy-bank" => "Piggy Bank"),
                array("fas fa-pills" =>  "Pills"),
                array("fas fa-pizza-slice" => "Pizza Slice"),
                array("fas fa-place-of-worship" => "Place Of Worship"),
                array("fas fa-plane" =>  "Plane"),
                array("fas fa-plane-arrival" => "Plane Arrival"),
                array("fas fa-plane-departure" => "Plane Departure"),
                array("fas fa-plane-slash" => "Plane Slash"),
                array("fas fa-play" =>  "Play"),
                array("fas fa-play-circle" => "Play Circle"),
                array("fas fa-plug" =>  "Plug"),
                array("fas fa-plus" =>  "Plus"),
                array("fas fa-plus-circle" => "Plus Circle"),
                array("fas fa-plus-square" => "Plus Square"),
                array("fas fa-podcast" =>  "Podcast"),
                array("fas fa-poll" =>  "Poll"),
                array("fas fa-poll-h" =>  "Poll H"),
                array("fas fa-poo" =>  "Poo"),
                array("fas fa-poo-storm" =>  "Poo Storm"),
                array("fas fa-poop" =>  "Poop"),
                array("fas fa-portrait" =>  "Portrait"),
                array("fas fa-pound-sign" => "Pound Sign"),
                array("fas fa-power-off" =>  "Power Off"),
                array("fas fa-pray" =>  "Pray"),
                array("fas fa-praying-hands" => "Praying Hands"),
                array("fas fa-prescription" => "Prescription"),
                array("fas fa-prescription-bottle" => "Prescription Bottle"),
                array("fas fa-prescription-bottle-alt" => "Prescription Bottle Alt"),
                array("fas fa-print" =>  "Print"),
                array("fas fa-procedures" => "Procedures"),
                array("fas fa-project-diagram" => "Project Diagram"),
                array("fas fa-pump-medical" => "Pump Medical"),
                array("fas fa-pump-soap" =>  "Pump Soap"),
                array("fas fa-puzzle-piece" => "Puzzle Piece"),
                array("fas fa-qrcode" =>  "Qrcode"),
                array("fas fa-question" =>  "Question"),
                array("fas fa-question-circle" => "Question Circle"),
                array("fas fa-quidditch" =>  "Quidditch"),
                array("fas fa-quote-left" => "Quote Left"),
                array("fas fa-quote-right" => "Quote Right"),
                array("fas fa-quran" =>  "Quran"),
                array("fas fa-radiation" =>  "Radiation"),
                array("fas fa-radiation-alt" => "Radiation Alt"),
                array("fas fa-rainbow" =>  "Rainbow"),
                array("fas fa-random" =>  "Random"),
                array("fas fa-receipt" =>  "Receipt"),
                array("fas fa-record-vinyl" => "Record Vinyl"),
                array("fas fa-recycle" =>  "Recycle"),
                array("fas fa-redo" =>  "Redo"),
                array("fas fa-redo-alt" =>  "Redo Alt"),
                array("fas fa-registered" => "Registered"),
                array("fas fa-remove-format" => "Remove Format"),
                array("fas fa-reply" =>  "Reply"),
                array("fas fa-reply-all" =>  "Reply All"),
                array("fas fa-republican" => "Republican"),
                array("fas fa-restroom" =>  "Restroom"),
                array("fas fa-retweet" =>  "Retweet"),
                array("fas fa-ribbon" =>  "Ribbon"),
                array("fas fa-ring" =>  "Ring"),
                array("fas fa-road" =>  "Road"),
                array("fas fa-robot" =>  "Robot"),
                array("fas fa-rocket" =>  "Rocket"),
                array("fas fa-route" =>  "Route"),
                array("fas fa-rss" =>  "Rss"),
                array("fas fa-rss-square" => "Rss Square"),
                array("fas fa-ruble-sign" => "Ruble Sign"),
                array("fas fa-ruler" =>  "Ruler"),
                array("fas fa-ruler-combined" => "Ruler Combined"),
                array("fas fa-ruler-horizontal" => "Ruler Horizontal"),
                array("fas fa-ruler-vertical" => "Ruler Vertical"),
                array("fas fa-running" =>  "Running"),
                array("fas fa-rupee-sign" => "Rupee Sign"),
                array("fas fa-sad-cry" =>  "Sad Cry"),
                array("fas fa-sad-tear" =>  "Sad Tear"),
                array("fas fa-satellite" =>  "Satellite"),
                array("fas fa-satellite-dish" => "Satellite Dish"),
                array("fas fa-save" =>  "Save"),
                array("fas fa-school" =>  "School"),
                array("fas fa-screwdriver" => "Screwdriver"),
                array("fas fa-scroll" =>  "Scroll"),
                array("fas fa-sd-card" =>  "Sd Card"),
                array("fas fa-search" =>  "Search"),
                array("fas fa-search-dollar" => "Search Dollar"),
                array("fas fa-search-location" => "Search Location"),
                array("fas fa-search-minus" => "Search Minus"),
                array("fas fa-search-plus" => "Search Plus"),
                array("fas fa-seedling" =>  "Seedling"),
                array("fas fa-server" =>  "Server"),
                array("fas fa-shapes" =>  "Shapes"),
                array("fas fa-share" =>  "Share"),
                array("fas fa-share-alt" =>  "Share Alt"),
                array("fas fa-share-alt-square" => "Share Alt Square"),
                array("fas fa-share-square" => "Share Square"),
                array("fas fa-shekel-sign" => "Shekel Sign"),
                array("fas fa-shield-alt" => "Shield Alt"),
                array("fas fa-shield-virus" => "Shield Virus"),
                array("fas fa-ship" =>  "Ship"),
                array("fas fa-shipping-fast" => "Shipping Fast"),
                array("fas fa-shoe-prints" => "Shoe Prints"),
                array("fas fa-shopping-bag" => "Shopping Bag"),
                array("fas fa-shopping-basket" => "Shopping Basket"),
                array("fas fa-shopping-cart" => "Shopping Cart"),
                array("fas fa-shower" =>  "Shower"),
                array("fas fa-shuttle-van" => "Shuttle Van"),
                array("fas fa-sign" =>  "Sign"),
                array("fas fa-sign-in-alt" => "Sign In Alt"),
                array("fas fa-sign-language" => "Sign Language"),
                array("fas fa-sign-out-alt" => "Sign Out Alt"),
                array("fas fa-signal" =>  "Signal"),
                array("fas fa-signature" =>  "Signature"),
                array("fas fa-sim-card" =>  "Sim Card"),
                array("fas fa-sitemap" =>  "Sitemap"),
                array("fas fa-skating" =>  "Skating"),
                array("fas fa-skiing" =>  "Skiing"),
                array("fas fa-skiing-nordic" => "Skiing Nordic"),
                array("fas fa-skull" =>  "Skull"),
                array("fas fa-skull-crossbones" => "Skull Crossbones"),
                array("fas fa-slash" =>  "Slash"),
                array("fas fa-sleigh" =>  "Sleigh"),
                array("fas fa-sliders-h" =>  "Sliders H"),
                array("fas fa-smile" =>  "Smile"),
                array("fas fa-smile-beam" => "Smile Beam"),
                array("fas fa-smile-wink" => "Smile Wink"),
                array("fas fa-smog" =>  "Smog"),
                array("fas fa-smoking" =>  "Smoking"),
                array("fas fa-smoking-ban" => "Smoking Ban"),
                array("fas fa-sms" =>  "Sms"),
                array("fas fa-snowboarding" => "Snowboarding"),
                array("fas fa-snowflake" =>  "Snowflake"),
                array("fas fa-snowman" =>  "Snowman"),
                array("fas fa-snowplow" =>  "Snowplow"),
                array("fas fa-soap" =>  "Soap"),
                array("fas fa-socks" =>  "Socks"),
                array("fas fa-solar-panel" => "Solar Panel"),
                array("fas fa-sort" =>  "Sort"),
                array("fas fa-sort-alpha-down" => "Sort Alpha Down"),
                array("fas fa-sort-alpha-down-alt" => "Sort Alpha Down Alt"),
                array("fas fa-sort-alpha-up" => "Sort Alpha Up"),
                array("fas fa-sort-alpha-up-alt" => "Sort Alpha Up Alt"),
                array("fas fa-sort-amount-down" => "Sort Amount Down"),
                array("fas fa-sort-amount-down-alt" => "Sort Amount Down Alt"),
                array("fas fa-sort-amount-up" => "Sort Amount Up"),
                array("fas fa-sort-amount-up-alt" => "Sort Amount Up Alt"),
                array("fas fa-sort-down" =>  "Sort Down"),
                array("fas fa-sort-numeric-down" => "Sort Numeric Down"),
                array("fas fa-sort-numeric-down-alt" => "Sort Numeric Down Alt"),
                array("fas fa-sort-numeric-up" => "Sort Numeric Up"),
                array("fas fa-sort-numeric-up-alt" => "Sort Numeric Up Alt"),
                array("fas fa-sort-up" =>  "Sort Up"),
                array("fas fa-spa" =>  "Spa"),
                array("fas fa-space-shuttle" => "Space Shuttle"),
                array("fas fa-spell-check" => "Spell Check"),
                array("fas fa-spider" =>  "Spider"),
                array("fas fa-spinner" =>  "Spinner"),
                array("fas fa-splotch" =>  "Splotch"),
                array("fas fa-spray-can" =>  "Spray Can"),
                array("fas fa-square" =>  "Square"),
                array("fas fa-square-full" => "Square Full"),
                array("fas fa-square-root-alt" => "Square Root Alt"),
                array("fas fa-stamp" =>  "Stamp"),
                array("fas fa-star" =>  "Star"),
                array("fas fa-star-and-crescent" => "Star And Crescent"),
                array("fas fa-star-half" =>  "Star Half"),
                array("fas fa-star-half-alt" => "Star Half Alt"),
                array("fas fa-star-of-david" => "Star Of David"),
                array("fas fa-star-of-life" => "Star Of Life"),
                array("fas fa-step-backward" => "Step Backward"),
                array("fas fa-step-forward" => "Step Forward"),
                array("fas fa-stethoscope" => "Stethoscope"),
                array("fas fa-sticky-note" => "Sticky Note"),
                array("fas fa-stop" =>  "Stop"),
                array("fas fa-stop-circle" => "Stop Circle"),
                array("fas fa-stopwatch" =>  "Stopwatch"),
                array("fas fa-stopwatch-20" => "Stopwatch 20"),
                array("fas fa-store" =>  "Store"),
                array("fas fa-store-alt" =>  "Store Alt"),
                array("fas fa-store-alt-slash" => "Store Alt Slash"),
                array("fas fa-store-slash" => "Store Slash"),
                array("fas fa-stream" =>  "Stream"),
                array("fas fa-street-view" => "Street View"),
                array("fas fa-strikethrough" => "Strikethrough"),
                array("fas fa-stroopwafel" => "Stroopwafel"),
                array("fas fa-subscript" =>  "Subscript"),
                array("fas fa-subway" =>  "Subway"),
                array("fas fa-suitcase" =>  "Suitcase"),
                array("fas fa-suitcase-rolling" => "Suitcase Rolling"),
                array("fas fa-sun" =>  "Sun"),
                array("fas fa-superscript" => "Superscript"),
                array("fas fa-surprise" =>  "Surprise"),
                array("fas fa-swatchbook" => "Swatchbook"),
                array("fas fa-swimmer" =>  "Swimmer"),
                array("fas fa-swimming-pool" => "Swimming Pool"),
                array("fas fa-synagogue" =>  "Synagogue"),
                array("fas fa-sync" =>  "Sync"),
                array("fas fa-sync-alt" =>  "Sync Alt"),
                array("fas fa-syringe" =>  "Syringe"),
                array("fas fa-table" =>  "Table"),
                array("fas fa-table-tennis" => "Table Tennis"),
                array("fas fa-tablet" =>  "Tablet"),
                array("fas fa-tablet-alt" => "Tablet Alt"),
                array("fas fa-tablets" =>  "Tablets"),
                array("fas fa-tachometer-alt" => "Tachometer Alt"),
                array("fas fa-tag" =>  "Tag"),
                array("fas fa-tags" =>  "Tags"),
                array("fas fa-tape" =>  "Tape"),
                array("fas fa-tasks" =>  "Tasks"),
                array("fas fa-taxi" =>  "Taxi"),
                array("fas fa-teeth" =>  "Teeth"),
                array("fas fa-teeth-open" => "Teeth Open"),
                array("fas fa-temperature-high" => "Temperature High"),
                array("fas fa-temperature-low" => "Temperature Low"),
                array("fas fa-tenge" =>  "Tenge"),
                array("fas fa-terminal" =>  "Terminal"),
                array("fas fa-text-height" => "Text Height"),
                array("fas fa-text-width" => "Text Width"),
                array("fas fa-th" =>  "Th"),
                array("fas fa-th-large" =>  "Th Large"),
                array("fas fa-th-list" =>  "Th List"),
                array("fas fa-theater-masks" => "Theater Masks"),
                array("fas fa-thermometer" => "Thermometer"),
                array("fas fa-thermometer-empty" => "Thermometer Empty"),
                array("fas fa-thermometer-full" => "Thermometer Full"),
                array("fas fa-thermometer-half" => "Thermometer Half"),
                array("fas fa-thermometer-quarter" => "Thermometer Quarter"),
                array("fas fa-thermometer-three-quarters" => "Thermometer Three Quarters"),
                array("fas fa-thumbs-down" => "Thumbs Down"),
                array("fas fa-thumbs-up" =>  "Thumbs Up"),
                array("fas fa-thumbtack" =>  "Thumbtack"),
                array("fas fa-ticket-alt" => "Ticket Alt"),
                array("fas fa-times" =>  "Times"),
                array("fas fa-times-circle" => "Times Circle"),
                array("fas fa-tint" =>  "Tint"),
                array("fas fa-tint-slash" => "Tint Slash"),
                array("fas fa-tired" =>  "Tired"),
                array("fas fa-toggle-off" => "Toggle Off"),
                array("fas fa-toggle-on" =>  "Toggle On"),
                array("fas fa-toilet" =>  "Toilet"),
                array("fas fa-toilet-paper" => "Toilet Paper"),
                array("fas fa-toilet-paper-slash" => "Toilet Paper Slash"),
                array("fas fa-toolbox" =>  "Toolbox"),
                array("fas fa-tools" =>  "Tools"),
                array("fas fa-tooth" =>  "Tooth"),
                array("fas fa-torah" =>  "Torah"),
                array("fas fa-torii-gate" => "Torii Gate"),
                array("fas fa-tractor" =>  "Tractor"),
                array("fas fa-trademark" =>  "Trademark"),
                array("fas fa-traffic-light" => "Traffic Light"),
                array("fas fa-trailer" =>  "Trailer"),
                array("fas fa-train" =>  "Train"),
                array("fas fa-tram" =>  "Tram"),
                array("fas fa-transgender" => "Transgender"),
                array("fas fa-transgender-alt" => "Transgender Alt"),
                array("fas fa-trash" =>  "Trash"),
                array("fas fa-trash-alt" =>  "Trash Alt"),
                array("fas fa-trash-restore" => "Trash Restore"),
                array("fas fa-trash-restore-alt" => "Trash Restore Alt"),
                array("fas fa-tree" =>  "Tree"),
                array("fas fa-trophy" =>  "Trophy"),
                array("fas fa-truck" =>  "Truck"),
                array("fas fa-truck-loading" => "Truck Loading"),
                array("fas fa-truck-monster" => "Truck Monster"),
                array("fas fa-truck-moving" => "Truck Moving"),
                array("fas fa-truck-pickup" => "Truck Pickup"),
                array("fas fa-tshirt" =>  "Tshirt"),
                array("fas fa-tty" =>  "Tty"),
                array("fas fa-tv" =>  "Tv"),
                array("fas fa-umbrella" =>  "Umbrella"),
                array("fas fa-umbrella-beach" => "Umbrella Beach"),
                array("fas fa-underline" =>  "Underline"),
                array("fas fa-undo" =>  "Undo"),
                array("fas fa-undo-alt" =>  "Undo Alt"),
                array("fas fa-universal-access" => "Universal Access"),
                array("fas fa-university" => "University"),
                array("fas fa-unlink" =>  "Unlink"),
                array("fas fa-unlock" =>  "Unlock"),
                array("fas fa-unlock-alt" => "Unlock Alt"),
                array("fas fa-upload" =>  "Upload"),
                array("fas fa-user" =>  "User"),
                array("fas fa-user-alt" =>  "User Alt"),
                array("fas fa-user-alt-slash" => "User Alt Slash"),
                array("fas fa-user-astronaut" => "User Astronaut"),
                array("fas fa-user-check" => "User Check"),
                array("fas fa-user-circle" => "User Circle"),
                array("fas fa-user-clock" => "User Clock"),
                array("fas fa-user-cog" =>  "User Cog"),
                array("fas fa-user-edit" =>  "User Edit"),
                array("fas fa-user-friends" => "User Friends"),
                array("fas fa-user-graduate" => "User Graduate"),
                array("fas fa-user-injured" => "User Injured"),
                array("fas fa-user-lock" =>  "User Lock"),
                array("fas fa-user-md" =>  "User Md"),
                array("fas fa-user-minus" => "User Minus"),
                array("fas fa-user-ninja" => "User Ninja"),
                array("fas fa-user-nurse" => "User Nurse"),
                array("fas fa-user-plus" =>  "User Plus"),
                array("fas fa-user-secret" => "User Secret"),
                array("fas fa-user-shield" => "User Shield"),
                array("fas fa-user-slash" => "User Slash"),
                array("fas fa-user-tag" =>  "User Tag"),
                array("fas fa-user-tie" =>  "User Tie"),
                array("fas fa-user-times" => "User Times"),
                array("fas fa-users" =>  "Users"),
                array("fas fa-users-cog" =>  "Users Cog"),
                array("fas fa-utensil-spoon" => "Utensil Spoon"),
                array("fas fa-utensils" =>  "Utensils"),
                array("fas fa-vector-square" => "Vector Square"),
                array("fas fa-venus" =>  "Venus"),
                array("fas fa-venus-double" => "Venus Double"),
                array("fas fa-venus-mars" => "Venus Mars"),
                array("fas fa-vial" =>  "Vial"),
                array("fas fa-vials" =>  "Vials"),
                array("fas fa-video" =>  "Video"),
                array("fas fa-video-slash" => "Video Slash"),
                array("fas fa-vihara" =>  "Vihara"),
                array("fas fa-virus" =>  "Virus"),
                array("fas fa-virus-slash" => "Virus Slash"),
                array("fas fa-viruses" =>  "Viruses"),
                array("fas fa-voicemail" =>  "Voicemail"),
                array("fas fa-volleyball-ball" => "Volleyball Ball"),
                array("fas fa-volume-down" => "Volume Down"),
                array("fas fa-volume-mute" => "Volume Mute"),
                array("fas fa-volume-off" => "Volume Off"),
                array("fas fa-volume-up" =>  "Volume Up"),
                array("fas fa-vote-yea" =>  "Vote Yea"),
                array("fas fa-vr-cardboard" => "Vr Cardboard"),
                array("fas fa-walking" =>  "Walking"),
                array("fas fa-wallet" =>  "Wallet"),
                array("fas fa-warehouse" =>  "Warehouse"),
                array("fas fa-water" =>  "Water"),
                array("fas fa-wave-square" => "Wave Square"),
                array("fas fa-weight" =>  "Weight"),
                array("fas fa-weight-hanging" => "Weight Hanging"),
                array("fas fa-wheelchair" => "Wheelchair"),
                array("fas fa-wifi" =>  "Wifi"),
                array("fas fa-wind" =>  "Wind"),
                array("fas fa-window-close" => "Window Close"),
                array("fas fa-window-maximize" => "Window Maximize"),
                array("fas fa-window-minimize" => "Window Minimize"),
                array("fas fa-window-restore" => "Window Restore"),
                array("fas fa-wine-bottle" => "Wine Bottle"),
                array("fas fa-wine-glass" => "Wine Glass"),
                array("fas fa-wine-glass-alt" => "Wine Glass Alt"),
                array("fas fa-won-sign" =>  "Won Sign"),
                array("fas fa-wrench" =>  "Wrench"),
                array("fas fa-x-ray" =>  "X Ray"),
                array("fas fa-yen-sign" =>  "Yen Sign"),
                array("fas fa-yin-yang" =>  "Yin Yang"),
            ),
            'Regular' => array(
                array("far fa-address-book" => "Address Book"),
                array("far fa-address-card" => "Address Card"),
                array("far fa-angry" =>  "Angry"),
                array("far fa-arrow-alt-circle-down" => "Arrow Alt Circle Down"),
                array("far fa-arrow-alt-circle-left" => "Arrow Alt Circle Left"),
                array("far fa-arrow-alt-circle-right" => "Arrow Alt Circle Right"),
                array("far fa-arrow-alt-circle-up" => "Arrow Alt Circle Up"),
                array("far fa-bell" =>  "Bell"),
                array("far fa-bell-slash" => "Bell Slash"),
                array("far fa-bookmark" =>  "Bookmark"),
                array("far fa-building" =>  "Building"),
                array("far fa-calendar" =>  "Calendar"),
                array("far fa-calendar-alt" => "Calendar Alt"),
                array("far fa-calendar-check" => "Calendar Check"),
                array("far fa-calendar-minus" => "Calendar Minus"),
                array("far fa-calendar-plus" => "Calendar Plus"),
                array("far fa-calendar-times" => "Calendar Times"),
                array("far fa-caret-square-down" => "Caret Square Down"),
                array("far fa-caret-square-left" => "Caret Square Left"),
                array("far fa-caret-square-right" => "Caret Square Right"),
                array("far fa-caret-square-up" => "Caret Square Up"),
                array("far fa-chart-bar" =>  "Chart Bar"),
                array("far fa-check-circle" => "Check Circle"),
                array("far fa-check-square" => "Check Square"),
                array("far fa-circle" =>  "Circle"),
                array("far fa-clipboard" =>  "Clipboard"),
                array("far fa-clock" =>  "Clock"),
                array("far fa-clone" =>  "Clone"),
                array("far fa-closed-captioning" => "Closed Captioning"),
                array("far fa-comment" =>  "Comment"),
                array("far fa-comment-alt" => "Comment Alt"),
                array("far fa-comment-dots" => "Comment Dots"),
                array("far fa-comments" =>  "Comments"),
                array("far fa-compass" =>  "Compass"),
                array("far fa-copy" =>  "Copy"),
                array("far fa-copyright" =>  "Copyright"),
                array("far fa-credit-card" => "Credit Card"),
                array("far fa-dizzy" =>  "Dizzy"),
                array("far fa-dot-circle" => "Dot Circle"),
                array("far fa-edit" =>  "Edit"),
                array("far fa-envelope" =>  "Envelope"),
                array("far fa-envelope-open" => "Envelope Open"),
                array("far fa-eye" =>  "Eye"),
                array("far fa-eye-slash" =>  "Eye Slash"),
                array("far fa-file" =>  "File"),
                array("far fa-file-alt" =>  "File Alt"),
                array("far fa-file-archive" => "File Archive"),
                array("far fa-file-audio" => "File Audio"),
                array("far fa-file-code" =>  "File Code"),
                array("far fa-file-excel" => "File Excel"),
                array("far fa-file-image" => "File Image"),
                array("far fa-file-pdf" =>  "File Pdf"),
                array("far fa-file-powerpoint" => "File Powerpoint"),
                array("far fa-file-video" => "File Video"),
                array("far fa-file-word" =>  "File Word"),
                array("far fa-flag" =>  "Flag"),
                array("far fa-flushed" =>  "Flushed"),
                array("far fa-folder" =>  "Folder"),
                array("far fa-folder-open" => "Folder Open"),
                array("far fa-frown" =>  "Frown"),
                array("far fa-frown-open" => "Frown Open"),
                array("far fa-futbol" =>  "Futbol"),
                array("far fa-gem" =>  "Gem"),
                array("far fa-grimace" =>  "Grimace"),
                array("far fa-grin" =>  "Grin"),
                array("far fa-grin-alt" =>  "Grin Alt"),
                array("far fa-grin-beam" =>  "Grin Beam"),
                array("far fa-grin-beam-sweat" => "Grin Beam Sweat"),
                array("far fa-grin-hearts" => "Grin Hearts"),
                array("far fa-grin-squint" => "Grin Squint"),
                array("far fa-grin-squint-tears" => "Grin Squint Tears"),
                array("far fa-grin-stars" => "Grin Stars"),
                array("far fa-grin-tears" => "Grin Tears"),
                array("far fa-grin-tongue" => "Grin Tongue"),
                array("far fa-grin-tongue-squint" => "Grin Tongue Squint"),
                array("far fa-grin-tongue-wink" => "Grin Tongue Wink"),
                array("far fa-grin-wink" =>  "Grin Wink"),
                array("far fa-hand-lizard" => "Hand Lizard"),
                array("far fa-hand-paper" => "Hand Paper"),
                array("far fa-hand-peace" => "Hand Peace"),
                array("far fa-hand-point-down" => "Hand Point Down"),
                array("far fa-hand-point-left" => "Hand Point Left"),
                array("far fa-hand-point-right" => "Hand Point Right"),
                array("far fa-hand-point-up" => "Hand Point Up"),
                array("far fa-hand-pointer" => "Hand Pointer"),
                array("far fa-hand-rock" =>  "Hand Rock"),
                array("far fa-hand-scissors" => "Hand Scissors"),
                array("far fa-hand-spock" => "Hand Spock"),
                array("far fa-handshake" =>  "Handshake"),
                array("far fa-hdd" =>  "Hdd"),
                array("far fa-heart" =>  "Heart"),
                array("far fa-hospital" =>  "Hospital"),
                array("far fa-hourglass" =>  "Hourglass"),
                array("far fa-id-badge" =>  "Id Badge"),
                array("far fa-id-card" =>  "Id Card"),
                array("far fa-image" =>  "Image"),
                array("far fa-images" =>  "Images"),
                array("far fa-keyboard" =>  "Keyboard"),
                array("far fa-kiss" =>  "Kiss"),
                array("far fa-kiss-beam" =>  "Kiss Beam"),
                array("far fa-kiss-wink-heart" => "Kiss Wink Heart"),
                array("far fa-laugh" =>  "Laugh"),
                array("far fa-laugh-beam" => "Laugh Beam"),
                array("far fa-laugh-squint" => "Laugh Squint"),
                array("far fa-laugh-wink" => "Laugh Wink"),
                array("far fa-lemon" =>  "Lemon"),
                array("far fa-life-ring" =>  "Life Ring"),
                array("far fa-lightbulb" =>  "Lightbulb"),
                array("far fa-list-alt" =>  "List Alt"),
                array("far fa-map" =>  "Map"),
                array("far fa-meh" =>  "Meh"),
                array("far fa-meh-blank" =>  "Meh Blank"),
                array("far fa-meh-rolling-eyes" => "Meh Rolling Eyes"),
                array("far fa-minus-square" => "Minus Square"),
                array("far fa-money-bill-alt" => "Money Bill Alt"),
                array("far fa-moon" =>  "Moon"),
                array("far fa-newspaper" =>  "Newspaper"),
                array("far fa-object-group" => "Object Group"),
                array("far fa-object-ungroup" => "Object Ungroup"),
                array("far fa-paper-plane" => "Paper Plane"),
                array("far fa-pause-circle" => "Pause Circle"),
                array("far fa-play-circle" => "Play Circle"),
                array("far fa-plus-square" => "Plus Square"),
                array("far fa-question-circle" => "Question Circle"),
                array("far fa-registered" => "Registered"),
                array("far fa-sad-cry" =>  "Sad Cry"),
                array("far fa-sad-tear" =>  "Sad Tear"),
                array("far fa-save" =>  "Save"),
                array("far fa-share-square" => "Share Square"),
                array("far fa-smile" =>  "Smile"),
                array("far fa-smile-beam" => "Smile Beam"),
                array("far fa-smile-wink" => "Smile Wink"),
                array("far fa-snowflake" =>  "Snowflake"),
                array("far fa-square" =>  "Square"),
                array("far fa-star" =>  "Star"),
                array("far fa-star-half" =>  "Star Half"),
                array("far fa-sticky-note" => "Sticky Note"),
                array("far fa-stop-circle" => "Stop Circle"),
                array("far fa-sun" =>  "Sun"),
                array("far fa-surprise" =>  "Surprise"),
                array("far fa-thumbs-down" => "Thumbs Down"),
                array("far fa-thumbs-up" =>  "Thumbs Up"),
                array("far fa-times-circle" => "Times Circle"),
                array("far fa-tired" =>  "Tired"),
                array("far fa-trash-alt" =>  "Trash Alt"),
                array("far fa-user" =>  "User"),
                array("far fa-user-circle" => "User Circle"),
                array("far fa-window-close" => "Window Close"),
                array("far fa-window-maximize" => "Window Maximize"),
                array("far fa-window-minimize" => "Window Minimize"),
                array("far fa-window-restore" => "Window Restore"),
            ),
            'Brand' => array(
                array("fab fa-500px" =>  "500px"),
                array("fab fa-accessible-icon" => "Accessible Icon"),
                array("fab fa-accusoft" =>  "Accusoft"),
                array("fab fa-acquisitions-incorporated" => "Acquisitions Incorporated"),
                array("fab fa-adn" =>  "Adn"),
                array("fab fa-adobe" =>  "Adobe"),
                array("fab fa-adversal" =>  "Adversal"),
                array("fab fa-affiliatetheme" => "Affiliatetheme"),
                array("fab fa-airbnb" =>  "Airbnb"),
                array("fab fa-algolia" =>  "Algolia"),
                array("fab fa-alipay" =>  "Alipay"),
                array("fab fa-amazon" =>  "Amazon"),
                array("fab fa-amazon-pay" => "Amazon Pay"),
                array("fab fa-amilia" =>  "Amilia"),
                array("fab fa-android" =>  "Android"),
                array("fab fa-angellist" =>  "Angellist"),
                array("fab fa-angrycreative" => "Angrycreative"),
                array("fab fa-angular" =>  "Angular"),
                array("fab fa-app-store" =>  "App Store"),
                array("fab fa-app-store-ios" => "App Store Ios"),
                array("fab fa-apper" =>  "Apper"),
                array("fab fa-apple" =>  "Apple"),
                array("fab fa-apple-pay" =>  "Apple Pay"),
                array("fab fa-artstation" => "Artstation"),
                array("fab fa-asymmetrik" => "Asymmetrik"),
                array("fab fa-atlassian" =>  "Atlassian"),
                array("fab fa-audible" =>  "Audible"),
                array("fab fa-autoprefixer" => "Autoprefixer"),
                array("fab fa-avianex" =>  "Avianex"),
                array("fab fa-aviato" =>  "Aviato"),
                array("fab fa-aws" =>  "Aws"),
                array("fab fa-bandcamp" =>  "Bandcamp"),
                array("fab fa-battle-net" => "Battle Net"),
                array("fab fa-behance" =>  "Behance"),
                array("fab fa-behance-square" => "Behance Square"),
                array("fab fa-bimobject" =>  "Bimobject"),
                array("fab fa-bitbucket" =>  "Bitbucket"),
                array("fab fa-bitcoin" =>  "Bitcoin"),
                array("fab fa-bity" =>  "Bity"),
                array("fab fa-black-tie" =>  "Black Tie"),
                array("fab fa-blackberry" => "Blackberry"),
                array("fab fa-blogger" =>  "Blogger"),
                array("fab fa-blogger-b" =>  "Blogger B"),
                array("fab fa-bluetooth" =>  "Bluetooth"),
                array("fab fa-bluetooth-b" => "Bluetooth B"),
                array("fab fa-bootstrap" =>  "Bootstrap"),
                array("fab fa-btc" =>  "Btc"),
                array("fab fa-buffer" =>  "Buffer"),
                array("fab fa-buromobelexperte" => "Buromobelexperte"),
                array("fab fa-buy-n-large" => "Buy N Large"),
                array("fab fa-buysellads" => "Buysellads"),
                array("fab fa-canadian-maple-leaf" => "Canadian Maple Leaf"),
                array("fab fa-cc-amazon-pay" => "Cc Amazon Pay"),
                array("fab fa-cc-amex" =>  "Cc Amex"),
                array("fab fa-cc-apple-pay" => "Cc Apple Pay"),
                array("fab fa-cc-diners-club" => "Cc Diners Club"),
                array("fab fa-cc-discover" => "Cc Discover"),
                array("fab fa-cc-jcb" =>  "Cc Jcb"),
                array("fab fa-cc-mastercard" => "Cc Mastercard"),
                array("fab fa-cc-paypal" =>  "Cc Paypal"),
                array("fab fa-cc-stripe" =>  "Cc Stripe"),
                array("fab fa-cc-visa" =>  "Cc Visa"),
                array("fab fa-centercode" => "Centercode"),
                array("fab fa-centos" =>  "Centos"),
                array("fab fa-chrome" =>  "Chrome"),
                array("fab fa-chromecast" => "Chromecast"),
                array("fab fa-cloudscale" => "Cloudscale"),
                array("fab fa-cloudsmith" => "Cloudsmith"),
                array("fab fa-cloudversify" => "Cloudversify"),
                array("fab fa-codepen" =>  "Codepen"),
                array("fab fa-codiepie" =>  "Codiepie"),
                array("fab fa-confluence" => "Confluence"),
                array("fab fa-connectdevelop" => "Connectdevelop"),
                array("fab fa-contao" =>  "Contao"),
                array("fab fa-cotton-bureau" => "Cotton Bureau"),
                array("fab fa-cpanel" =>  "Cpanel"),
                array("fab fa-creative-commons" => "Creative Commons"),
                array("fab fa-creative-commons-by" => "Creative Commons By"),
                array("fab fa-creative-commons-nc" => "Creative Commons Nc"),
                array("fab fa-creative-commons-nc-eu" => "Creative Commons Nc Eu"),
                array("fab fa-creative-commons-nc-jp" => "Creative Commons Nc Jp"),
                array("fab fa-creative-commons-nd" => "Creative Commons Nd"),
                array("fab fa-creative-commons-pd" => "Creative Commons Pd"),
                array("fab fa-creative-commons-pd-alt" => "Creative Commons Pd Alt"),
                array("fab fa-creative-commons-remix" => "Creative Commons Remix"),
                array("fab fa-creative-commons-sa" => "Creative Commons Sa"),
                array("fab fa-creative-commons-sampling" => "Creative Commons Sampling"),
                array("fab fa-creative-commons-sampling-plus" => "Creative Commons Sampling Plus"),
                array("fab fa-creative-commons-share" => "Creative Commons Share"),
                array("fab fa-creative-commons-zero" => "Creative Commons Zero"),
                array("fab fa-critical-role" => "Critical Role"),
                array("fab fa-css3" =>  "Css3"),
                array("fab fa-css3-alt" =>  "Css3 Alt"),
                array("fab fa-cuttlefish" => "Cuttlefish"),
                array("fab fa-d-and-d" =>  "D And D"),
                array("fab fa-d-and-d-beyond" => "D And D Beyond"),
                array("fab fa-dailymotion" => "Dailymotion"),
                array("fab fa-dashcube" =>  "Dashcube"),
                array("fab fa-delicious" =>  "Delicious"),
                array("fab fa-deploydog" =>  "Deploydog"),
                array("fab fa-deskpro" =>  "Deskpro"),
                array("fab fa-dev" =>  "Dev"),
                array("fab fa-deviantart" => "Deviantart"),
                array("fab fa-dhl" =>  "Dhl"),
                array("fab fa-diaspora" =>  "Diaspora"),
                array("fab fa-digg" =>  "Digg"),
                array("fab fa-digital-ocean" => "Digital Ocean"),
                array("fab fa-discord" =>  "Discord"),
                array("fab fa-discourse" =>  "Discourse"),
                array("fab fa-dochub" =>  "Dochub"),
                array("fab fa-docker" =>  "Docker"),
                array("fab fa-draft2digital" => "Draft2digital"),
                array("fab fa-dribbble" =>  "Dribbble"),
                array("fab fa-dribbble-square" => "Dribbble Square"),
                array("fab fa-dropbox" =>  "Dropbox"),
                array("fab fa-drupal" =>  "Drupal"),
                array("fab fa-dyalog" =>  "Dyalog"),
                array("fab fa-earlybirds" => "Earlybirds"),
                array("fab fa-ebay" =>  "Ebay"),
                array("fab fa-edge" =>  "Edge"),
                array("fab fa-elementor" =>  "Elementor"),
                array("fab fa-ello" =>  "Ello"),
                array("fab fa-ember" =>  "Ember"),
                array("fab fa-empire" =>  "Empire"),
                array("fab fa-envira" =>  "Envira"),
                array("fab fa-erlang" =>  "Erlang"),
                array("fab fa-ethereum" =>  "Ethereum"),
                array("fab fa-etsy" =>  "Etsy"),
                array("fab fa-evernote" =>  "Evernote"),
                array("fab fa-expeditedssl" => "Expeditedssl"),
                array("fab fa-facebook" =>  "Facebook"),
                array("fab fa-facebook-f" => "Facebook F"),
                array("fab fa-facebook-messenger" => "Facebook Messenger"),
                array("fab fa-facebook-square" => "Facebook Square"),
                array("fab fa-fantasy-flight-games" => "Fantasy Flight Games"),
                array("fab fa-fedex" =>  "Fedex"),
                array("fab fa-fedora" =>  "Fedora"),
                array("fab fa-figma" =>  "Figma"),
                array("fab fa-firefox" =>  "Firefox"),
                array("fab fa-firefox-browser" => "Firefox Browser"),
                array("fab fa-first-order" => "First Order"),
                array("fab fa-first-order-alt" => "First Order Alt"),
                array("fab fa-firstdraft" => "Firstdraft"),
                array("fab fa-flickr" =>  "Flickr"),
                array("fab fa-flipboard" =>  "Flipboard"),
                array("fab fa-fly" =>  "Fly"),
                array("fab fa-font-awesome" => "Font Awesome"),
                array("fab fa-font-awesome-alt" => "Font Awesome Alt"),
                array("fab fa-font-awesome-flag" => "Font Awesome Flag"),
                array("fab fa-fonticons" =>  "Fonticons"),
                array("fab fa-fonticons-fi" => "Fonticons Fi"),
                array("fab fa-fort-awesome" => "Fort Awesome"),
                array("fab fa-fort-awesome-alt" => "Fort Awesome Alt"),
                array("fab fa-forumbee" =>  "Forumbee"),
                array("fab fa-foursquare" => "Foursquare"),
                array("fab fa-free-code-camp" => "Free Code Camp"),
                array("fab fa-freebsd" =>  "Freebsd"),
                array("fab fa-fulcrum" =>  "Fulcrum"),
                array("fab fa-galactic-republic" => "Galactic Republic"),
                array("fab fa-galactic-senate" => "Galactic Senate"),
                array("fab fa-get-pocket" => "Get Pocket"),
                array("fab fa-gg" =>  "Gg"),
                array("fab fa-gg-circle" =>  "Gg Circle"),
                array("fab fa-git" =>  "Git"),
                array("fab fa-git-alt" =>  "Git Alt"),
                array("fab fa-git-square" => "Git Square"),
                array("fab fa-github" =>  "Github"),
                array("fab fa-github-alt" => "Github Alt"),
                array("fab fa-github-square" => "Github Square"),
                array("fab fa-gitkraken" =>  "Gitkraken"),
                array("fab fa-gitlab" =>  "Gitlab"),
                array("fab fa-gitter" =>  "Gitter"),
                array("fab fa-glide" =>  "Glide"),
                array("fab fa-glide-g" =>  "Glide G"),
                array("fab fa-gofore" =>  "Gofore"),
                array("fab fa-goodreads" =>  "Goodreads"),
                array("fab fa-goodreads-g" => "Goodreads G"),
                array("fab fa-google" =>  "Google"),
                array("fab fa-google-drive" => "Google Drive"),
                array("fab fa-google-play" => "Google Play"),
                array("fab fa-google-plus" => "Google Plus"),
                array("fab fa-google-plus-g" => "Google Plus G"),
                array("fab fa-google-plus-square" => "Google Plus Square"),
                array("fab fa-google-wallet" => "Google Wallet"),
                array("fab fa-gratipay" =>  "Gratipay"),
                array("fab fa-grav" =>  "Grav"),
                array("fab fa-gripfire" =>  "Gripfire"),
                array("fab fa-grunt" =>  "Grunt"),
                array("fab fa-gulp" =>  "Gulp"),
                array("fab fa-hacker-news" => "Hacker News"),
                array("fab fa-hacker-news-square" => "Hacker News Square"),
                array("fab fa-hackerrank" => "Hackerrank"),
                array("fab fa-hips" =>  "Hips"),
                array("fab fa-hire-a-helper" => "Hire A Helper"),
                array("fab fa-hooli" =>  "Hooli"),
                array("fab fa-hornbill" =>  "Hornbill"),
                array("fab fa-hotjar" =>  "Hotjar"),
                array("fab fa-houzz" =>  "Houzz"),
                array("fab fa-html5" =>  "Html5"),
                array("fab fa-hubspot" =>  "Hubspot"),
                array("fab fa-ideal" =>  "Ideal"),
                array("fab fa-imdb" =>  "Imdb"),
                array("fab fa-instagram" =>  "Instagram"),
                array("fab fa-instagram-square" => "Instagram Square"),
                array("fab fa-intercom" =>  "Intercom"),
                array("fab fa-internet-explorer" => "Internet Explorer"),
                array("fab fa-invision" =>  "Invision"),
                array("fab fa-ioxhost" =>  "Ioxhost"),
                array("fab fa-itch-io" =>  "Itch Io"),
                array("fab fa-itunes" =>  "Itunes"),
                array("fab fa-itunes-note" => "Itunes Note"),
                array("fab fa-java" =>  "Java"),
                array("fab fa-jedi-order" => "Jedi Order"),
                array("fab fa-jenkins" =>  "Jenkins"),
                array("fab fa-jira" =>  "Jira"),
                array("fab fa-joget" =>  "Joget"),
                array("fab fa-joomla" =>  "Joomla"),
                array("fab fa-js" =>  "Js"),
                array("fab fa-js-square" =>  "Js Square"),
                array("fab fa-jsfiddle" =>  "Jsfiddle"),
                array("fab fa-kaggle" =>  "Kaggle"),
                array("fab fa-keybase" =>  "Keybase"),
                array("fab fa-keycdn" =>  "Keycdn"),
                array("fab fa-kickstarter" => "Kickstarter"),
                array("fab fa-kickstarter-k" => "Kickstarter K"),
                array("fab fa-korvue" =>  "Korvue"),
                array("fab fa-laravel" =>  "Laravel"),
                array("fab fa-lastfm" =>  "Lastfm"),
                array("fab fa-lastfm-square" => "Lastfm Square"),
                array("fab fa-leanpub" =>  "Leanpub"),
                array("fab fa-less" =>  "Less"),
                array("fab fa-line" =>  "Line"),
                array("fab fa-linkedin" =>  "Linkedin"),
                array("fab fa-linkedin-in" => "Linkedin In"),
                array("fab fa-linode" =>  "Linode"),
                array("fab fa-linux" =>  "Linux"),
                array("fab fa-lyft" =>  "Lyft"),
                array("fab fa-magento" =>  "Magento"),
                array("fab fa-mailchimp" =>  "Mailchimp"),
                array("fab fa-mandalorian" => "Mandalorian"),
                array("fab fa-markdown" =>  "Markdown"),
                array("fab fa-mastodon" =>  "Mastodon"),
                array("fab fa-maxcdn" =>  "Maxcdn"),
                array("fab fa-mdb" =>  "Mdb"),
                array("fab fa-medapps" =>  "Medapps"),
                array("fab fa-medium" =>  "Medium"),
                array("fab fa-medium-m" =>  "Medium M"),
                array("fab fa-medrt" =>  "Medrt"),
                array("fab fa-meetup" =>  "Meetup"),
                array("fab fa-megaport" =>  "Megaport"),
                array("fab fa-mendeley" =>  "Mendeley"),
                array("fab fa-microblog" =>  "Microblog"),
                array("fab fa-microsoft" =>  "Microsoft"),
                array("fab fa-mix" =>  "Mix"),
                array("fab fa-mixcloud" =>  "Mixcloud"),
                array("fab fa-mixer" =>  "Mixer"),
                array("fab fa-mizuni" =>  "Mizuni"),
                array("fab fa-modx" =>  "Modx"),
                array("fab fa-monero" =>  "Monero"),
                array("fab fa-napster" =>  "Napster"),
                array("fab fa-neos" =>  "Neos"),
                array("fab fa-nimblr" =>  "Nimblr"),
                array("fab fa-node" =>  "Node"),
                array("fab fa-node-js" =>  "Node Js"),
                array("fab fa-npm" =>  "Npm"),
                array("fab fa-ns8" =>  "Ns8"),
                array("fab fa-nutritionix" => "Nutritionix"),
                array("fab fa-odnoklassniki" => "Odnoklassniki"),
                array("fab fa-odnoklassniki-square" => "Odnoklassniki Square"),
                array("fab fa-old-republic" => "Old Republic"),
                array("fab fa-opencart" =>  "Opencart"),
                array("fab fa-openid" =>  "Openid"),
                array("fab fa-opera" =>  "Opera"),
                array("fab fa-optin-monster" => "Optin Monster"),
                array("fab fa-orcid" =>  "Orcid"),
                array("fab fa-osi" =>  "Osi"),
                array("fab fa-page4" =>  "Page4"),
                array("fab fa-pagelines" =>  "Pagelines"),
                array("fab fa-palfed" =>  "Palfed"),
                array("fab fa-patreon" =>  "Patreon"),
                array("fab fa-paypal" =>  "Paypal"),
                array("fab fa-penny-arcade" => "Penny Arcade"),
                array("fab fa-periscope" =>  "Periscope"),
                array("fab fa-phabricator" => "Phabricator"),
                array("fab fa-phoenix-framework" => "Phoenix Framework"),
                array("fab fa-phoenix-squadron" => "Phoenix Squadron"),
                array("fab fa-php" =>  "Php"),
                array("fab fa-pied-piper" => "Pied Piper"),
                array("fab fa-pied-piper-alt" => "Pied Piper Alt"),
                array("fab fa-pied-piper-hat" => "Pied Piper Hat"),
                array("fab fa-pied-piper-pp" => "Pied Piper Pp"),
                array("fab fa-pied-piper-square" => "Pied Piper Square"),
                array("fab fa-pinterest" =>  "Pinterest"),
                array("fab fa-pinterest-p" => "Pinterest P"),
                array("fab fa-pinterest-square" => "Pinterest Square"),
                array("fab fa-playstation" => "Playstation"),
                array("fab fa-product-hunt" => "Product Hunt"),
                array("fab fa-pushed" =>  "Pushed"),
                array("fab fa-python" =>  "Python"),
                array("fab fa-qq" =>  "Qq"),
                array("fab fa-quinscape" =>  "Quinscape"),
                array("fab fa-quora" =>  "Quora"),
                array("fab fa-r-project" =>  "R Project"),
                array("fab fa-raspberry-pi" => "Raspberry Pi"),
                array("fab fa-ravelry" =>  "Ravelry"),
                array("fab fa-react" =>  "React"),
                array("fab fa-reacteurope" => "Reacteurope"),
                array("fab fa-readme" =>  "Readme"),
                array("fab fa-rebel" =>  "Rebel"),
                array("fab fa-red-river" =>  "Red River"),
                array("fab fa-reddit" =>  "Reddit"),
                array("fab fa-reddit-alien" => "Reddit Alien"),
                array("fab fa-reddit-square" => "Reddit Square"),
                array("fab fa-redhat" =>  "Redhat"),
                array("fab fa-renren" =>  "Renren"),
                array("fab fa-replyd" =>  "Replyd"),
                array("fab fa-researchgate" => "Researchgate"),
                array("fab fa-resolving" =>  "Resolving"),
                array("fab fa-rev" =>  "Rev"),
                array("fab fa-rocketchat" => "Rocketchat"),
                array("fab fa-rockrms" =>  "Rockrms"),
                array("fab fa-safari" =>  "Safari"),
                array("fab fa-salesforce" => "Salesforce"),
                array("fab fa-sass" =>  "Sass"),
                array("fab fa-schlix" =>  "Schlix"),
                array("fab fa-scribd" =>  "Scribd"),
                array("fab fa-searchengin" => "Searchengin"),
                array("fab fa-sellcast" =>  "Sellcast"),
                array("fab fa-sellsy" =>  "Sellsy"),
                array("fab fa-servicestack" => "Servicestack"),
                array("fab fa-shirtsinbulk" => "Shirtsinbulk"),
                array("fab fa-shopify" =>  "Shopify"),
                array("fab fa-shopware" =>  "Shopware"),
                array("fab fa-simplybuilt" => "Simplybuilt"),
                array("fab fa-sistrix" =>  "Sistrix"),
                array("fab fa-sith" =>  "Sith"),
                array("fab fa-sketch" =>  "Sketch"),
                array("fab fa-skyatlas" =>  "Skyatlas"),
                array("fab fa-skype" =>  "Skype"),
                array("fab fa-slack" =>  "Slack"),
                array("fab fa-slack-hash" => "Slack Hash"),
                array("fab fa-slideshare" => "Slideshare"),
                array("fab fa-snapchat" =>  "Snapchat"),
                array("fab fa-snapchat-ghost" => "Snapchat Ghost"),
                array("fab fa-snapchat-square" => "Snapchat Square"),
                array("fab fa-soundcloud" => "Soundcloud"),
                array("fab fa-sourcetree" => "Sourcetree"),
                array("fab fa-speakap" =>  "Speakap"),
                array("fab fa-speaker-deck" => "Speaker Deck"),
                array("fab fa-spotify" =>  "Spotify"),
                array("fab fa-squarespace" => "Squarespace"),
                array("fab fa-stack-exchange" => "Stack Exchange"),
                array("fab fa-stack-overflow" => "Stack Overflow"),
                array("fab fa-stackpath" =>  "Stackpath"),
                array("fab fa-staylinked" => "Staylinked"),
                array("fab fa-steam" =>  "Steam"),
                array("fab fa-steam-square" => "Steam Square"),
                array("fab fa-steam-symbol" => "Steam Symbol"),
                array("fab fa-sticker-mule" => "Sticker Mule"),
                array("fab fa-strava" =>  "Strava"),
                array("fab fa-stripe" =>  "Stripe"),
                array("fab fa-stripe-s" =>  "Stripe S"),
                array("fab fa-studiovinari" => "Studiovinari"),
                array("fab fa-stumbleupon" => "Stumbleupon"),
                array("fab fa-stumbleupon-circle" => "Stumbleupon Circle"),
                array("fab fa-superpowers" => "Superpowers"),
                array("fab fa-supple" =>  "Supple"),
                array("fab fa-suse" =>  "Suse"),
                array("fab fa-swift" =>  "Swift"),
                array("fab fa-symfony" =>  "Symfony"),
                array("fab fa-teamspeak" =>  "Teamspeak"),
                array("fab fa-telegram" =>  "Telegram"),
                array("fab fa-telegram-plane" => "Telegram Plane"),
                array("fab fa-tencent-weibo" => "Tencent Weibo"),
                array("fab fa-the-red-yeti" => "The Red Yeti"),
                array("fab fa-themeco" =>  "Themeco"),
                array("fab fa-themeisle" =>  "Themeisle"),
                array("fab fa-think-peaks" => "Think Peaks"),
                array("fab fa-trade-federation" => "Trade Federation"),
                array("fab fa-trello" =>  "Trello"),
                array("fab fa-tripadvisor" => "Tripadvisor"),
                array("fab fa-tumblr" =>  "Tumblr"),
                array("fab fa-tumblr-square" => "Tumblr Square"),
                array("fab fa-twitch" =>  "Twitch"),
                array("fab fa-twitter" =>  "Twitter"),
                array("fab fa-twitter-square" => "Twitter Square"),
                array("fab fa-typo3" =>  "Typo3"),
                array("fab fa-uber" =>  "Uber"),
                array("fab fa-ubuntu" =>  "Ubuntu"),
                array("fab fa-uikit" =>  "Uikit"),
                array("fab fa-umbraco" =>  "Umbraco"),
                array("fab fa-uniregistry" => "Uniregistry"),
                array("fab fa-unity" =>  "Unity"),
                array("fab fa-untappd" =>  "Untappd"),
                array("fab fa-ups" =>  "Ups"),
                array("fab fa-usb" =>  "Usb"),
                array("fab fa-usps" =>  "Usps"),
                array("fab fa-ussunnah" =>  "Ussunnah"),
                array("fab fa-vaadin" =>  "Vaadin"),
                array("fab fa-viacoin" =>  "Viacoin"),
                array("fab fa-viadeo" =>  "Viadeo"),
                array("fab fa-viadeo-square" => "Viadeo Square"),
                array("fab fa-viber" =>  "Viber"),
                array("fab fa-vimeo" =>  "Vimeo"),
                array("fab fa-vimeo-square" => "Vimeo Square"),
                array("fab fa-vimeo-v" =>  "Vimeo V"),
                array("fab fa-vine" =>  "Vine"),
                array("fab fa-vk" =>  "Vk"),
                array("fab fa-vnv" =>  "Vnv"),
                array("fab fa-vuejs" =>  "Vuejs"),
                array("fab fa-waze" =>  "Waze"),
                array("fab fa-weebly" =>  "Weebly"),
                array("fab fa-weibo" =>  "Weibo"),
                array("fab fa-weixin" =>  "Weixin"),
                array("fab fa-whatsapp" =>  "Whatsapp"),
                array("fab fa-whatsapp-square" => "Whatsapp Square"),
                array("fab fa-whmcs" =>  "Whmcs"),
                array("fab fa-wikipedia-w" => "Wikipedia W"),
                array("fab fa-windows" =>  "Windows"),
                array("fab fa-wix" =>  "Wix"),
                array("fab fa-wizards-of-the-coast" => "Wizards Of The Coast"),
                array("fab fa-wolf-pack-battalion" => "Wolf Pack Battalion"),
                array("fab fa-wordpress" =>  "Wordpress"),
                array("fab fa-wordpress-simple" => "Wordpress Simple"),
                array("fab fa-wpbeginner" => "Wpbeginner"),
                array("fab fa-wpexplorer" => "Wpexplorer"),
                array("fab fa-wpforms" =>  "Wpforms"),
                array("fab fa-wpressr" =>  "Wpressr"),
                array("fab fa-xbox" =>  "Xbox"),
                array("fab fa-xing" =>  "Xing"),
                array("fab fa-xing-square" => "Xing Square"),
                array("fab fa-y-combinator" => "Y Combinator"),
                array("fab fa-yahoo" =>  "Yahoo"),
                array("fab fa-yammer" =>  "Yammer"),
                array("fab fa-yandex" =>  "Yandex"),
                array("fab fa-yandex-international" => "Yandex International"),
                array("fab fa-yarn" =>  "Yarn"),
                array("fab fa-yelp" =>  "Yelp"),
                array("fab fa-yoast" =>  "Yoast"),
                array("fab fa-youtube" =>  "Youtube"),
                array("fab fa-youtube-square" => "Youtube Square"),
                array("fab fa-zhihu" =>  "Zhihu"),
            ),
        );

        return $icons;
    }

}