<?php
/**
 * Template Name: Home
 */
get_header();
?>
 <section class="hero is-primary is-fullheight" id="cover">
 <div class="hero-body">
<section class="home-intro-wrapp"> 
      <!---------------- start mist animation ------>
<div class="fog-animation">
<div id="foglayer_01" class="fog">
<div class="image01"></div>
<div class="image02"></div>
</div>
<div id="foglayer_02" class="fog">
<div class="image01"></div>
<div class="image02"></div>
</div>
<div id="foglayer_03" class="fog">
<div class="image01"></div>
<div class="image02"></div>
</div>
</div>
      <!---------------- end mist animation ---------------->	
<div class="intro-top">

</div>
<div class="intro-cap">
<h3><span>C</span><span>R</span><span>O</span><span>S</span><span>S</span><span>O</span><span>V</span><span>E</span><span>R</span> <span>T</span><span>O</span> <span>C</span><span>A</span><span>L</span><span>M</span><span>N</span><span>E</span><span>S</span><span>S</span></h3>
<h4 class="fade-in fade-in-01" style="display: none;"><span>I</span><span>N</span ><span>M</span><span>U</span><span>N</span><span>N</span><span>A</span><span>R</span><span>.</span><span>.</span><span>.</span></h4>

<a href="#">EXPLORE</a>
</div>
		
<div class="clear"></div>



				
</section>
 </div>
</section>


<section class="welcome " id="post1">

<div class="container">
<div class="row py-5 align-items-center">
	

<div class="col-md-6 welcome_img" >
	<div class="overview-ing-hme d-none d-md-block">
<figure>
<img class="ind-over-desk" src="<?php echo get_field("section_1_image") ?>" alt=" The Leaves" width="545" height="619">
</figure>
<figure class="over-img-btn"><img src="<?php echo get_field("section_1_image_2") ?>" alt=" The Leaves" width="397" height="239"></figure>
	</div>
	<div class=" d-block d-md-none welcome_img">
<figure>
<img class="" src="<?php echo get_stylesheet_directory_uri(); ?>/images/overview-image-1.jpg" alt=" The Leaves" >
</figure>

	</div>
</div>

<div class="col-md-6 welcome_txt " >
<h2 class="top-and-bottom " ><?php echo get_field("section_1_title") ?></h2>
	<h3><?php echo get_field("section_1_sub_title") ?></h3>

<?php echo get_field("section_1_content") ?>
<br>
<a href="<?php echo get_field("section_1_button_link") ?>" class="btn-orange"><?php echo get_field("section_1_button_text") ?></a>
</div>	
		
</div>	
</div>	
</section>

<section class="amenities-section">
  <!-- Left Image -->
  <div class="amenities-image">

      <div class="amenities-content">
    <h2><?php echo get_field("section_2_title") ?></h2>
    <?php echo get_field("section_2_content") ?>
    <div class="amenities-list">
      <div><i class="fas fa-swimming-pool"></i><?php echo get_field("section_2_icon_text_1") ?></div>
      <div><i class="fas fa-dumbbell"></i><?php echo get_field("section_2_icon_text_2") ?></div>
      <div><i class="fas fa-spa"></i><?php echo get_field("section_2_icon_text_3") ?></div>
      <div><i class="fas fa-ship"></i><?php echo get_field("section_2_icon_text_4") ?></div>
      <div><i class="fas fa-bicycle"></i><?php echo get_field("section_2_icon_text_5") ?></div>
      <div><i class="fas fa-briefcase"></i><?php echo get_field("section_2_icon_text_6") ?></div>
      <div><i class="fas fa-hiking"></i><?php echo get_field("section_2_icon_text_7") ?></div>
      <div style="display: none;"><i class="fas fa-utensils"></i><?php echo get_field("section_2_icon_text_8") ?></div>
    </div>
  </div>


  </div>

  <!-- Right Content -->

</section>


<?php
/**
 * Rooms & Suites Section (Bootstrap carousel version)
 */

// Get taxonomy terms for tabs
$room_types = get_terms([
    'taxonomy'   => 'room_category',
    'hide_empty' => true,
]);
?>

<section class="pt-4 pb-4 resort">
  <div class="">
    <div class="suites">
      <h2>Rooms & Suites</h2>

      <!-- Tabs -->
      <?php if ($room_types && !is_wp_error($room_types)) : ?>
        <ul class="nav nav-tabs d-none d-lg-flex nav-justified" id="myTab" role="tablist">
          <?php $i = 0; foreach ($room_types as $type) : ?>
            <li class="nav-item" role="presentation">
              <button class="nav-link <?php echo ($i == 0) ? 'active' : ''; ?>"
                id="tab-<?php echo esc_attr($type->slug); ?>"
                data-bs-toggle="tab"
                data-bs-target="#pane-<?php echo esc_attr($type->slug); ?>"
                type="button" role="tab"
                aria-controls="pane-<?php echo esc_attr($type->slug); ?>"
                aria-selected="<?php echo ($i == 0) ? 'true' : 'false'; ?>">
                <?php echo esc_html($type->name); ?>
              </button>
            </li>
          <?php $i++; endforeach; ?>
        </ul>
      <?php endif; ?>

      <!-- Tab Content -->
      <div class="tab-content accordion" id="myTabContent">
        <?php $j = 0; foreach ($room_types as $type) : ?>
          <div class="tab-pane fade accordion-item <?php echo ($j == 0) ? 'show active' : ''; ?>"
               id="pane-<?php echo esc_attr($type->slug); ?>"
               role="tabpanel"
               aria-labelledby="tab-<?php echo esc_attr($type->slug); ?>"
               tabindex="0">

            <!-- Mobile Accordion Header -->
            <h4 class="accordion-header d-lg-none" id="heading-<?php echo esc_attr($type->slug); ?>">
              <button class="accordion-button <?php echo ($j == 0) ? '' : 'collapsed'; ?>"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#collapse-<?php echo esc_attr($type->slug); ?>"
                aria-expanded="<?php echo ($j == 0) ? 'true' : 'false'; ?>"
                aria-controls="collapse-<?php echo esc_attr($type->slug); ?>">
                <?php echo esc_html($type->name); ?>
              </button>
            </h4>

            <!-- Mobile Accordion Content -->
            <div id="collapse-<?php echo esc_attr($type->slug); ?>"
                 class="accordion-collapse collapse <?php echo ($j == 0) ? 'show' : ''; ?> d-lg-block"
                 aria-labelledby="heading-<?php echo esc_attr($type->slug); ?>"
                 data-bs-parent="#myTabContent">
              <div class="accordion-body room-section">

                <?php
                // Fetch Rooms under this taxonomy
                $args = [
                  'post_type'      => 'rooms_and_suites',
                  'posts_per_page' => -1,
                  'tax_query'      => [[
                    'taxonomy' => 'room_category',
                    'field'    => 'slug',
                    'terms'    => $type->slug,
                  ]]
                ];
                $rooms = new WP_Query($args);
                ?>

                <?php if ($rooms->have_posts()) : ?>
                  <?php while ($rooms->have_posts()) : $rooms->the_post(); ?>

                    <div class="row mb-4">
                      <div class="col-md-4 p-0">
                        <div class="room-content">
                          <h2><?php the_title(); ?></h2>
                          <p><?php echo get_the_content(); ?></p>
                          <p><?php echo get_field('extra_description'); ?></p>
                          <a href="<?php echo esc_url(get_field('page_link')); ?>" class="btn-custom mt-3">More Details</a>
                        </div>
                      </div>

                      <?php
                      // Build images array: ACF slide_image_1..6 (assumes URL), fallback to thumbnail or placeholder
                      $images = [];
                      for ($k = 1; $k <= 6; $k++) {
                          $img = get_field("slide_image_$k");
                          if (!empty($img)) {
                              $images[] = $img;
                          }
                      }
                      if (empty($images)) {
                          if (has_post_thumbnail()) {
                              $images[] = get_the_post_thumbnail_url(get_the_ID(), 'full');
                          } else {
                              $images[] = get_stylesheet_directory_uri() . '/images/placeholder.jpg';
                          }
                      }

                      // unique carousel id per post
                      $carousel_id = 'roomCarousel-' . get_the_ID();
                      ?>

                      <div class="col-md-8 p-0">
                        <div id="<?php echo esc_attr($carousel_id); ?>" class="carousel slide room-carousel" data-bs-ride="carousel" data-bs-interval="3000">
                          <!-- Indicators -->
                          

                          <!-- Slides -->
                          <div class="carousel-inner">
                            <?php foreach ($images as $idx => $src) : ?>
                              <div class="carousel-item <?php echo ($idx === 0) ? 'active' : ''; ?>">
                                <img src="<?php echo esc_url($src); ?>" class="d-block w-100" alt="<?php the_title_attribute(); ?>">
                              </div>
                            <?php endforeach; ?>
                          </div>

                          <!-- Controls -->
                           <button class="carousel-control-prev" type="button" data-bs-target="#<?php echo esc_attr($carousel_id); ?>" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                          </button>
                          <button class="carousel-control-next" type="button" data-bs-target="#<?php echo esc_attr($carousel_id); ?>" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                          </button>
                       
                        </div>
                      </div> <!-- /.col-md-8 -->

                    </div> <!-- /.row -->

                  <?php endwhile; wp_reset_postdata(); ?>
                <?php else : ?>
                  <p>No rooms found under <?php echo esc_html($type->name); ?>.</p>
                <?php endif; ?>

              </div> <!-- /.accordion-body -->
            </div> <!-- /.accordion-collapse -->
          </div> <!-- /.tab-pane -->
        <?php $j++; endforeach; ?>
      </div> <!-- /.tab-content -->
    </div> <!-- /.suites -->
  </div> <!-- /.container-like -->
</section>

<script>
document.addEventListener('DOMContentLoaded', function () {
  // When a Bootstrap tab is shown, restart any carousel inside
  document.addEventListener('shown.bs.tab', function (e) {
    const targetSelector = e.target.getAttribute('data-bs-target') || e.target.getAttribute('href');
    if (!targetSelector) return;
    const pane = document.querySelector(targetSelector);
    if (!pane) return;
    pane.querySelectorAll('.carousel').forEach(function (el) {
      // get instance or create then call cycle
      let inst = bootstrap.Carousel.getInstance(el);
      if (!inst) inst = new bootstrap.Carousel(el);
      inst.cycle();
    });
  });

  // When a Bootstrap collapse (accordion) is shown, restart carousels inside
  document.addEventListener('shown.bs.collapse', function (e) {
    const pane = e.target; // collapse that opened
    if (!pane) return;
    pane.querySelectorAll('.carousel').forEach(function (el) {
      let inst = bootstrap.Carousel.getInstance(el);
      if (!inst) inst = new bootstrap.Carousel(el);
      inst.cycle();
    });
  });
});
</script>




<section class="packages">
  <h2>Our Packages</h2>
  <div class="container">
    <div class="row">
      <div class="col-md-12">
        <div id="news-slider-course" class="owl-carousel">

          <?php
          // WP Query for custom post type "our_packages"
          $args = array(
            'post_type'      => 'our_packages',
            'posts_per_page' => -1, // show all packages
            'post_status'    => 'publish',
          );
          $packages = new WP_Query($args);

          if ($packages->have_posts()) :
            while ($packages->have_posts()) : $packages->the_post();
              $thumb_url = get_the_post_thumbnail_url(get_the_ID(), 'large');
          ?>
              <div class="post-slide">
                <div class="post-img">
                  <?php if ($thumb_url) : ?>
                    <img src="<?php echo esc_url($thumb_url); ?>" alt="<?php the_title(); ?>">
                  <?php else : ?>
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/placeholder.jpg" alt="<?php the_title(); ?>">
                  <?php endif; ?>

                  <a href="<?php the_permalink(); ?>" class="over-layer"><i class="fa fa-link"></i></a>
                </div>

                <div class="post-content">
                  <h3 class="post-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                  </h3>
                  <p class="post-description">
                    <?php echo wp_trim_words(get_the_content(), 25); ?>
                  </p>
                  <a href="<?php the_permalink(); ?>" class="read-more">View Details</a>
                </div>
              </div>
          <?php
            endwhile;
            wp_reset_postdata();
          else :
            echo '<p>No packages available right now.</p>';
          endif;
          ?>

        </div>
      </div>
    </div>
  </div>

  <script>
    jQuery(document).ready(function ($) {
      $("#news-slider-course").owlCarousel({
        items: 3,
        itemsDesktop: [1199, 3],
        itemsDesktopSmall: [980, 2],
        itemsMobile: [600, 1],
        navigation: false,
        pagination: true,
        autoPlay: true,
        dots: true
      });
    });
  </script>
</section>

<section class="art01">

</section>



<section class="testi-section">
  <!-- Left Image -->
  <div class="testi-image">

      <div class="testi-content">
   

<section class="testimonial-section">
  <div class="container">
    <h6 class="top-and-bottom"><?php echo get_field("testimonials_tile"); ?></h6>
    <h2><?php echo get_field("testimonials_subtile"); ?></h2>

    <?php
    // Fetch Testimonials
    $args = array(
      'post_type'      => 'testimonials',
      'posts_per_page' => -1,
      'post_status'    => 'publish'
    );
    $testimonials = new WP_Query($args);
    ?>

    <?php if ($testimonials->have_posts()) : ?>
      <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-inner">

          <?php $i = 0; while ($testimonials->have_posts()) : $testimonials->the_post(); ?>
            <div class="carousel-item <?php echo ($i==0) ? 'active' : ''; ?>">
              <p class="testimonial-text">
                <?php echo get_the_content(); ?>
              </p>
              <div class="testimonial-author">
                <?php if (has_post_thumbnail()) : ?>
                  <?php the_post_thumbnail('thumbnail', ['alt' => get_the_title()]); ?>
                <?php else : ?>
                  <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/placeholder.jpg" alt="<?php the_title(); ?>">
                <?php endif; ?>

                <div>
                  <strong><?php the_title(); ?></strong><br>
                  <span class="author-info">
                    <?php echo get_field('place'); ?>
                  </span>
                </div>
              </div>
            </div>
          <?php $i++; endwhile; wp_reset_postdata(); ?>

        </div>

        <!-- Carousel Indicators -->
        <div class="carousel-indicators mt-4">
          <?php for ($j=0; $j<$i; $j++) : ?>
            <button type="button" data-bs-target="#testimonialCarousel" data-bs-slide-to="<?php echo $j; ?>" class="<?php echo ($j==0) ? 'active' : ''; ?>"></button>
          <?php endfor; ?>
        </div>
      </div>
    <?php else : ?>
      <p>No testimonials available right now.</p>
    <?php endif; ?>
  </div>
</section>




  </div>


  </div>

  <!-- Right Content -->

</section>
<section class="facilities">


<div class="container">
<div class="row">
  <div class="col-md-4 facilityimg">
    <img src="<?php echo get_field("section_3_image") ?>" alt="Facilities">
  </div>
<div class="col-md-8 facility ">

   <div class="facilitiestxt facilityimg">
    <h2><?php echo get_field("section_3_title") ?></h2>
    <p><?php echo get_field("section_3_content") ?></p>


    <div class="accordion">

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_1") ?></div>
      <div class="accordion-content">
       <?php echo get_field("section_3_dropdown_content_1") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_2") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_2") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_3") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_3") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_4") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_4") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_5") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_5") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_6") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_6") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_7") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_7") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_8") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_8") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_9") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_9") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_10") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_10") ?>
      </div>
    </div>

    <div class="accordion-item">
      <div class="accordion-header"><?php echo get_field("section_3_dropdown_title_11") ?></div>
      <div class="accordion-content">
        <?php echo get_field("section_3_dropdown_content_11") ?>
      </div>
    </div>






  </div>



  </div>
</div>



</div>

</div>
</section>


<section class="reviewbg">
<div class=" reviews-section">
<a href="#">
        <div class="review-card" style="background: url( <?php echo get_field("social_image_1") ?>) center/cover no-repeat;">
      <div class="review-content">
        <h3>Reviews on</h3>
        <img src=" <?php echo get_field("social_logo_1") ?>" alt="Tripadvisor">
      </div>
    </div>
</a>
<a href="#">
    <div class="review-card" style="background:url( <?php echo get_field("social_image_2") ?>) center/cover no-repeat;">
      <div class="review-content">
        <h3>Reviews on</h3>
        <img src=" <?php echo get_field("social_logo_2") ?>" alt="Facebook">
      </div>
    </div>
    </a>
  <a href="#">
    <div class="review-card" style="background: url( <?php echo get_field("social_image_3") ?>) center/cover no-repeat;">
      <div class="review-content">
        <h3>Reviews on</h3>
        <img src=" <?php echo get_field("social_logo_3") ?>" alt="Instagram">
      </div>
    </div>
    </a>
  <a href="#">
    <div class="review-card" style="background: url( <?php echo get_field("social_image_4") ?>) center/cover no-repeat;">
 <div class="review-content">
        <h3>Reviews on</h3>
        <img src=" <?php echo get_field("social_logo_4") ?>" alt="YouTube">
      </div>
    </div>
        </a>
</div>
  </section>
<?php
get_footer();
?>
 