<?php
// Disable parent theme styles
function twentytwentyone_child_remove_parent_styles() {
    wp_dequeue_style('twenty-twenty-one-style');   // Correct handle
    wp_deregister_style('twenty-twenty-one-style');
}
add_action('wp_enqueue_scripts', 'twentytwentyone_child_remove_parent_styles', 20);

// Load only child theme styles
function twentytwentyone_child_enqueue_styles() {
    wp_enqueue_style(
        'twenty-twenty-one-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array(), // No dependency on parent
        wp_get_theme()->get('Version')
    );
}
add_action('wp_enqueue_scripts', 'twentytwentyone_child_enqueue_styles');
