<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.1.6
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$meta = _WSH()->get_meta('_bunch_layout_settings');
$meta1 = _WSH()->get_meta('_bunch_header_settings');
$layout = duplex_set( $meta, 'layout', 'right' );
$sidebar = duplex_set( $meta, 'sidebar', 'blog-sidebar' );
$classes = ( !$layout || $layout == 'full' || duplex_set($_GET, 'layout_style')=='full' ) ? ' col-lg-12 col-md-12 col-sm-12 col-xs-12 ' : ' col-lg-9 col-md-9 col-sm-7 col-xs-12 ' ;
$bg = duplex_set($meta1, 'header_img');
$title = duplex_set($meta1, 'header_title');
get_header( 'shop' ); ?>
<!-- ======= Banner ======= -->
<!-- page title area -->
<div class="page_titel" <?php if($bg):?>style="background-image: url('<?php echo esc_url($bg)?>');"<?php endif;?>>
    <div class="container">
        <div class="row">
            <div class="page_heading text-center">
                 <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                 	<h2><?php if($title) echo wp_kses_post($title); else wp_title('');?></h2>
                 <?php endif;?>
                 <span></span>
                 <?php echo wp_kses_post(duplex_get_the_breadcrumb()); ?>
            </div>
        </div>
    </div>
</div>
<!-- ================= /Banner ================ -->
<div id="shop_area">
		<div class="container">
			<div class="row">
			
			<!-- sidebar area -->
			<?php if( $layout == 'left' ): ?>
			<?php if ( is_active_sidebar( $sidebar ) ) { ?>
			<aside class="col-lg-3 col-md-3 col-sm-12 col-xs-12">        
				<div class="sidebar">
					<?php dynamic_sidebar( $sidebar ); ?>
                    <?php
							/**
							 * woocommerce_sidebar hook
							 *
							 * @hooked woocommerce_get_sidebar - 10
							 */
							do_action( 'woocommerce_sidebar' );
						?>
				</div>
			</aside>
			<?php } ?>
			<?php endif; ?>
			
	<div class="<?php echo esc_attr($classes);?> product-details-page-content">
	<?php
		/**
		 * woocommerce_before_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>
		<?php while ( have_posts() ) : the_post(); ?>
			<?php wc_get_template_part( 'content', 'single-product' ); ?>
		<?php endwhile; // end of the loop. ?>
	<?php
		/**
		 * woocommerce_after_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>
	
	</div>
		
        <!-- sidebar area -->
		<?php if( $layout == 'right' ): ?>
        <?php if ( is_active_sidebar( $sidebar ) ) { ?>
        <aside class="col-lg-3 col-md-3 col-sm-12 col-xs-12">        
            <div class="sidebar">
                <?php dynamic_sidebar( $sidebar ); ?>
                <?php
						/**
						 * woocommerce_sidebar hook
						 *
						 * @hooked woocommerce_get_sidebar - 10
						 */
						do_action( 'woocommerce_sidebar' );
					?>
            </div>
        </aside>
        <?php } ?>
        <?php endif; ?>
        
	</div>
	</div>
</div>
<?php get_footer( 'shop' ); ?>
