<?php $options = _WSH()->option();  
ob_start();
?>
 
 <div id="contact_area">
    <div class="container">
        
        <div class="contact text-center">
            <h2><?php echo wp_kses_post($title);?></h2>
            <span></span>
            <p><?php echo wp_kses_post($text);?></p>
        </div>
        <div class="row clearfix">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="google-map"></div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="contact_info">
                    <div class="info-block wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="fa fa-map-marker"></i></div>
                        <h2><?php esc_html_e('Address', 'duplex');?></h2>
                        <p><?php echo wp_kses_post($address);?></p>
                    </div>
                    <div class="info-block wow fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="fa fa-phone"></i></div>
                        <h2><?php esc_html_e('Phone', 'duplex');?></h2>
                        <p><?php echo wp_kses_post($phone);?> <br> <?php echo wp_kses_post($phone2);?></p>
                    </div>
                    <div class="info-block wow fadeInLeft" data-wow-delay="400ms" data-wow-duration="1500ms">
                        <div class="icon-box"><i class="fa fa-envelope-o"></i></div>
                        <h2><?php esc_html_e('Email', 'duplex');?></h2>
                        <p><?php echo wp_kses_post($email);?> <br> <?php echo wp_kses_post($email2);?> </p>
                    </div>
                </div>
                
                <div class="contact_social">
                    <?php if($socials = duplex_set(duplex_set($options, 'social_media'), 'social_media')): //duplex_printr($socials);?>
                    <ul class="ul">
                        <?php foreach($socials as $key => $value):
							if(duplex_set($value, 'tocopy')) continue;
							?>
							<li><a href="<?php echo esc_url(duplex_set($value, 'social_link'));?>"><i class="fa <?php echo esc_attr(duplex_set($value, 'social_icon'));?>"></i></a></li>
						<?php endforeach;?>
                    </ul>
                    <?php endif;?>
                </div>
                
            </div>
        </div>
    </div>
</div>
 
<script type="text/javascript">
jQuery(document).on('ready', function () {
// Google Map
	function gMap () {
		if (jQuery('.google-map').length) {
            var map;
            map = new GMaps({
                div: '.google-map',
                scrollwheel: false,
                lat: <?php echo esc_js($lat);?>,
                lng: <?php echo esc_js($long);?>
            });
            map.addMarker({
                lat: <?php echo esc_js($mark_lat);?>,
                lng: <?php echo esc_js($mark_long);?>,
                title: '<?php echo esc_js($map_title);?>'
            });  
		};
	}
// instance of fuction while Document ready event	
(function ($) {
		gMap();
	})(jQuery);
});

</script>

<?php return ob_get_clean();?>		