<?php
//***************Blog Widgets******************
/// Recent Posts 
class Bunch_Recent_Post_With_Image extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Recent_Post_With_Image', /* Name */esc_html__('Duplex Recent Posts with image','duplex'), array( 'description' => esc_html__('Show the recent posts with images', 'duplex' )) );
	}
 
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
		<div class="single_sidebar">
    
            <div class="populer">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            </div>
            <br />
            
            <?php $query_string = 'posts_per_page='.$instance['number'];
					if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
					query_posts( $query_string ); 
					
					$this->posts();
					wp_reset_query();
			?>
            
        </div>
         
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Populer Post', 'duplex');
		$number = ( $instance ) ? esc_attr($instance['number']) : 5;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'duplex'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'duplex'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
				<?php while( have_posts() ): the_post(); ?>
                    
                    <div class="blog_details">
                        <div class="blogimg">
                            <?php the_post_thumbnail('duplex_55x50');?>
                        </div>  
                        <div class="sidber_text">
                            <h3><?php echo wp_kses_post(duplex_trim(get_the_title(), 9));?></h3>
                            <p><?php echo get_the_date('F d, Y');?></p>
                        </div>
                    </div>
                    
                <?php endwhile; ?>
                
        <?php endif;
    }
}

///----footer widgets---

//Duplex Text
class Bunch_About_Text extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_About_Text', /* Name */esc_html__('Duplex About Text','duplex'), array( 'description' => esc_html__('Show the information about Duplex company', 'duplex' )) );
	}
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
            
			<div class="single_footer">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            	<?php echo wp_kses_post($instance['content']); ?>
            </div>
            <?php if( $instance['show'] ): ?>
            <div class="footer_social">
                <?php echo wp_kses_post(duplex_get_social_icons()); ?>
            </div>
            <?php endif; ?>
			
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] =$new_instance['title'];
		$instance['content'] = $new_instance['content'];
		$instance['show'] = $new_instance['show'];
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : 'Duplex';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$show = ( $instance ) ? esc_attr($instance['show']) : '';?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('Title')); ?>"><?php esc_html_e('Title', 'duplex'); ?></label>
            <input placeholder="<?php esc_html_e('Title here', 'duplex');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'duplex'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show')); ?>"><?php esc_html_e('Show Social Icons:', 'duplex'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('show')); ?>"<?php echo esc_attr($selected); ?> name="<?php echo esc_attr($this->get_field_name('show')); ?>" type="checkbox" value="true" />
        </p>
        
		<?php 
	}
	
}

/// Latest Comments 
class Bunch_Latest_Comments_With_Image extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Latest_Comments_With_Image', /* Name */esc_html__('Duplex Latest Comments with image','duplex'), array( 'description' => esc_html__('Show the Latest Comments with images', 'duplex' )) );
	}
 
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
		<div class="column_title">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <span></span>
        </div>
        
        <?php $query_string = 'posts_per_page='.$instance['number'];
				if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
				query_posts( $query_string ); 
				
				$this->posts();
				wp_reset_query();
		?>
        
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('latest news', 'duplex');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'duplex'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'duplex'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
				<?php while( have_posts() ): the_post(); ?>
                    
                    <div class="column-two">
            
                        <div class="column_img">
                            <?php the_post_thumbnail('duplex_55x50');?>
                        </div>
                        <div class="column_text">
                            <a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><p><?php echo wp_kses_post(duplex_trim(get_the_title(), 10));?></p></a>
                            <h3><?php echo get_the_date('F d, Y');?></h3>
                        </div>
                    </div>
                    
                <?php endwhile; ?>
                
        <?php endif;
    }
}

/// Contact info 
class Bunch_Contact_Info extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Conatct_Info', /* Name */esc_html__('Duplex Contact Info','duplex'), array( 'description' => esc_html__('Show the Contact Information', 'duplex' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
		<div class="column-three">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <span></span>
            <?php if($instance['address']):?><a href="" class="i fa fa-map-marker"></a> <?php echo wp_kses_post($instance['address']);?><br /><?php endif;?>
            <?php if($instance['phone']):?><a href="" class="i fa fa-phone"></a> <?php echo wp_kses_post($instance['phone']);?> <br /><?php endif;?>
            <?php if($instance['email']):?><a href="" class="i fa fa-envelope-o"></a> <?php echo esc_attr($instance['email']);?> <br /><?php endif;?>
        </div>
        <div class="subcriber">
            <h2><?php esc_html_e('subcriber', 'duplex');?></h2>
            <span></span>
            <div class="footer-subscriber">
                <form action="<?php echo esc_url(home_url('/')); ?>" method="get" class="search-form">
                    <input type="text" name="s" placeholder="<?php esc_html_e('Enter you email here', 'duplex');?>">
                    <button type="submit"><i class="fa fa-location-arrow"></i></button>
                </form>
            </div>
        </div>
		
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address'] = $new_instance['address'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email'] = $new_instance['email'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Address', 'duplex');
		$address = ( $instance ) ? esc_attr($instance['address']) : '';
		$phone = ( $instance ) ? esc_attr($instance['phone']) : '';
		$email = ( $instance ) ? esc_attr($instance['email']) : '';
		
		
		?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" type="text" value="<?php echo esc_attr( $address ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" value="<?php echo esc_attr( $phone ); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />
        </p>
            
		<?php 
	}
	
}

/// footer Gallery Posts 
class Bunch_Footer_Gallery_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Footer_Gallery_Post', /* Name */esc_html__('Duplex Footer Gallery Post','duplex'), array( 'description' => esc_html__('Show the gallery Posts', 'duplex' )) );
	}
 
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        <div class="small_gallery">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <span></span>
            
            <?php $query_string = 'posts_per_page='.$instance['number'];
				if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
				query_posts( $query_string ); 
				
				$this->posts();
				wp_reset_query();
			?>
            
        </div>
		
		 
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Footer Widget', 'duplex');
		$number = ( $instance ) ? esc_attr($instance['number']) : 1;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
		    <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'duplex'); ?></label>
		    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'duplex'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'duplex'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'duplex'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        	<?php while( have_posts() ): the_post(); ?>
                
				<?php the_post_thumbnail('duplex_76x70', array('class' => 'img-responsive'));?>
                
            <?php endwhile; ?>
        <?php endif;
    }
}