<?php $options = _WSH()->option();

	bunch_global_variable();

	$icon_href = (duplex_set( $options, 'site_favicon' )) ? duplex_set( $options, 'site_favicon' ) : get_template_directory_uri().'/images/favicon.png';

 ?>

<!DOCTYPE html>

<html <?php language_attributes(); ?>>

	<head>

		 <!-- Basic -->

	    <meta charset="<?php bloginfo( 'charset' ); ?>">

        <meta name="generator" content="motive">

	    <meta http-equiv="X-UA-Compatible" content="IE=edge">

		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

		<!-- Favcon -->

		<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ):?>

			<link rel="shortcut icon" type="image/png" href="<?php echo esc_url($icon_href);?>">

		<?php endif;?>

		<?php wp_head(); ?>

	</head>

	<body <?php body_class(); ?>>

	<div class="main-wrapper">

	<?php if(duplex_set($options, 'preloader')):?>

    <div class="preloaderbox"></div>

	<?php endif;?>

    

    <!-- Main Header-->

    <header class="main-header">

    	<!-- Header Top -->

        <?php if( duplex_set($options, 'phone') || duplex_set($options, 'email') || duplex_set($options, 'quote_link') ):?>

    	<div class="header-top">

        	<div class="auto-container">

            	<div class="row clearfix">

                    

                    <!--Top Left-->

                    <div class="top-left col-md-9 col-sm-9 col-xs-12">

                    	<ul>

                        	<?php if( duplex_set($options, 'phone') ):?>

                            <li><a href="<?php echo esc_url(duplex_set($options, 'phone'));?>"><span class="icon fa fa-phone"></span> <?php echo wp_kses_post(duplex_set($options, 'phone'));?></a></li>

                        	<?php endif;?>

                            <?php if( duplex_set($options, 'email') ):?>

                            <li><a href="mailto:<?php echo sanitize_email(duplex_set($options, 'email'));?>"><span class="icon fa fa-envelope-o"></span> <?php echo wp_kses_post(duplex_set($options, 'email'));?></a></li>

                        	<?php endif;?>

                        </ul>

                    </div>

                    

                    <!--Top Right-->

                    <?php if( duplex_set($options, 'quote_link') ):?>

                    <div class="top-right col-md-3 col-sm-3 col-xs-12">

                    	<div class="link-box"><a href="<?php echo esc_url(duplex_set($options, 'quote_link'));?>" class="theme-btn"><?php esc_html_e('get a quote', 'duplex');?></a></div>

                    </div>

                    <?php endif;?>

                </div>

                

            </div>

        </div><!-- Header Top End -->

        <?php endif;?>

        <!--Header Lower-->

        <div class="header-lower">

        	<div class="auto-container">

            	<!-- Main Box -->

            	<div class="main-box">

                

                    <div class="outer-container clearfix">

                        <!--Logo Box-->

                        <div class="logo-box">

                            <?php if(duplex_set($options, 'logo_image')):?>

                                <div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(duplex_set($options, 'logo_image'));?>" alt="<?php esc_html_e('image', 'duplex');?>"></a></div>

                            <?php else:?>

                                <div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(get_template_directory_uri().'/img/logo.png');?>" alt="<?php esc_html_e('image', 'duplex');?>"></a></div>

                            <?php endif;?>

                        </div>

                        

                        <!--Nav Outer-->

                        <div class="nav-outer clearfix">

                            <!-- Main Menu -->

                            <nav class="main-menu">

                                <div class="navbar-header">

                                    <!-- Toggle Button -->    	

                                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">

                                    <span class="icon-bar"></span>

                                    <span class="icon-bar"></span>

                                    <span class="icon-bar"></span>

                                    </button>

                                </div>

                                

                                <div class="navbar-collapse collapse clearfix">

                                    <ul class="navigation clearfix">

                                        <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',

												'container_class'=>'navbar-collapse collapse navbar-right',

												'menu_class'=>'nav navbar-nav',

												'fallback_cb'=>false, 

												'items_wrap' => '%3$s', 

												'container'=>false,

												'walker'=> new Bunch_Bootstrap_walker()  

										) ); ?>

                                    </ul>

                                </div>

                            </nav><!-- Main Menu End-->

                            

                        </div><!--Nav Outer End-->

                        

                        <!-- Hidden Nav Toggler -->

                        <div class="nav-toggler">

                        <button class="hidden-bar-opener"><span class="icon fa fa-bars"></span></button>

                        

                    </div>    

                </div><!-- End Main Box -->

                

            </div>

        </div><!--End Header Lower-->

    

    </header>

    <!--End Main Header -->

    

    <?php if(duplex_set($options, 'sidebar_menu')):?>

    <!-- Hidden Navigation Bar -->

    <section class="hidden-bar right-align">

        

        <div class="hidden-bar-closer">

            <button class="btn"><i class="fa fa-close"></i></button>

        </div>

        

        <!-- Hidden Bar Wrapper -->

        <div class="hidden-bar-wrapper">

        

            <!-- .logo -->

            <div class="logo text-center">

                

                <?php if(duplex_set($options, 'side_logo_image')):?>

                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(duplex_set($options, 'side_logo_image'));?>" alt="<?php esc_html_e('image', 'duplex');?>"></a>

                <?php else:?>

                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(get_template_directory_uri().'/img/logo-2.png');?>" alt="<?php esc_html_e('image', 'duplex');?>"></a>

                <?php endif;?>

                

            </div><!-- /.logo -->

            

            <!-- .Side-menu -->

            <div class="side-menu">

            <!-- .navigation -->

                <ul class="navigation clearfix">

                    <?php wp_nav_menu( array( 'theme_location' => 'sidebar_menu', 'container_id' => 'navbar-collapse-1',

						'container_class'=>'navbar-collapse collapse navbar-right',

						'menu_class'=>'nav navbar-nav',

						'fallback_cb'=>false, 

						'items_wrap' => '%3$s', 

						'container'=>false,

						'walker'=> new Bunch_Bootstrap_walker()  

					) ); ?>

                </ul>

            </div><!-- /.Side-menu -->

        	<?php if(duplex_set($options, 'show_shocial_icons')):?>

            <div class="social-icons">

                <?php if($socials = duplex_set(duplex_set($options, 'social_media'), 'social_media')): //duplex_printr($socials);?>

                <ul>

                    <?php foreach($socials as $key => $value):

						if(duplex_set($value, 'tocopy')) continue;

					?>

                    <li><a href="<?php echo esc_url(duplex_set($value, 'social_link'));?>"><i class="fa <?php echo esc_attr(duplex_set($value, 'social_icon'));?>"></i></a></li>

                    <?php endforeach;?>

                </ul>

                <?php endif;?>

            </div>

        	<?php endif;?>

            

        </div><!-- / Hidden Bar Wrapper -->

    </section><!-- / Hidden Bar -->

    <?php endif;?>


