<?php

add_action('after_setup_theme', 'duplex_bunch_theme_setup');

function duplex_bunch_theme_setup()

{

	global $wp_version;

	if(!defined('DUPLEX_VERSION')) define('DUPLEX_VERSION', '1.0');

	if( !defined( 'DUPLEX_ROOT' ) ) define('DUPLEX_ROOT', get_template_directory().'/');

	if( !defined( 'DUPLEX_URL' ) ) define('DUPLEX_URL', get_template_directory_uri().'/');	

	include_once get_template_directory() . '/includes/loader.php';

	

	

	load_theme_textdomain('duplex', get_template_directory() . '/languages');

	

	//ADD THUMBNAIL SUPPORT

	add_theme_support('post-thumbnails');

	add_theme_support('woocommerce');

	add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.

	add_theme_support('widgets'); //Add widgets and sidebar support

	add_theme_support( "title-tag" );

	add_theme_support( 'wp-block-styles' );

	add_theme_support( 'align-wide' );

	add_theme_support( 'editor-styles' );

	/*

	 * Switch default core markup for search form, comment form, and comments

	 * to output valid HTML5.

	 */

	add_theme_support( 'html5', array(

		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'

	) );

	/** Register wp_nav_menus */

	if(function_exists('register_nav_menu'))

	{

		register_nav_menus(

			array(

				/** Register Main Menu location header */

				'main_menu' => esc_html__('Main Menu', 'duplex'),

				'sidebar_menu' => esc_html__('Sidebar Menu', 'duplex'),

				'footer_menu' => esc_html__('footer Menu', 'duplex'),

			)

		);

	}

	if ( ! isset( $content_width ) ) $content_width = 960;

	add_image_size( 'duplex_569x513', 569, 513, true ); // '569x513 Gallery Masonery'

	add_image_size( 'duplex_321x513', 321, 513, true ); // '569x513 Gallery Masonery'

	add_image_size( 'duplex_321x280', 321, 280, true ); // '321x280 Gallery Masonery'

	add_image_size( 'duplex_569x280', 569, 280, true ); // '569x280 Gallery Masonery'

	add_image_size( 'duplex_197x240', 197, 240, true ); // '197x240 Our Process'

	add_image_size( 'duplex_120x120', 120, 120, true ); // '120x120 Testimonial'

	add_image_size( 'duplex_251x230', 251, 230, true ); // '251x230 Latest News'

	add_image_size( 'duplex_80x80', 80, 80, true ); // '80x80 Testimonial V2'

	add_image_size( 'duplex_400x350', 400, 350, true ); // '400x350 Project V2'

	add_image_size( 'duplex_280x220', 280, 220, true ); // '280x220 Team'

	add_image_size( 'duplex_580x350', 580, 350, true ); // '580x350 Services'

	add_image_size( 'duplex_825x400', 825, 400, true ); // '825x400 Blog Page'

	add_image_size( 'duplex_440x300', 440, 300, true ); // '440x300 Blog Page'

	add_image_size( 'duplex_55x50', 55, 50, true ); // '55x50 Recent Post'

	add_image_size( 'duplex_76x70', 76, 70, true ); // '76X70 Footer Gallery'

	

}



function duplex_gutenberg_editor_palette_styles() {

    add_theme_support( 'editor-color-palette', array(

        array(

            'name' => esc_html__( 'strong yellow', 'duplex' ),

            'slug' => 'strong-yellow',

            'color' => '#f7bd00',

        ),

        array(

            'name' => esc_html__( 'strong white', 'duplex' ),

            'slug' => 'strong-white',

            'color' => '#fff',

        ),

		array(

            'name' => esc_html__( 'light black', 'duplex' ),

            'slug' => 'light-black',

            'color' => '#242424',

        ),

        array(

            'name' => esc_html__( 'very light gray', 'duplex' ),

            'slug' => 'very-light-gray',

            'color' => '#797979',

        ),

        array(

            'name' => esc_html__( 'very dark black', 'duplex' ),

            'slug' => 'very-dark-black',

            'color' => '#000000',

        ),

    ) );

	

	add_theme_support( 'editor-font-sizes', array(

		array(

			'name' => esc_html__( 'Small', 'duplex' ),

			'size' => 10,

			'slug' => 'small'

		),

		array(

			'name' => esc_html__( 'Normal', 'duplex' ),

			'size' => 15,

			'slug' => 'normal'

		),

		array(

			'name' => esc_html__( 'Large', 'duplex' ),

			'size' => 24,

			'slug' => 'large'

		),

		array(

			'name' => esc_html__( 'Huge', 'duplex' ),

			'size' => 36,

			'slug' => 'huge'

		)

	) );

	

}

add_action( 'after_setup_theme', 'duplex_gutenberg_editor_palette_styles' );



function duplex_bunch_widget_init()

{

	global $wp_registered_sidebars;

	$theme_options = _WSH()->option();

	

	register_sidebar(array(

	  'name' => esc_html__( 'Default Sidebar', 'duplex' ),

	  'id' => 'default-sidebar',

	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'duplex' ),

	  'before_widget'=>'<div id="%1$s" class="widget sidebar_widget %2$s">',

	  'after_widget'=>'</div>',

	  'before_title' => '<h2>',

	  'after_title' => '</h2>'

	));

	register_sidebar(array(

	  'name' => esc_html__( 'Footer Sidebar', 'duplex' ),

	  'id' => 'footer-sidebar',

	  'description' => esc_html__( 'Widgets in this area will be shown in Footer Area.', 'duplex' ),

	  'before_widget'=>'<div id="%1$s"  class="col-lg-3 col-md-3 col-sm-6 col-xs-12 footer_spacing footer-widget %2$s">',

	  'after_widget'=>'</div>',

	  'before_title' => '<h2>',

	  'after_title' => '</h2>'

	));

	

	register_sidebar(array(

	  'name' => esc_html__( 'Blog Listing', 'duplex' ),

	  'id' => 'blog-sidebar',

	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'duplex' ),

	  'before_widget'=>'<div id="%1$s" class="widget sidebar_widget %2$s">',

	  'after_widget'=>'</div>',

	  'before_title' => '<h2>',

	  'after_title' => '</h2>'

	));

	if( !is_object( _WSH() )  )  return;

	$sidebars = duplex_set(duplex_set( $theme_options, 'dynamic_sidebar' ) , 'dynamic_sidebar' ); 

	foreach( array_filter((array)$sidebars) as $sidebar)

	{

		if(duplex_set($sidebar , 'topcopy')) continue ;

		

		$name = duplex_set( $sidebar, 'sidebar_name' );

		

		if( ! $name ) continue;

		$slug = duplex_bunch_slug( $name ) ;

		

		register_sidebar( array(

			'name' => $name,

			'id' =>  sanitize_title( $slug ),

			'before_widget' => '<div id="%1$s" class="side-bar widget sidebar_widget %2$s">',

			'after_widget' => "</div>",

			'before_title' => '<div class="sec-title"><h3 class="skew-lines">',

			'after_title' => '</h3></div>',

		) );		

	}

	

	update_option('wp_registered_sidebars' , $wp_registered_sidebars) ;

}

add_action( 'widgets_init', 'duplex_bunch_widget_init' );

// Update items in cart via AJAX

add_filter('woocommerce_add_to_cart_fragments', 'duplex_bunch_woo_add_to_cart_ajax');

function duplex_bunch_woo_add_to_cart_ajax( $fragments ) {

    

	global $woocommerce;

    ob_start();

	

	get_template_part('includes/modules/wc_cart' );

	

	$fragments['li.wc-header-cart'] = ob_get_clean();

	

    return $fragments;

}

add_filter( 'woocommerce_enqueue_styles', '__return_false' );

function duplex_bunch_animate_it( $atts, $contents = null )

{

	return get_template_part( 'includes/modules/shortcodes/animate_it' );

}

function duplex_load_head_scripts() {

	$options = _WSH()->option();

    if ( !is_admin() ) {

	$protocol = is_ssl() ? 'https://' : 'http://';

	if(duplex_set($options, 'map_api_key')){

	$map_path = '?key='.duplex_set($options, 'map_api_key');	

    wp_enqueue_script( 'map-api', ''.$protocol.'maps.google.com/maps/api/js'.$map_path, array(), false, false );

	wp_enqueue_script( 'googlemap', get_template_directory_uri().'/js/googlemaps.js', array(), false, false );

	}

	wp_enqueue_script( 'html5shiv', get_template_directory_uri().'/js/html5shiv.js', array(), false, false );

	wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );

	wp_enqueue_script( 'respond-min', get_template_directory_uri().'/js/respond.min.js', array(), false, false );

	wp_script_add_data( 'respond-min', 'conditional', 'lt IE 9' );

    }

    }

    add_action( 'wp_enqueue_scripts', 'duplex_load_head_scripts' );

//global variables

function bunch_global_variable() {

    global $wp_query;

}



/*----------------------------Enqueue Scripts---------------------------------*/

//Styles



function duplex_enqueue_scripts() {

	$options = _WSH()->option();

    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css' );

	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css' );

	wp_enqueue_style( 'masterslider', get_template_directory_uri() . '/css/masterslider.css' );

	wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/css/jquery.fancybox.css' );

	wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css' );

	wp_enqueue_style( 'slicknav', get_template_directory_uri() . '/css/slicknav.css' );

	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/css/flaticon.css' );

	wp_enqueue_style( 'hover', get_template_directory_uri() . '/css/hover.css' );

	wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/css/owl.theme.css' );

	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css' );

	wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/css/jquery.bxslider.css' );

	wp_enqueue_style( 'smartmenus', get_template_directory_uri() . '/css/jquery.smartmenus.bootstrap.css' );

	wp_enqueue_style( 'scrollbar', get_template_directory_uri() . '/css/jquery.mCustomScrollbar.min.css' );

	if(class_exists('woocommerce')) wp_enqueue_style( 'duplex_woocommerce', get_template_directory_uri() . '/css/woocommerce.css' );

	wp_enqueue_style( 'duplex_main-style', get_stylesheet_uri() );

	wp_enqueue_style( 'duplex_custom', get_template_directory_uri() . '/css/custom.css' );

	wp_enqueue_style( 'duplex-gutenberg-style', get_template_directory_uri() . '/css/gutenberg.css' );

	wp_enqueue_style( 'duplex_responsive', get_template_directory_uri() . '/css/responsive.css' );



//Scripts

	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '1.0.0', true );

	wp_enqueue_script( 'mixitup', get_template_directory_uri() . '/js/jquery.mixitup.min.js', array(), '1.0.0', true );

	wp_enqueue_script( 'masonry', get_template_directory_uri() . '/js/masonry.pkgd.min.js', array(), '1.0.0', true );

	wp_enqueue_script( 'sticky', get_template_directory_uri() . '/js/jquery.sticky.js', array(), '1.0.0', true );

	wp_enqueue_script( 'custom_scrollbar', get_template_directory_uri() . '/js/jquery.mCustomScrollbar.concat.min.js', array(), '1.0.0', true );

	wp_enqueue_script( 'countTo', get_template_directory_uri() . '/js/jquery.countTo.js', array(), '1.0.0', true );

	wp_enqueue_script( 'appear', get_template_directory_uri() . '/js/jquery.appear.js', array(), '1.0.0', true );

	wp_enqueue_script( 'isotope', get_template_directory_uri() . '/js/isotope.pkgd.min.js', array(), '1.0.0', true );	

	wp_enqueue_script( 'bxslider', get_template_directory_uri() . '/js/jquery.bxslider.js', array(), '1.0.0', true );

	wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array(), '1.0.0', true );

	wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/js/jquery.fancybox.pack.js', array(), '1.0.0', true );

	wp_enqueue_script( 'wow', get_template_directory_uri() . '/js/wow.js', array(), '1.0.0', true );

	wp_enqueue_script( 'smartmenus', get_template_directory_uri() . '/js/jquery.smartmenus.js', array(), '1.0.0', true );

	wp_enqueue_script( 'smartmenus-bootstrap', get_template_directory_uri() . '/js/jquery.smartmenus.bootstrap.js', array(), '1.0.0', true );

	wp_enqueue_script( 'duplex_main-script', get_template_directory_uri() . '/js/main.js', array(), '1.0.0', true );

	if( is_singular() ) wp_enqueue_script('comment-reply');

}

add_action( 'wp_enqueue_scripts', 'duplex_enqueue_scripts' );



/*-------------------------------------------------------------*/

function duplex_theme_slug_fonts_url() {

    $fonts_url = '';

 

    /* Translators: If there are characters in your language that are not

    * supported by Lora, translate this to 'off'. Do not translate

    * into your own language.

    */

    $poppins = _x( 'on', 'Poppins font: on or off', 'duplex' );

	$bitter = _x( 'on', 'Bitter font: on or off', 'duplex' );

	$crimson_text = _x( 'on', 'Crimson Text font: on or off', 'duplex' );

	$titillium_web = _x( 'on', 'Titillium Web font: on or off', 'duplex' );

	

    /* Translators: If there are characters in your language that are not

    * supported by Open Sans, translate this to 'off'. Do not translate

    * into your own language.

    */

    $open_sans = _x( 'on', 'Open Sans font: on or off', 'duplex' );

	$raleway = _x( 'on', 'Raleway font: on or off', 'duplex' );

	$oswald = _x( 'on', 'Oswald font: on or off', 'duplex' );

 

    if ( 'off' !== $poppins || 'off' !== $bitter || 'off' !== $crimson_text || 'off' !== $titillium_web || 'off' !== $open_sans || 'off' !== $raleway || 'off' !== $oswald ) {

        $font_families = array();

 

        if ( 'off' !== $poppins ) {

            $font_families[] = 'Poppins:400,300,500,600,700';

        }

		

		if ( 'off' !== $bitter ) {

            $font_families[] = 'Bitter:400,400italic,700';

        }

		

		if ( 'off' !== $crimson_text ) {

            $font_families[] = 'Crimson Text:400,400italic,600,600italic,700,700italic';

        }

		

		if ( 'off' !== $titillium_web ) {

            $font_families[] = 'Titillium Web:400,600,700,600italic,300,300italic,700italic,900';

        }

		

		

		if ( 'off' !== $open_sans ) {

            $font_families[] = 'Open+Sans+Condensed:700,300italic,300';

        }

		

		if ( 'off' !== $raleway ) {

            $font_families[] = 'Raleway';

        }

		

		if ( 'off' !== $oswald ) {

            $font_families[] = 'Oswald:400,300,700';

        }

 

        $query_args = array(

            'family' => urlencode( implode( '|', $font_families ) ),

            'subset' => urlencode( 'latin,latin-ext' ),

        );

 

        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

    }

 

    return esc_url_raw( $fonts_url );

}

function duplex_theme_slug_scripts_styles() {

    wp_enqueue_style( 'duplex-theme-slug-fonts', duplex_theme_slug_fonts_url(), array(), null );

}

add_action( 'wp_enqueue_scripts', 'duplex_theme_slug_scripts_styles' );

add_action( 'admin_enqueue_scripts', 'duplex_theme_slug_scripts_styles' );

/*---------------------------------------------------------------------*/

function duplex_add_editor_styles() {

    add_editor_style( 'editor-style.css' );

}

add_action( 'admin_init', 'duplex_add_editor_styles' );

/**

 * WooCommerce Extra Feature

 * --------------------------

 *

 * Change number of related products on product page

 * Set your own value for 'posts_per_page'

 *

 */ 

function woo_related_products_limit() {

  global $product;

	

	$args['posts_per_page'] = 6;

	return $args;

}

add_filter( 'woocommerce_output_related_products_args', 'jk_related_products_args' );

  function jk_related_products_args( $args ) {

	$args['posts_per_page'] = 3; // 4 related products

	$args['columns'] = 3; // arranged in 2 columns

	return $args;

}



// Add the button somewhere in the summary (temporary placeholder)
add_action( 'woocommerce_single_product_summary', 'add_enquiry_button_temp', 5 );
function add_enquiry_button_temp() {
    echo '<button class="button popmake-691 enquiry-btn-temp">Enquiry</button>';
}

// Use jQuery to move the button after short description
add_action( 'wp_footer', 'move_enquiry_button_after_short_desc' );
function move_enquiry_button_after_short_desc() {
    if ( is_product() ) : ?>
        <script>
        jQuery(document).ready(function($){
            var $btn = $('.enquiry-btn-temp');
            if ($btn.length && $('.woocommerce-product-details__short-description').length) {
                $('.woocommerce-product-details__short-description').after($btn);
            }
        });
        </script>
    <?php endif;
}
