<?php $post_meta = _WSH()->get_meta();?>
<div class="blog_content">
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <?php if ( has_post_thumbnail() ):?>
            <div class="about_single blog_img">
                <div class="img-holder">
                    <?php the_post_thumbnail('duplex_825x400', array('class' => 'img-responsive'));?>
                    <div class="overlay">
                        <a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><i class="fa fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <?php endif;?>
              
            <div class="blog_text pull-right1 width_blog">
                <h2><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_title();?></a></h2>
                <h4><?php esc_html_e('posted', 'duplex');?> <?php echo get_the_date('M d Y');?></h4>
                <?php the_excerpt();?><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php esc_html_e('Read More', 'duplex');?></a>
                <div class="news_author">
                    <div class="clearfix">
                        <div class="author_img">
                            <?php echo get_avatar( get_the_author_meta( 'ID' ), 40 ); ?>
                        </div>
                        <div class="author_text">
                            <h2><?php the_author();?></h2>
                            <p><?php echo wp_kses_post(duplex_set($post_meta, 'description'));?></p>
                        </div> 
                    </div> 
                </div>  
            </div>
        </div>
    </div>
</div>