<?php
$options = array();
$options[] = array(
	'id'          => '_bunch_seo_settings',
	'types'       => array('post', 'page', 'product', 'bunch_services', 'bunch_team', 'bunch_projects'),
	'title'       => __('SEO Settings', BUNCH_NAME),
	'priority'    => 'low',
	'template'    => 
			array(
					
					array(
						'type' => 'toggle',
						'name' => 'seo_status',
						'label' => __('Enable SEO', BUNCH_NAME),
						'description' => __('Enable / disable seo settings for this post', BUNCH_NAME),
					),
					array(
						'type' => 'textbox',
						'name' => 'title',
						'label' => __('Meta Title', BUNCH_NAME),
						'description' => __('Enter meta title or leave it empty to use default title', BUNCH_NAME),
					),
					
					array(
						'type' => 'textarea',
						'name' => 'description',
						'label' => __('Meta Description', BUNCH_NAME),
						'default' => '',
						'description' => __('Enter meta description', BUNCH_NAME),
					),
					array(
						'type' => 'textarea',
						'name' => 'keywords',
						'label' => __('Meta Keywords', BUNCH_NAME),
						'default' => '',
						'description' => __('Enter meta keywords', BUNCH_NAME),
					),
				),
); /** SEO fields for custom posts and pages */
$options[] = array(
	'id'          => '_bunch_layout_settings',
	'types'       => array('post', 'page', 'product', 'bunch_services', ),
	'title'       => __('Layout Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => 
			array(
					
					array(
						'type' => 'radioimage',
						'name' => 'layout',
						'label' => __('Page Layout', BUNCH_NAME),
						'description' => __('Choose the layout for blog pages', BUNCH_NAME),
						'items' => array(
							array(
								'value' => 'left',
								'label' => __('Left Sidebar', BUNCH_NAME),
								'img' => BUNCH_TH_URL.'/includes/vafpress/public/img/2cl.png',
							),
							array(
								'value' => 'right',
								'label' => __('Right Sidebar', BUNCH_NAME),
								'img' => BUNCH_TH_URL.'/includes/vafpress/public/img/2cr.png',
							),
							array(
								'value' => 'full',
								'label' => __('Full Width', BUNCH_NAME),
								'img' => BUNCH_TH_URL.'/includes/vafpress/public/img/1col.png',
							),
							
						),
					),
					
					array(
						'type' => 'select',
						'name' => 'sidebar',
						'label' => __('Sidebar', BUNCH_NAME),
						'default' => '',
						'items' => bunch_get_sidebars(true)	
					),
				),
);
$options[] = array(
	'id'          => '_bunch_header_settings',
	'types'       => array('page', 'post'),
	'title'       => __('Header Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => 
			array(
					array(
						'type' => 'textbox',
						'name' => 'header_title',
						'label' => __('Header Title', BUNCH_NAME),
						'description' => __('Enter the Header title', BUNCH_NAME),
					),
					array(
						'type' => 'upload',
						'name' => 'header_img',
						'label' => __('Header image', BUNCH_NAME),
						'default' => '',
					),
					array(
						'type' => 'toggle',
						'name' => 'breadcrumb',
						'label' => __('Enable Breadcrumb', BUNCH_NAME),
						'description' => __('Enable / disable breadcrumb area in header for vc template', BUNCH_NAME),
					),
					
				),
);
$options[] =  array(
	'id'          => _WSH()->set_meta_key('post'),
	'types'       => array('post'),
	'title'       => __('Post Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => 
			array(		
					
					array(
						'type' => 'textbox',
						'name' => 'description',
						'label' => __('Post Description', BUNCH_NAME),
						'default' => '',
						'description' => __('Enter the post description.', BUNCH_NAME)
					),
					
			),
);
/* Page options */
/** Team Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_slide'),
	'types'       => array('bunch_slide'),
	'title'       => __('Slides Options', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
	
				array(
					'type'      => 'group',
					'repeating' => true,
					'length'    => 1,
					'name'      => 'bunch_slide_text',
					'title'     => __('Slide Content', BUNCH_NAME),
					'fields'    => array(
						
						array(
							'type' => 'textarea',
							'name' => 'slide_text',
							'label' => __('Slide Text', BUNCH_NAME),
							'default' => '',
							
						),
						
						
					),
				),
	),
);
/** Services Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_services'),
	'types'       => array( 'bunch_services' ),
	'title'       => __('Services Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => 
			array(
				
				array(
					'type' => 'textbox',
					'name' => 'num',
					'label' => __('Numbers', BUNCH_NAME),
					'default' => '',
				),
				array(
					'type' => 'textarea',
					'name' => 'sub_title',
					'label' => __('Sub Title', BUNCH_NAME),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'ext_url',
					'label' => __('Read more link', BUNCH_NAME),
					'default' => '#',
				),
				array(
					'type' => 'fontawesome',
					'name' => 'fontawesome',
					'label' => __('Service Icon', BUNCH_NAME),
					'default' => '',
				),
				
			),
);
/** Gallery Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_faqs'),
	'types'       => array('bunch_faqs'),
	'title'       => __('FAQs Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
				
				array(
					'type' => 'textbox',
					'name' => 'ext_url',
					'label' => __('Read more link', BUNCH_NAME),
					'default' => '#',
				),
				
	),
);
/** Gallery Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_gallery'),
	'types'       => array('bunch_gallery'),
	'title'       => __('Image Gallery Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
				array(
					'type' => 'textbox',
					'name' => 'price',
					'label' => __('Price', BUNCH_NAME),
					'default' => '',
				),
				
				array(
					'type' => 'textbox',
					'name' => 'ext_url',
					'label' => __('Quote link', BUNCH_NAME),
					'default' => '',
				),
	),
);
/** Team Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_team'),
	'types'       => array('bunch_team'),
	'title'       => __('Team Options', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
	
						
				array(
					'type' => 'textbox',
					'name' => 'designation',
					'label' => __('Designation', BUNCH_NAME),
					'default' => '',
				),
				array(
					'type' => 'textbox',
					'name' => 'team_link',
					'label' => __('Team Link', BUNCH_NAME),
					'default' => '#',
				),
				array(
					'type'      => 'group',
					'repeating' => true,
					'length'    => 1,
					'name'      => 'bunch_team_social',
					'title'     => __('Social Profile', BUNCH_NAME),
					'fields'    => array(
						
						array(
							'type' => 'fontawesome',
							'name' => 'social_icon',
							'label' => __('Social Icon', BUNCH_NAME),
							'default' => '',
						),
						
						array(
							'type' => 'textbox',
							'name' => 'social_link',
							'label' => __('Link', BUNCH_NAME),
							'default' => '',
							
						),
						
						
					),
				),
	),
);
/** Testimonial Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_testimonials'),
	'types'       => array('bunch_testimonials'),
	'title'       => __('Testimonials Options', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
				array(
					'type' => 'textbox',
					'name' => 'designation',
					'label' => __('Designation', BUNCH_NAME),
					'default' => 'Consultant',
				),
				array(
					'type' => 'textbox',
					'name' => 'ext_url',
					'label' => __('External Link', BUNCH_NAME),
					'default' => '#',
				),
	),
);

/** Process Options*/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_process'),
	'types'       => array('bunch_process'),
	'title'       => __('Process Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
				
				array(
					'type' => 'textbox',
					'name' => 'num',
					'label' => __('Circle Number', BUNCH_NAME),
					'default' => '',
				),
				array(
					'type' => 'select',
					'name' => 'cir_bg',
					'label' => __('Circle Background Adjustments.', BUNCH_NAME),
					'default' => 'circle_bg',
					'items' => array(
								array(
									'value' => 'circle_bg',
									'label' => __('Bg Circle One', BUNCH_NAME),
								),
								array(
									'value' => 'circle_bg_two',
									'label' => __('Bg Circle Two', BUNCH_NAME),
								),
								array(
									'value' => 'circle_bg_three',
									'label' => __('Bg Circle Three', BUNCH_NAME),
								),
								array(
									'value' => 'circle_bg_foure',
									'label' => __('Bg Circle Four', BUNCH_NAME),
								),
							),
				),
				array(
					'type' => 'select',
					'name' => 'cir_border',
					'label' => __('Border Adjustment for shortcode', BUNCH_NAME),
					'default' => 'cercle',
					'items' => array(
								array(
									'value' => 'cercle',
									'label' => __('Border Circle One', BUNCH_NAME),
								),
								array(
									'value' => 'cercle_two',
									'label' => __('Border Circle Two', BUNCH_NAME),
								),
								array(
									'value' => 'cercle_three',
									'label' => __('Border Circle Three', BUNCH_NAME),
								),
								array(
									'value' => 'cercle_four',
									'label' => __('Border Circle Four', BUNCH_NAME),
								),
							),
				),
				array(
					'type' => 'textbox',
					'name' => 'ext_url',
					'label' => __('Read more link', BUNCH_NAME),
					'default' => '#',
				),
				
	),
);

/** Projects Options**/
$options[] =  array(
	'id'          => _WSH()->set_meta_key('bunch_projects'),
	'types'       => array('bunch_projects'),
	'title'       => __('Image Gallery Settings', BUNCH_NAME),
	'priority'    => 'high',
	'template'    => array(
					
					array(
						'type' => 'textbox',
						'name' => 'sub_title',
						'label' => __('Sub Title', BUNCH_NAME),
						'default' => 'BEST INTERIOR DESIGN ',
					),
					array(
					'type' => 'select',
					'name' => 'extra_width',
					'label' => __('Allow Extra width for masnry Shortcode', BUNCH_NAME),
					'default' => 'normal_width',
					'items' => array(
									array(
										'value' => 'normal_width',
										'label' => __('Normal Width', BUNCH_NAME),
									),
									array(
										'value' => 'extra_width',
										'label' => __('Extra Width', BUNCH_NAME),
									),
								),
					),
					array(
					'type' => 'select',
					'name' => 'medium_width',
					'label' => __('Allow Extra width for masnry Shortcode', BUNCH_NAME),
					'default' => 'normal_width',
					'items' => array(
									array(
										'value' => 'normal_width',
										'label' => __('Normal Width', BUNCH_NAME),
									),
									array(
										'value' => 'medium_width',
										'label' => __('Medium Width', BUNCH_NAME),
									),
								),
					),
					array(
					'type' => 'select',
					'name' => 'extra_height',
					'label' => __('Allow Extra Height for masnry Shortcode', BUNCH_NAME),
					'default' => 'normal_height',
					'items' => array(
									array(
										'value' => 'normal_height',
										'label' => __('Normal Height', BUNCH_NAME),
									),
									array(
										'value' => 'extra_height',
										'label' => __('Extra Height', BUNCH_NAME),
									),
								),
					),
						
									
	),
);

/**
 * EOF
 */
 
 
 return $options; 