<?php
/**
 * This file contains pagination functions
 */


if ( ! function_exists( 'theme_pagination' ) ) {
	/**
	 * Pagination
	 *
	 * @param string $pages
	 */
	function theme_pagination( $pages = '' ) {

		$paged = 1;
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) { // if is static front page
			$paged = get_query_var( 'page' );
		}

		$prev       = $paged - 1;
		$next       = $paged + 1;
		$range      = 3; // only change it to show more links
		$show_items = ( $range * 2 ) + 1;

		if ( $pages == '' ) {
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if ( ! $pages ) {
				$pages = 1;
			}
		}

		if ( 1 != $pages ) {

			echo "<div class='pagination rh_pagination_classic'>";

			if ( $paged > 2 && $paged > $range + 1 && $show_items < $pages ) {
				echo "<a href='" . get_pagenum_link( 1 ) . "' class='real-btn real-btn-jump rh_arrows_left'> " . esc_html__( 'First', RH_TEXT_DOMAIN ) . "</a> ";
			}

			if ( $paged > 1 && $show_items < $pages ) {
				echo "<a rel='prev' href='" . get_pagenum_link( $prev ) . "' class='real-btn real-btn-jump rh_arrows_left' > " . esc_html__( 'Previous', RH_TEXT_DOMAIN ) . "</a> ";
			}

			for ( $i = 1; $i <= $pages; $i ++ ) {
				if ( 1 != $pages && ( ! ( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $show_items ) ) {
					if ( $paged == $i ) {
						echo "<a href='" . get_pagenum_link( $i ) . "' class='real-btn current' >" . $i . "</a> ";
					} else {
						echo "<a href='" . get_pagenum_link( $i ) . "' class='real-btn'>" . $i . "</a> ";
					}
				}
			}

			if ( $paged < $pages && $show_items < $pages ) {
				echo "<a rel='next' href='" . get_pagenum_link( $next ) . "' class='real-btn real-btn-jump rh_arrows_right' >" . esc_html__( 'Next', RH_TEXT_DOMAIN ) . "</a> ";
			}

			if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $show_items < $pages ) {
				echo "<a href='" . get_pagenum_link( $pages ) . "' class='real-btn real-btn-jump rh_arrows_right' >" . esc_html__( 'Last', RH_TEXT_DOMAIN ) . "</a> ";
			}

			echo "</div>";
		}
	}
}


if ( ! function_exists( 'inspiry_theme_pagination' ) ) {
	/**
	 * Pagination
	 *
	 * @param string $pages - number of pages.
	 */
	function inspiry_theme_pagination( $pages = '' ) {

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		$prev  = $paged - 1;
		$next  = $paged + 1;
		$range = 3; // Number of adjacent pages to show
		$pages_to_show = ( $range * 2 ) + 1;

		if ( empty( $pages ) ) {
			global $wp_query;
			$pages = $wp_query->max_num_pages ?: 1;
		}

		// Get pagination type option (arrows or labels)
		$pagination_type = get_option( 'realhomes_pagination_navigation_type', 'labels' );

		if ( $pages > 1 ) {
			echo "<div class='rh_pagination'>";

			if ( 'labels' === $pagination_type ) {
				// Show "First" only if there are hidden pages before the range
				if ( $paged > $range + 1 ) {
					echo "<a href='" . esc_url( get_pagenum_link( 1 ) ) . "' class='rh_pagination__btn rh_pagination__first rh-navigation-label'><i class='fas fa-angle-double-left'></i> " . esc_html__( 'First', RH_TEXT_DOMAIN ) . "</a>";
				}

				// Show "Previous" button if "labels" option is enabled
				if ( $paged > 1 ) {
					echo "<a rel='prev' href='" . esc_url( get_pagenum_link( $prev ) ) . "' class='rh_pagination__btn rh_pagination__prev rh-navigation-label'><i class='fas fa-angle-left'></i> " . esc_html__( 'Previous', RH_TEXT_DOMAIN ) . "</a>";
				}
			} elseif ( 'arrows' === $pagination_type && $paged > 1 ) {
				// Show only "<" arrow if "arrows" option is enabled
				echo "<a rel='prev' href='" . esc_url( get_pagenum_link( $prev ) ) . "' class='rh_pagination__btn rh_pagination__prev'><i class='fas fa-angle-left'></i></a>";
			}

			// Page number links
			for ( $i = 1; $i <= $pages; $i++ ) {
				if ( $i >= $paged - $range && $i <= $paged + $range ) {
					echo "<a href='" . esc_url( get_pagenum_link( $i ) ) . "' class='rh_pagination__btn " . ( $paged == $i ? 'current' : '' ) . "'>{$i}</a> ";
				}
			}

			if ( 'labels' === $pagination_type ) {
				// Show "Next" button if "labels" option is enabled
				if ( $paged < $pages ) {
					echo "<a rel='next' href='" . esc_url( get_pagenum_link( $next ) ) . "' class='rh_pagination__btn rh_pagination__next rh-navigation-label'>" . esc_html__( 'Next', RH_TEXT_DOMAIN ) . " <i class='fas fa-angle-right'></i></a>";
				}

				// Show "Last" only if there are hidden pages after the range
				if ( $paged + $range < $pages ) {
					echo "<a href='" . esc_url( get_pagenum_link( $pages ) ) . "' class='rh_pagination__btn rh_pagination__last rh-navigation-label'>" . esc_html__( 'Last', RH_TEXT_DOMAIN ) . " <i class='fas fa-angle-double-right'></i></a>";
				}
			} elseif ( 'arrows' === $pagination_type && $paged < $pages ) {
				// Show only ">" arrow if "arrows" option is enabled
				echo "<a rel='next' href='" . esc_url( get_pagenum_link( $next ) ) . "' class='rh_pagination__btn rh_pagination__next'><i class='fas fa-angle-right'></i></a>";
			}

			echo "</div>";
		}
	}
}


if ( ! function_exists( 'realhomes_ajax_pagination' ) ) {
	/**
	 * Pagination function for homepage AJAX pagination.
	 *
	 * @param string        $pages
	 * @param WP_Query|mixed $current_query
	 * @param string        $wrap_class
	 * @param bool          $show_labels Optional. Whether to show label-based navigation. Default true.
	 *
	 * @modified 4.4.0
	 */
	function realhomes_ajax_pagination( $pages = '', $current_query = '', $wrap_class = '', $show_labels = true ) {

		echo '<div class="svg-loader">';
		echo '<img src="' . INSPIRY_DIR_URI . '/images/loading-bars.svg" width="32" height="32" alt="' . esc_html__( 'Loading...', RH_TEXT_DOMAIN ) . '" />';
		echo '</div>';

		if ( empty( $current_query ) ) {
			global $wp_query;
			$current_query = $wp_query;
		}

		$paged = $current_query->get( 'paged' );

		if ( ! $paged || $paged < 1 ) {
			$paged = 1;
		}

		$prev  = $paged - 1;
		$next  = $paged + 1;
		$range = 3;
		$pages_to_show = ( $range * 2 ) + 1;

		if ( empty( $pages ) ) {
			$pages = $current_query->max_num_pages ?: 1;
		}

		if ( $pages > 1 ) {
			$pagination_class = is_front_page() ? 'pagination' : 'rh_pagination';
			$page_class = is_front_page() ? 'real-btn' : 'rh_pagination__btn';

			if ( ! empty( $wrap_class ) ) {
				$pagination_class = $wrap_class;
			}

			$pagination_type = get_option( 'realhomes_pagination_navigation_type', 'labels' );

			echo "<div class='" . esc_attr( $pagination_class ) . "'>";

			if ( 'labels' === $pagination_type && $paged > $range + 1 ) {
				echo "<a href='" . esc_url( get_pagenum_link( 1 ) ) . "' class='rh-pagination-first-item " . esc_attr( $page_class ) . " real-btn-jump' data-page-number='1' data-page-nav='first'><i class='fas fa-angle-double-left'></i> " . esc_html__( 'First', RH_TEXT_DOMAIN ) . "</a>";
			}

			if ( 'labels' === $pagination_type && $paged > 1 ) {
				echo "<a rel='prev' href='" . esc_url( get_pagenum_link( $prev ) ) . "' class='rh-pagination-prev-item " . esc_attr( $page_class ) . " real-btn-jump' data-page-number='" . intval( $prev ) . "' data-page-nav='previous'><i class='fas fa-angle-left'></i> " . esc_html__( 'Previous', RH_TEXT_DOMAIN ) . "</a>";
			}

			if ( 'arrows' === $pagination_type && $paged > 1 ) {
				echo "<a rel='prev' href='" . esc_url( get_pagenum_link( $prev ) ) . "' class='rh_pagination__btn rh_pagination__prev' data-page-number='" . esc_attr( $prev ) . "'><i class='fas fa-angle-left'></i></a>";
			}

			for ( $i = 1; $i <= $pages; $i++ ) {
				if ( $i >= $paged - $range && $i <= $paged + $range ) {
					$current_class = $page_class . ( $paged == $i ? ' current' : '' );
					echo "<a href='" . esc_url( get_pagenum_link( $i ) ) . "' class='" . esc_attr( $current_class ) . " nav-number' data-page-number='" . esc_attr( $i ) . "'>{$i}</a>";
				}
			}

			if ( 'arrows' === $pagination_type && $paged < $pages ) {
				echo "<a rel='next' href='" . esc_url( get_pagenum_link( $next ) ) . "' class='rh_pagination__btn rh_pagination__next' data-page-number='" . esc_attr( $next ) . "'><i class='fas fa-angle-right'></i></a>";
			}

			if ( 'labels' === $pagination_type && $paged < $pages ) {
				echo "<a rel='next' href='" . esc_url( get_pagenum_link( $next ) ) . "' class='rh-pagination-next-item " . esc_attr( $page_class ) . " real-btn-jump' data-page-number='" . intval( $next ) . "' data-page-nav='next'>" . esc_html__( 'Next', RH_TEXT_DOMAIN ) . "  <i class='fas fa-angle-right'></i></a>";
			}

			if ( 'labels' === $pagination_type && $paged + $range < $pages ) {
				echo "<a href='" . esc_url( get_pagenum_link( $pages ) ) . "' class='rh-pagination-last-item " . esc_attr( $page_class ) . " real-btn-jump' data-page-number='" . intval( $pages ) . "' data-page-nav='last'>" . esc_html__( 'Last', RH_TEXT_DOMAIN ) . "  <i class='fas fa-angle-double-right'></i></a>";
			}

			echo "</div>";
		}
	}
}



if ( ! function_exists( 'realhomes_get_ajax_pagination_status' ) ) {
	/**
	 * Check if Ajax Pagination is enabled globally
	 */
	function realhomes_get_ajax_pagination_status() {

		if ( 'classic' == INSPIRY_DESIGN_VARIATION ) {
			return false;
		}

		$global_ajax_pagination = get_option( 'realhomes_global_ajax_pagination', false );
		$page_ajax_pagination   = get_post_meta( get_the_ID(), 'ere_ajax_pagination', true );

		if ( $page_ajax_pagination ) {
			return false;
		} elseif ( $global_ajax_pagination ) {
			return true;
		} else {
			return false;
		}
	}
}


if ( ! function_exists( 'inspiry_users_pagination' ) ) {
	/**
	 * Pagination for users template
	 *
	 * @param $pages
	 */
	function inspiry_users_pagination( $pages ) {

		global $paged;
		if ( empty ( $paged ) ) {
			$paged = 1;
		}

		$prev = $paged - 1;
		$next = $paged + 1;

		$range     = 3; // only change it to show more links
		$showitems = ( $range * 2 ) + 1;

		if ( empty( $pages ) ) {
			$pages = 1;
		}

		$pagination_class = 'pagination';
		if ( 'modern' == INSPIRY_DESIGN_VARIATION ) {
			$pagination_class = 'rh_pagination';
		} elseif ( 'classic' == INSPIRY_DESIGN_VARIATION ) {
			$pagination_class = 'pagination';
		}

		if ( 1 != $pages ) {
			echo '<div class="' . $pagination_class . '">';

			if ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) {
				echo "<a href='" . get_pagenum_link( 1 ) . "' class='real-btn'>&laquo; " . esc_html__( 'First', RH_TEXT_DOMAIN ) . "</a> ";
			}

			if ( $paged > 1 && $showitems < $pages ) {
				echo "<a rel='prev' href='" . get_pagenum_link( $prev ) . "' class='real-btn' >&laquo; " . esc_html__( 'Previous', RH_TEXT_DOMAIN ) . "</a> ";
			}

			for ( $i = 1; $i <= $pages; $i ++ ) {
				if ( 1 != $pages && ( ! ( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $showitems ) ) {
					if ( $paged == $i ) {
						echo "<a href='" . get_pagenum_link( $i ) . "' class='real-btn current' >" . $i . "</a> ";
					} else {
						echo "<a href='" . get_pagenum_link( $i ) . "' class='real-btn'>" . $i . "</a> ";
					}
				}
			}

			if ( $paged < $pages && $showitems < $pages ) {
				echo "<a rel='next' href='" . get_pagenum_link( $next ) . "' class='real-btn' >" . esc_html__( 'Next', RH_TEXT_DOMAIN ) . " &raquo;</a> ";
			}

			if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) {
				echo "<a href='" . get_pagenum_link( $pages ) . "' class='real-btn' >" . esc_html__( 'Last', RH_TEXT_DOMAIN ) . " &raquo;</a> ";
			}

			echo "</div>";
		}
	}
}


if ( ! function_exists( 'update_taxonomy_pagination' ) ) {
	/**
	 * Update Taxonomy Pagination Based on Number of Properties Provided in Theme Options
	 *
	 * @param $query
	 */
	function update_taxonomy_pagination( $query ) {
		if ( is_tax( 'property-type' ) || is_tax( 'property-status' ) || is_tax( 'property-city' ) || is_tax( 'property-feature' ) ) {
			if ( $query->is_main_query() ) {
				$number_of_properties = intval( get_option( 'theme_number_of_properties' ) );
				if ( ! $number_of_properties ) {
					$number_of_properties = 6;
				}
				$query->set( 'posts_per_page', $number_of_properties );
			}
		}
	}

	add_action( 'pre_get_posts', 'update_taxonomy_pagination' );
}


if ( ! function_exists( 'inspiry_property_archive_pagination' ) ) {
	/**
	 * Property archive pagination based on Number of Properties Provided in settings
	 *
	 * @param $query
	 */
	function inspiry_property_archive_pagination( $query ) {
		if ( ! is_admin() && is_post_type_archive( 'property' ) ) {
			if ( $query->is_main_query() ) {
				$number_of_properties = intval( get_option( 'theme_number_of_properties' ) );
				if ( ! $number_of_properties ) {
					$number_of_properties = 6;
				}
				$query->set( 'posts_per_page', $number_of_properties );
			}
		}
	}

	add_action( 'pre_get_posts', 'inspiry_property_archive_pagination' );
}


if ( ! function_exists( 'inspiry_author_pagination_fix' ) ) :
	function inspiry_author_pagination_fix( $query ) {
		if ( is_author() ) {
			if ( $query->is_main_query() ) {
				$query->set( 'post_type', array( 'property' ) );
				$number_of_properties = intval( get_option( 'theme_number_of_properties_agent' ) );
				if ( ! $number_of_properties ) {
					$number_of_properties = 6;
				}
				$query->set( 'posts_per_page', $number_of_properties );
			}
		}
	}

	add_action( 'pre_get_posts', 'inspiry_author_pagination_fix' );
endif;


if ( ! function_exists( 'inspiry_pagination_fix' ) ) :
	function inspiry_pagination_fix( $redirect_url ) {
		if ( is_singular( 'agent' ) || is_singular( 'agency' ) || is_front_page() ) {
			$redirect_url = false;
		}

		return $redirect_url;
	}

	add_filter( 'redirect_canonical', 'inspiry_pagination_fix' );
endif;
