<?php
/**
 * Section:  `MISC`
 * Panel:    `Styles`
 * Description: This file contains mixed styles for contents in theme
 * which are not falling under any general title/heading.
 *
 * @since   4.4.0
 * @package realhomes/customizer
 */
if ( ! function_exists( 'realhomes_styles_misc_customizer' ) ) {
	/**
	 * realhomes_styles_misc_customizer.
	 *
	 * @since  4.4.0
	 *
	 * @param WP_Customize_Manager $wp_customize - Instance of WP_Customize_Manager.
	 *
	 */
	function realhomes_styles_misc_customizer( WP_Customize_Manager $wp_customize ) {

		// Buttons Section
		$wp_customize->add_section( 'realhomes_misc_styles', array(
			'title' => esc_html__( 'Miscellaneous', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_styles_panel',
		) );

		$wp_customize->add_setting( 'realhomes_rating_stars_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_rating_stars_color', array(
				'label'   => esc_html__( 'Rating Stars Color', RH_TEXT_DOMAIN ),
				'section' => 'realhomes_misc_styles',
			)
		) );

		$wp_customize->add_setting( 'realhomes_unrated_stars_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_unrated_stars_color', array(
				'label'   => esc_html__( 'Unrated Stars Color', RH_TEXT_DOMAIN ),
				'section' => 'realhomes_misc_styles',
			)
		) );
		$wp_customize->add_setting( 'realhomes_rating_percentage_inactive_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_rating_percentage_inactive_color', array(
				'label'   => esc_html__( 'Rating Percentage Inactive Color', RH_TEXT_DOMAIN ),
				'section' => 'realhomes_misc_styles',
			)
		) );
		$wp_customize->add_setting( 'realhomes_rating_percentage_active_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_rating_percentage_active_color', array(
				'label'   => esc_html__( 'Rating Percentage Active Color', RH_TEXT_DOMAIN ),
				'section' => 'realhomes_misc_styles',
			)
		) );

	}

	add_action( 'customize_register', 'realhomes_styles_misc_customizer' );
}