<?php
/**
 * Dashboard search template file
 *
 * @since 4.4.3
*/

$current_keyword     = ! empty( $_GET['keyword'] ) ? $_GET['keyword'] : '';
$current_search_type = 'properties';

if ( ! empty( $_GET['search-type'] ) ) {
	$current_search_type = $_GET['search-type'];
} else if ( ! empty( $_GET['module'] ) ) {
    $current_search_type = $_GET['module'];
}

$custom_placeholders = array(
	'properties'   => esc_html__( 'Property title', RH_TEXT_DOMAIN ),
	'agencies'     => esc_html__( 'Agency name', RH_TEXT_DOMAIN ),
	'agents'       => esc_html__( 'Agent title', RH_TEXT_DOMAIN ),
	'bookings'     => esc_html__( 'Booking ID', RH_TEXT_DOMAIN ),
	'reservations' => esc_html__( 'Reservation ID', RH_TEXT_DOMAIN ),
	'invoices'     => esc_html__( 'Invoice ID', RH_TEXT_DOMAIN )
);
?>

<div class="search-wrapper">
	<form method="get" class="dashboard-header-search">
		<div class="search-field-wrapper">
			<select name="search-type" id="dashboard-search-type" class="dashboard-header-search-type inspiry_select_picker_trigger show-tick" data-size="10">
				<option value="properties" data-content="<i class='fas fa-home'></i> <?php esc_html_e( 'Properties', RH_TEXT_DOMAIN ); ?>" <?php selected( 'properties', $current_search_type ) ?> data-placeholder="<?php echo esc_html( $custom_placeholders['properties'] ); ?>"><?php esc_html_e( 'Properties', RH_TEXT_DOMAIN ); ?></option>

                <?php
                if ( realhomes_dashboard_module_enabled( 'realhomes_agencies_module_display', 'false' ) && realhomes_get_current_user_role_option( 'manage_agencies' ) && post_type_exists( 'agency' ) ) {
                    ?><option value="agencies" data-content="<i class='fas fa-user-tie'></i> <?php esc_html_e( 'Agencies', RH_TEXT_DOMAIN ); ?>" <?php selected( 'agencies', $current_search_type ) ?> data-placeholder="<?php echo esc_html( $custom_placeholders['agencies'] ); ?>"><?php esc_html_e( 'Agencies', RH_TEXT_DOMAIN ); ?></option><?php
                }

                if ( realhomes_dashboard_module_enabled( 'realhomes_agents_module_display', 'false' ) && realhomes_get_current_user_role_option( 'manage_agents' ) && post_type_exists( 'agent' ) ) {
                    ?><option value="agents" data-content="<i class='fas fa-users'></i> <?php esc_html_e( 'Agents', RH_TEXT_DOMAIN ); ?>" <?php selected( 'agents', $current_search_type ) ?> data-placeholder="<?php echo esc_html( $custom_placeholders['agents'] ); ?>"><?php esc_html_e( 'Agents', RH_TEXT_DOMAIN ); ?></option><?php
                }

				if ( function_exists( 'rvr_is_enabled' ) && rvr_is_enabled() ) {
					if (
						realhomes_dashboard_module_enabled( 'realhomes_bookings_module_display', 'true' )
						&& realhomes_dashboard_module_enabled( 'inspiry_submit_property_module_display' )
						&& realhomes_get_current_user_role_option( 'property_submit' )
						&& realhomes_get_current_user_role_option( 'manage_bookings' )
					) {
						?><option value="bookings" data-content="<i class='fas fa-calendar-alt'></i> <?php esc_html_e( 'Bookings', RH_TEXT_DOMAIN ); ?>" <?php selected( 'bookings', $current_search_type ) ?> data-placeholder="<?php echo esc_html( $custom_placeholders['bookings'] ); ?>"><?php esc_html_e( 'Bookings', RH_TEXT_DOMAIN ); ?></option><?php
					}

					if ( realhomes_dashboard_module_enabled( 'realhomes_reservations_module_display', 'true' ) && realhomes_get_current_user_role_option( 'check_reservations' ) ) {
						?><option value="reservations" data-content="<i class='fas fa-calendar-check'></i> <?php esc_html_e( 'Reservations', RH_TEXT_DOMAIN ); ?>" <?php selected( 'reservations', $current_search_type ) ?> data-placeholder="<?php echo esc_html( $custom_placeholders['reservations'] ); ?>"><?php esc_html_e( 'Reservations', RH_TEXT_DOMAIN ); ?></option><?php
					}

					if ( realhomes_dashboard_module_enabled( 'realhomes_invoices_module_display', 'true' ) && class_exists( 'woocommerce' ) && realhomes_get_current_user_role_option( 'check_invoices' ) ) {
						?><option value="invoices" data-content="<i class='fas fa-envelope-open-text'></i> <?php esc_html_e( 'Invoices', RH_TEXT_DOMAIN ); ?>" <?php selected( 'invoices', $current_search_type ) ?> data-placeholder="<?php echo esc_html( $custom_placeholders['invoices'] ); ?>"><?php esc_html_e( 'Invoices', RH_TEXT_DOMAIN ); ?></option><?php
					}
				}
				?>
			</select>
			<input type="text" id="keyword" name="keyword" placeholder="<?php echo isset( $custom_placeholders[ $current_search_type ] ) ? esc_html( $custom_placeholders[ $current_search_type ] ) : ''; ?>" value="<?php echo esc_attr( $current_keyword ); ?>">
			<input type="hidden" id="module-target" name="module" value="<?php echo esc_attr( $current_search_type ); ?>">
            <?php echo ! empty( $_GET['posts_per_page'] ) ? '<input type="hidden" name="posts_per_page" value="' . esc_attr( $_GET['posts_per_page'] ) . '">' : ''; ?>
			<span class="submit-button">
                <?php inspiry_safe_include_svg( 'search-icon.svg', '/common/images/icons/' ); ?>
                <input type="submit" id="submit" value="<?php esc_html_e( 'Submit', RH_TEXT_DOMAIN ); ?>">
            </span>
		</div>
	</form>
</div>
