<?php
/**
 * Field: Submit Button
 *
 * @since 3.0.0
 */
?>
<div id="submit-property-form-actions"  class="dashboard-form-actions">
    <button type="button" id="previous" class="btn btn-primary previous disabled"><?php esc_html_e( 'Previous', RH_TEXT_DOMAIN ) ?></button>
    <button type="button" id="next" class="btn btn-primary next"><?php esc_html_e( 'Next', RH_TEXT_DOMAIN ) ?></button>
	<?php
	wp_nonce_field( 'submit_property', 'property_nonce' );

	if ( realhomes_dashboard_edit_property() ) :
		global $target_property; ?>
        <input type="hidden" name="action" value="update_property"/>
        <input type="hidden" name="property_id" value="<?php echo esc_attr( $target_property->ID ); ?>"/>
        <button type="button" id="cancel" class="cancel btn btn-secondary"><?php esc_html_e( 'Cancel', RH_TEXT_DOMAIN ) ?></a></button>
        <input type="submit" id="update-property-button" value="<?php esc_attr_e( 'Update Property', RH_TEXT_DOMAIN ); ?>" class="btn btn-primary update-property-button"/>
	<?php
	else :
		?>
        <input type="hidden" name="action" value="add_property"/>
        <input type="submit" id="submit-property-button" value="<?php esc_attr_e( 'Submit Property', RH_TEXT_DOMAIN ); ?>" class="btn btn-primary submit-property-button"/>
	<?php
	endif;
	?>
</div>