<?php
/**
 * Field: Agent
 *
 * @since    3.0.0
 * @package  realhomes/dashboard
 */
if ( ! inspiry_guest_submission_enabled() || is_user_logged_in() ) {
	$user_id                 = get_current_user_id();
	$user_role               = get_user_meta( $user_id, 'inspiry_user_role', true );
	$agent_post_id           = get_user_meta( $user_id, 'inspiry_role_post_id', true );
	$agency_post_id          = get_user_meta( $user_id, 'inspiry_user_agency', true ); // Get the agency post ID from user meta.
	$selected_agent          = 0;
	$hide_agents_list        = false;
	$default_selection       = 'profile_info';
	$agency_agents_args      = 'agent';
	$agent_assignment_option = get_option( 'realhomes_agent_assignment_option', 'default' );

	if ( 'default' === $agent_assignment_option ) {
		$default_selected_agent = intval( get_option( 'realhomes_default_selected_agent', 0 ) );
		if ( $default_selected_agent > 0 ) {
			$default_selection = 'agent_info';
			$selected_agent    = $default_selected_agent;
		}

	} else if ( 'current_user' === $agent_assignment_option ) {
		$default_selection = 'profile_info';
		$selected_agent    = $user_id;

		if ( 'agent' === $user_role ) {
			if ( empty( $agent_post_id ) && $agency_post_id === '-1' ) {
				$hide_agents_list = true;

			} elseif ( ! empty( $agent_post_id ) ) {
				$default_selection = 'agent_info';
				$selected_agent    = $agent_post_id;

				// Only fetch the single agent if no agency is selected
				if ( $agency_post_id === '-1' ) {
					$agency_agents_args = [
						'post_type'   => 'agent',
						'p'           => $agent_post_id,
						'numberposts' => 1,
					];
				}
			}
		}

	} else if ( 'agency_agent_only' === $agent_assignment_option && inspiry_is_user_sync_enabled() ) {
		if ( 'agent' === $user_role ) {
			$agency_id       = 0;
			$agent_agency_id = get_post_meta( $agent_post_id, 'REAL_HOMES_agency', true ); // Get the agency post ID from agent post meta.

			if ( '-1' !== $agency_post_id ) {
				$agency_id = $agency_post_id;
			} else if ( '-1' !== $agent_agency_id ) {
				$agency_id = $agent_agency_id;
			}

			if ( $agency_id ) {
				$default_selection  = 'agent_info';
				$selected_agent     = $agent_post_id;
				$agency_agents_args = array(
					'post_type'  => 'agent',
					'meta_query' => array(
						array(
							'key'     => 'REAL_HOMES_agency',
							'value'   => $agency_id,
							'compare' => '=',
						),
					),
				);
			}
		}
	}

	if ( realhomes_dashboard_edit_property() ) {
		global $post_meta_data;

		$agent_display_option = empty( $post_meta_data['REAL_HOMES_agent_display_option'][0] ) ? 'none' : $post_meta_data['REAL_HOMES_agent_display_option'][0];
		if ( 'none' == $agent_display_option ) {
			$default_selection = 'none';
		} else if ( 'agent_info' == $agent_display_option ) {
			$default_selection = 'agent_info';
		}

		if ( ! empty( $post_meta_data['REAL_HOMES_agents'] ) ) {
			$selected_agent = $post_meta_data['REAL_HOMES_agents'];
		}
	}

	$property_agent_info_label = get_option( 'realhomes_submit_property_agent_info_label' );
	if ( empty( $property_agent_info_label ) ) {
		$property_agent_info_label = esc_html__( 'What to display in agent information box?', RH_TEXT_DOMAIN );
	}

	$property_agent_none_label = get_option( 'realhomes_submit_property_agent_option_one_label' );
	if ( empty( $property_agent_none_label ) ) {
		$property_agent_none_label = esc_html__( 'None ( Agent information box will not be displayed )', RH_TEXT_DOMAIN );
	}

	$property_profile_information_label = get_option( 'realhomes_submit_property_agent_option_two_label' );
	if ( empty( $property_profile_information_label ) ) {
		$property_profile_information_label = esc_html__( 'My profile information.', RH_TEXT_DOMAIN );
	}

	$property_edit_profile_information_label = get_option( 'realhomes_submit_property_agent_option_two_sub_label' );
	if ( empty( $property_edit_profile_information_label ) ) {
		$property_edit_profile_information_label = esc_html__( '( Edit Profile Information )', RH_TEXT_DOMAIN );
	}

	$property_agent_information_label = get_option( 'realhomes_submit_property_agent_option_three_label' );
	if ( empty( $property_agent_information_label ) ) {
		$property_agent_information_label = esc_html__( 'Display agent(s) information.', RH_TEXT_DOMAIN );
	}
	?>
    <div class="property-agent-information">
        <label><?php echo esc_html( $property_agent_info_label ); ?></label>
        <ul class="list-unstyled agent-options-list">
            <li class="radio-field">
                <input id="agent_option_none" type="radio" name="agent_display_option" value="none"<?php checked( 'none', $default_selection ); ?> />
                <label for="agent_option_none"><?php echo esc_html( $property_agent_none_label ); ?></label>
            </li>
            <li class="radio-field">
                <input id="agent_option_profile" type="radio" name="agent_display_option" value="my_profile_info"<?php checked( 'profile_info', $default_selection ); ?> />
                <label for="agent_option_profile">
					<?php echo esc_html( $property_profile_information_label ); ?>
					<?php
					$profile_url = realhomes_get_dashboard_page_url( 'profile' );
					if ( ! empty( $profile_url ) ) : ?>
                        <a href="<?php echo esc_url( $profile_url ); ?>" target="_blank"><?php echo esc_html( $property_edit_profile_information_label ); ?></a>
					<?php else : ?>
                        <a href="<?php echo esc_url( network_admin_url( 'profile.php' ) ); ?>" target="_blank"><?php esc_html_e( '( Edit Profile Information )', RH_TEXT_DOMAIN ); ?></a>
					<?php
					endif;
					?>
                </label>
            </li>
			<?php
			if ( ! $hide_agents_list && post_type_exists( 'agent' ) ) {
				?>
                <li class="radio-field">
                    <input id="agent_option_agent" type="radio" name="agent_display_option" value="agent_info"<?php checked( 'agent_info', $default_selection ); ?> />
                    <label for="agent_option_agent"><?php echo esc_html( $property_agent_information_label ); ?></label>
                    <div class="agent-options-wrap">
                        <span class="note"><?php esc_html_e( 'Select agent(s)', RH_TEXT_DOMAIN ); ?></span>
                        <select name="agent_id[]" id="agent-selectbox" class="inspiry_select_picker_trigger show-tick" data-size="5" data-actions-box="true" title="<?php esc_attr_e( 'No Agent Selected', RH_TEXT_DOMAIN ) ?>"
							<?php
							if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
								// For ultra design, multiselect enabled by default
                                ?>
                                multiple data-selected-text-format="count > 2" data-count-selected-text="{0} <?php esc_attr_e( 'Agents Selected', RH_TEXT_DOMAIN ); ?>"
								<?php
							} else if ( 'yes' === get_option( 'inspiry_search_form_multiselect_agents', 'yes' ) ) {
								// For non-ultra design multiselect is optional
                                ?>
								multiple data-selected-text-format="count > 2" data-count-selected-text="{0} <?php esc_attr_e( 'Agents Selected', RH_TEXT_DOMAIN ); ?>"
                                <?php
							}
							?>>
							<?php generate_posts_list( $agency_agents_args, $selected_agent ); ?>
                        </select>
                    </div>
                </li>
				<?php
			}
			?>
        </ul>
    </div>
	<?php
}