<?php

/**
 * Saved Searches Tab Content.
 *
 * @since 4.4.5
 */
$saved_searches = $args['saved_searches'];

if ( $saved_searches ) {
	?>
	<div class="mt-8 flow-root">
		<div class="-mx-4 -my-4 sm:-mx-6 lg:-mx-8">
			<div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
				<div class="overflow-hidden shadow ring-1 ring-black/5 sm:rounded-lg">
					<table class="min-w-full divide-y divide-gray-300">
						<thead class="bg-gray-50">
						<tr>
							<th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-gray-900 sm:pl-6"><?php esc_html_e( 'Search Query', RH_TEXT_DOMAIN ); ?></th>
							<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Saved Time', RH_TEXT_DOMAIN ); ?></th>
						</tr>
						</thead>
						<tbody class="divide-y divide-gray-200 bg-white">
						<?php
						foreach ( $saved_searches as $search ) {
							?>
							<tr>
								<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $search->search_query_str ) ?></td>
								<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo Realhomes_Crm_Helper::human_readable_date( $search->time ) ?></td>
							</tr>
							<?php
						}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<?php
} else {
	Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No saved searches found for this lead.', RH_TEXT_DOMAIN ), classes: 'bg-white' );
}