<?php

/**
 * Displays the related inquiries for a lead.
 *
 * @since 4.4.5
 */
$inquiries = $args['inquiries'];

if ( ! empty( $inquiries ) ) {
	$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );
	?>
	<div class="mt-8 flow-root">
		<div class="-mx-4 -my-4 sm:-mx-6 lg:-mx-8">
			<div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
				<div class="overflow-hidden shadow ring-1 ring-black/5 sm:rounded-lg">
					<table class="min-w-full divide-y divide-gray-300">
						<thead class="bg-gray-50">
						<tr>
							<th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-gray-900 sm:pl-6"><?php esc_html_e( 'ID', RH_TEXT_DOMAIN ); ?></th>
							<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?></th>
							<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?></th>
							<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Property Type', RH_TEXT_DOMAIN ); ?></th>
							<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Price', RH_TEXT_DOMAIN ); ?></th>
						</tr>
						</thead>
						<tbody class="divide-y divide-gray-200 bg-white">

						<?php
						foreach ( $inquiries as $inquiry ) {
							$inquiry_query  = unserialize( $inquiry->query );
							$inquiry_type   = ! empty( $inquiry->type ) ? ucfirst( $inquiry->type ) : $fallback_value;
							$inquiry_status = ! empty( $inquiry->status ) ? ucfirst( $inquiry->status ) : $fallback_value;
							$property_type  = ! empty( $inquiry_query['property-type'][0] ) ? $inquiry_query['property-type'][0] : $fallback_value;
							$property_price = ! empty( $inquiry_query['min-price'] ) ? $inquiry_query['min-price'] . ' - ' . $inquiry_query['max-price'] : $fallback_value;
							?>
							<tr>
								<td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 sm:pl-6"><?php echo esc_html( $inquiry->id ) ?></td>
								<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $inquiry_type ) ?></td>
								<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $inquiry_status ) ?></td>
								<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $property_type ); ?></td>
								<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $property_price ) ?></td>
							</tr>
							<?php
						}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	<?php
} else {
	Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No inquiries found by this lead.', RH_TEXT_DOMAIN ), classes: 'bg-white' );
}