<?php
/**
 * This file is responsible for inquiries list page.
 *
 * @since 4.4.5
 */

$page_type = 'inquiry';

// Prepare args and fetch items from the CRM class
$args           = Realhomes_Crm_Helper::prepare_listing_page_args( $page_type );
$inquiries      = Realhomes_Crm_Inquiries::fetch_inquiries( [ 'number' => $args['items_per_page'], 'keyword' => $args['searched_word'], 'offset' => $args['offset'] ] );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );

if ( ! empty( $inquiries ) || isset( $_GET['posts_search'] ) ) {
	?>
	<!--Inquiries Header-->
	<?php
	Realhomes_Crm_Helper::listing_header( $page_type, $args['searched_word'] );
	if ( $inquiries ) {
		?>
		<!--Inquiry Items-->
		<div id="rh-crm-<?php echo Realhomes_Crm_Helper::get_page_type_plurals()[ $page_type ]; ?>-items" class="py-4 sm:px-6 lg:px-8 bg-white min-w-full max-w-full overflow-x-auto overflow-y-hidden">
			<table class="min-w-full divide-y divide-gray-200">
				<thead>
				<tr>
					<th scope="col" class="py-6 pl-4 pr-3 w-[40px]">
						<?php Realhomes_Crm_Helper::items_select_checkbox(); ?>
					</th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900 sm:pl-0"><?php esc_html_e( 'ID', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Lead', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Property Type', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Beds', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Baths', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900">
						<?php
						esc_html_e( 'Built Area', RH_TEXT_DOMAIN );
						$area_postfix = get_option( 'ere_area_unit', 'sq ft' );
						if ( ! empty( $area_postfix ) ) {
							echo '<span class="text-xs ml-1 text-gray-600">(' . esc_html( $area_postfix ) . ')</span>';
						}
						?>
					</th>
					<th scope="col" class="px-3 py-3.5 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Price', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0">
						<span class="sr-only"><?php esc_html_e( 'Actions', RH_TEXT_DOMAIN ); ?></span>
					</th>
				</tr>
				</thead>
				<tbody class="divide-y divide-gray-200">
				<?php
				// Loop through each inquires and output data in table rows
				$last_key = array_key_last( $inquiries );
				foreach ( $inquiries as $key => $inquiry ) {
					$query = unserialize( $inquiry->query );

					$lead_name = $fallback_value;
					if ( ! empty( $inquiry->lead_id ) ) {
						$lead = Realhomes_Crm_Leads::fetch_lead( (int) $inquiry->lead_id );
						if ( $lead ) {
							$lead_name = ! empty( $lead->display_name ) ? $lead->display_name : $lead->first_name . ' ' . $lead->lead_name;
						}
					}

					?>
					<tr class="rh-crm-item-wrapper hover:bg-gray-50 transition duration-200">
						<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm">
							<?php Realhomes_Crm_Helper::item_select_checkbox( $page_type, $inquiry->id ); ?>
						</td>
						<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm sm:pl-0"><?php echo esc_html( $inquiry->id ); ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo esc_html( $lead_name ); ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo ! empty( $inquiry->type ) ? esc_html( $inquiry->type ) : $fallback_value; ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ! empty( $inquiry->status ) ? '<span class="inline-flex items-center rounded-md bg-green-50 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-inset ring-green-600/20">' . esc_html( $inquiry->status ) . '</span>' : $fallback_value;
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo ! empty( $query['property-type'] ) ? esc_html( Realhomes_Crm_Helper::format_label( is_array( $query['property-type'] ) ? $query['property-type'][0] : $query['property-type'] ) ) : $fallback_value; ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ! empty( $query['min-beds'] ) ? esc_html( $query['min-beds'] ) : '';
							echo ' - ';
							echo ! empty( $query['max-beds'] ) ? esc_html( $query['max-beds'] ) : '';
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ! empty( $query['min-baths'] ) ? esc_html( $query['min-baths'] ) : '';
							echo ' - ';
							echo ! empty( $query['max-baths'] ) ? esc_html( $query['max-baths'] ) : '';
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ! empty( $query['min-area'] ) ? esc_html( $query['min-area'] ) : '';
							echo ' - ';
							echo ! empty( $query['max-area'] ) ? esc_html( $query['max-area'] ) : '';
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ! empty( $query['min-price'] ) ? ere_format_amount( intval( $query['min-price'] ) ) : '';
							echo ' - ';
							echo ! empty( $query['max-price'] ) ? ere_format_amount( intval( $query['max-price'] ) ) : '';
							?>
						</td>
						<td class="whitespace-nowrap py-5 pl-3 pr-4 text-sm sm:pr-0">
							<?php Realhomes_Crm_Helper::the_item_actions( $inquiry->id, $page_type, $key === $last_key ); ?>
						</td>
					</tr>
				<?php } ?>

				</tbody>
			</table>
		</div>

		<!--Leads Footer & Action Buttons-->
		<?php
		Realhomes_Crm_Helper::listing_footer( $args['offset'], $args['current_page'], $args['items_per_page'], $args['total_items'], $page_type );
		Realhomes_Crm_Helper::selected_items_action_buttons( $page_type );
	} else {
		Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No inquiries found matching your query :(', RH_TEXT_DOMAIN ) );
	}
} else {
	Realhomes_Crm_Helper::no_item_found_note( $page_type );
}
?>