<?php
/**
 * This file is responsible for displaying the list of already uploaded CSV files for import.
 *
 * @since 4.4.5
 */
?>
<!-- Uploaded Files List -->
<h3 class="text-lg font-[500] text-gray-700 p-8 mb-0 bg-gray-50"><?php esc_html_e( 'Already Uploaded Files', RH_TEXT_DOMAIN ); ?></h3>
<?php
$current_user_id = get_current_user_id();
$csv_files       = get_user_meta( $current_user_id, 'rh_crm_uploaded_csv_files', true );
$import_type     = Realhomes_Crm_Helper::get_import_type();
$fallback_value  = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );
?>
<div class="inline-block min-w-full max-w-full py-4 align-middle sm:px-6 lg:px-8 bg-white rounded-md overflow-x-auto overflow-y-hidden"><?php
	if ( ! empty( $csv_files ) ) {
		?>
		<table class="min-w-full divide-y divide-gray-300">
			<thead>
			<tr>
				<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'File', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Uploaded Date', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Last Imported', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0">
					<span class="sr-only"><?php esc_html_e( 'Actions', RH_TEXT_DOMAIN ); ?></span>
				</th>
			</tr>
			</thead>
			<tbody id="rh-crm-uploaded-csv-files" class="divide-y divide-gray-200">
			<?php

			$upload_dir = wp_upload_dir();

			// Loop through each csv file and output data in table rows
			$last_key = array_key_last( $csv_files );
			foreach ( $csv_files as $key => $csv_file ) {
				$file_exists = file_exists( trailingslashit( $upload_dir['basedir'] ) . 'realhomes-crm/csv-import/' . $csv_file['file_name'] );
				?>
				<tr class="rh-crm-item-wrapper hover:bg-gray-50 transition duration-200">
					<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm">
						<div class="flex items-center">
							<div class="size-14 shrink-0">
								<?php Realhomes_Crm_SVG::the_svg( 'file', 'size-14' ); ?>
							</div>
							<div class="ml-4">
								<div class="font-medium text-gray-900"><?php echo esc_html( $csv_file['file_name'] ) ?></div>
								<?php
								if ( $file_exists ) {
									?>
									<div class="mt-2 text-gray-500"><?php echo esc_html( $csv_file['file_size'] ) ?> kb</div><?php
								} else {
									?>
									<div class="mt-2 text-red-500 text-xs"><?php esc_html_e( 'File not found. It may have been deleted from the server.', RH_TEXT_DOMAIN ); ?></div><?php
								}
								?>

							</div>
						</div>
					</td>
					<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
						<div class="text-gray-900"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $csv_file['uploaded_date'] ) ); ?></div>
					</td>
					<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
						<div class="mt-2 text-gray-900"><?php echo esc_html( ! empty( $csv_file['imported_date'] ) ? Realhomes_Crm_Helper::human_readable_date( $csv_file['imported_date'] ) : $fallback_value ); ?></div>
					</td>
					<td class="whitespace-nowrap py-5 pl-3 pr-4 text-sm sm:pr-0">
						<div class="realhomes-crm-item-actions-wrapper relative flex-none">

							<!-- Opener Icon -->
							<button type="button" class="rh-crm-item-actions-controller -m-2.5 block p-2.5 text-gray-500 hover:text-gray-900" aria-expanded="false" aria-haspopup="true">
								<?php Realhomes_Crm_SVG::the_svg( 'menu-dots', 'size-8' ); ?>
							</button>

							<div class="realhomes-crm-item-actions hidden hide-it absolute right-[80%] <?php echo $key === $last_key ? 'bottom-[5px] right-full' : ''; ?> z-10 mt-2 w-36 origin-top-right rounded-md bg-white py-2 shadow-lg ring-1 ring-gray-900/5 focus:outline-none" role="menu" aria-orientation="vertical" aria-labelledby="options-menu-2-button" tabindex="-1">

								<!-- Import -->
								<?php
								if ( $file_exists ) {
									?>
									<a href="<?php echo esc_url( realhomes_get_dashboard_page_url( 'properties-crm' ) . '&submodule=crm/import&import=' . $import_type . '&fetch_file=' . $csv_file['file_name'] ); ?>" class="rh-crm-import-csv-file flex items-center px-6 py-3 text-sm/6 text-gray-900 hover:bg-gray-50 hover:text-green-400 cursor-pointer" role="menuitem" tabindex="-1" id="options-menu-2-item-1">
										<?php
										Realhomes_Crm_SVG::the_svg( 'import', 'fill-green-500 size-5 mr-2' );
										esc_html_e( 'Import', RH_TEXT_DOMAIN );
										?>
									</a>
									<?php
								}
								?>

								<!-- Delete -->
								<a data-file="<?php echo esc_attr( $csv_file['file_name'] ) ?>" class="rh-crm-delete-csv-file flex items-center px-6 py-3 text-sm/6 text-gray-900 hover:bg-gray-50 hover:text-red-400 cursor-pointer" role="menuitem" tabindex="-1" id="options-menu-2-item-2">
									<?php
									Realhomes_Crm_SVG::the_svg( 'delete', 'size-6' );
									esc_html_e( 'Delete', RH_TEXT_DOMAIN );
									?>
								</a>
							</div>
						</div>
					</td>
				</tr>
			<?php } ?>
			</tbody>
		</table>
		<?php
	} else {
		Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No CSV file is uploaded yet! Start by uploading one to begin the import process.', RH_TEXT_DOMAIN ), classes: 'bg-white' );
	}
	?>
</div>