<?php
/**
 * This file contains the CSV file upload form for the Realhomes CRM import page.
 *
 * @since 4.4.5
 */
?>
<!-- Upload a new CSV file guide -->
<div class="bg-gray-50 border border-gray-100 rounded-lg p-6 mb-10 leading-10">
    <h3 class="text-lg font-[500] text-gray-700 mb-8"><?php esc_html_e( 'How to Import Your Data Using a CSV File', RH_TEXT_DOMAIN ); ?></h3>
    <p class="text-gray-600 mb-4">
		<?php esc_html_e( 'Upload your CSV file here to easily import your data into the system. Follow the steps below to ensure a smooth import process:', RH_TEXT_DOMAIN ); ?>
    </p>
    <ol class="list-decimal list-inside text-gray-700 mb-4">
        <li><?php echo sprintf( esc_html__( 'Ensure your file is in %sCSV format%s.', RH_TEXT_DOMAIN ), '<span class="font-medium">', '</span>' ); ?></li>
        <li><?php esc_html_e( 'Each column should have a clear header that matches the data it contains.', RH_TEXT_DOMAIN ); ?></li>
        <li><?php esc_html_e( 'Remove any empty rows or irrelevant columns before uploading.', RH_TEXT_DOMAIN ); ?></li>
    </ol>
    <p class="text-gray-600 mb-0">
		<?php echo sprintf( esc_html__( 'Need an example? Download our %ssample CSV file%s to see the correct format.', RH_TEXT_DOMAIN ), '<a href="'. INSPIRY_COMMON_URI .'/dashboard/crm/import/realhomes-crm-sample.csv" class="text-[var(--dashboard-primary-color)] hover:text-slate-700 hover:underline font-medium">', '</a>' ); ?>
    </p>
</div>

<!-- Upload a new CSV file -->
<div>
    <h3 class="text-lg font-[500] text-gray-700 mb-8"><?php esc_html_e( 'Upload New CSV File', RH_TEXT_DOMAIN ); ?></h3>
    <form id="rh-crm-upload-csv-form" class="space-y-4">
        <!-- File Input -->
        <div>
            <input type="file" id="rh-crm-csv-file" name="csv_file" accept=".csv" class="mt-1 block w-full text-sm text-gray-700 bg-gray-50 rounded border border-gray-200 shadow-sm file:mr-6 file:py-4 file:px-8 file:rounded file:border-0 file:text-sm file:font-semibold cursor-pointer">
        </div>
        <!-- Submit Button -->
        <div class="text-right">
            <button id="rh-crm-upload-csv-button" class="rh-crm-btn-primary">
				<?php
				Realhomes_Crm_SVG::the_svg( 'loader', 'size-6 mr-2 hidden' );
				Realhomes_Crm_SVG::the_svg( 'upload', 'size-6 mr-2' );
				esc_html_e( 'Upload', RH_TEXT_DOMAIN );
				?>
            </button>
        </div>
    </form>
</div>