<?php
/**
 * Notes Section Template.
 *
 * @since 4.4.5
 *
 * @var array $args {
 *     @type int    $item_id   The ID of the related item.
 *     @type string $item_type The type of the related item.
 *     @type array  $notes     Array of notes associated with the item.
 * }
 */
$item_id   = $args['item_id'];
$item_type = $args['item_type'];
$notes     = $args['notes'];
?>
<!-- Add new note -->
<div class="border p-6">
    <form id="rh-crm-add-item-note" method="POST">
        <input type="hidden" name="related_item_id" value="<?php echo esc_attr( intval( $item_id ) ); ?>">
        <input type="hidden" name="type" value="<?php echo esc_attr( $item_type ); ?>">
        <input type="hidden" name="user_id" value="<?php echo esc_attr( get_current_user_id() ); ?>">
        <textarea rows="2" name="note" class="block w-full !h-28 !resize-none !px-0 !py-0 text-base text-gray-900 placeholder:text-gray-400 !border-0 sm:text-sm/6 !shadow-none" placeholder="<?php esc_html_e( 'Type your note...', RH_TEXT_DOMAIN ); ?>"></textarea>
        <div class="flex items-center justify-between pt-6">
            <div class="flex">
                <!-- Current user avatar will be displayed here with name -->
            </div>
            <div class="shrink-0">
                <button type="submit" class="inline-flex items-center rounded-md bg-[var(--dashboard-primary-color)] px-3 py-2 text-sm text-white shadow-sm hover:bg-slate-700 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-teal-600">
                    <?php
                    Realhomes_Crm_SVG::the_svg( 'loader', 'size-4 mr-2 hidden' );
                    esc_html_e( 'Add Note', RH_TEXT_DOMAIN );
                    ?>
                </button>
            </div>
        </div>
    </form>
</div>

<!-- List all the notes here -->
<div id="realhomes-crm-item-notes-list">
	<?php
	if ( $notes ) {
		foreach ( $notes as $note ) {
			?>
            <div id="note-<?php echo esc_attr( $note->id ); ?>" class="rh-crm-item-wrapper border mt-10 rounded text-sm">
                <div class="flex justify-between p-6 border-b">
                    <div class="flex items-center">
						<?php Realhomes_Crm_SVG::the_svg( 'clock', 'size-6 mr-2 fill-[var(--dashboard-primary-color)]' ); ?>
                        <span class="text-gray-700"><?php echo Realhomes_Crm_Helper::human_readable_date( $note->created_at ) ?></span>
                    </div>
                    <div>
                        <a data-type="note" data-id="<?php echo esc_attr( $note->id ); ?>" class="rh-crm-delete-item flex items-center hover:text-red-400 cursor-pointer">
							<?php Realhomes_Crm_SVG::the_svg( 'delete', 'size-6' ); ?><?php esc_html_e( 'Delete', RH_TEXT_DOMAIN ) ?>
                        </a>
                    </div>
                </div>
                <div class="p-6 leading-8">
					<?php echo esc_html( $note->note ); ?>
                </div>
            </div>
			<?php
		}
	} else {
		Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No notes found for this ', RH_TEXT_DOMAIN ) . $item_type . '.', classes: 'bg-white', icon_size: 'size-20' );
	}
	?>
</div>