<?php
/**
 * Containing dynamic css language switcher style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage common
 */

$lang_switcher_styles_keys = array(
	'theme_language_switcher_background',
	'theme_language_switcher_selected_text',
	'theme_language_switcher_background_open',
	'theme_language_switcher_text_open',
	'theme_language_switcher_background_dropdown',
	'theme_language_switcher_text_dropdown',
	'theme_language_switcher_background_hover_dropdown',
	'theme_language_switcher_text_hover_dropdown'
);

$lang_switcher_style_options = realhomes_get_options( $lang_switcher_styles_keys );

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher',
	'property' => 'background',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher .inspiry-language.current',
	'property' => 'color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_selected_text' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher > ul > li.open',
	'property' => 'background',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background_open' ],
);

$lang_switcher_array[] = array(
	'elements' => '.rh_language_open_full .inspiry-language-switcher .inspiry-language.current:hover',
	'property' => 'background',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background_open' ],
);

$lang_switcher_array[] = array(
	'elements' => '.rh_language_open_full .inspiry-language-switcher .inspiry-language.current:hover:after,
								.rh_language_open_full .inspiry-language-switcher .inspiry-language.current:hover > span',
	'property' => 'color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_text_open' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher > ul > li.open span',
	'property' => 'color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_text_open' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher > ul > li > ul',
	'property' => 'background',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background_dropdown' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher li .rh_languages_available li a span',
	'property' => 'color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_text_dropdown' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher li a:hover',
	'property' => 'background',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background_hover_dropdown' ],
);

$lang_switcher_array[] = array(
	'elements' => '.inspiry-language-switcher li .rh_languages_available li a:hover span',
	'property' => 'color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_text_hover_dropdown' ],
);

$lang_switcher_array[] = array(
	'elements' => '.rh_wrapper_language_switcher parent_open ::-webkit-scrollbar',
	'property' => 'background-color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background_dropdown' ],
);

$lang_switcher_array[] = array(
	'elements' => '.rh_wrapper_language_switcher parent_open ::-webkit-scrollbar-thumb',
	'property' => 'background-color',
	'value'    => $lang_switcher_style_options[ 'theme_language_switcher_background_hover_dropdown' ],
);

return $lang_switcher_array;