<?php
/**
 * Containing dynamic css form style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage common
 */

// General form styles
$general_form_styles = realhomes_get_options( array(
	'realhomes_form_label_color',
	'realhomes_form_field_background_color',
	'realhomes_form_field_text_color',
	'realhomes_form_field_icon_color',
	'realhomes_form_textarea_background_color',
	'realhomes_form_textarea_text_color',
	'realhomes_form_gdpr_text_color',
	'realhomes_form_button_bg_color',
	'realhomes_form_button_text_color',
	'realhomes_form_button_border_color',
	'realhomes_form_button_hover_bg_color',
	'realhomes_form_button_hover_text_color',
	'realhomes_form_button_hover_border_color'
) );

if ( REALHOMES_DESIGN_VARIATION == 'ultra' ) {
	$general_form_styles_ultra = realhomes_get_options( array(
		'realhomes_form_field_icon_color',
		'realhomes_form_field_icon_second_color'
	) );
}

$general_form_array[] = array(
	'elements' => '
				.rh_agent_form .rh_agent_form__text label,
				.rh_agent_form .rh_agent_form__textarea label,
				.rh_inspiry_gdpr .gdpr-checkbox-label,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.gdpr-field .gdpr-checkbox-label,
				.comment-form p label,
				.rh_property__mc_wrap .rh_property__mc .rh_mc_field label,
				.rh_contact__form .rh_contact__input label,
				.rh-ultra-form-field > label,
				.rh-ultra-form-contact-us .rh-inspiry-gdpr .gdpr-checkbox-label,
				.agent-contact-form-wrapper .rh-inspiry-gdpr .gdpr-checkbox-label,
				.agency-contact-form-wrapper .rh-inspiry-gdpr .gdpr-checkbox-label
			',
	'property' => 'color',
	'value'    =>  $general_form_styles['realhomes_form_label_color']
);

$general_form_array[] = array(
	'elements' => '
				.rh_agent_form .rh_agent_form__field input[type=text],
				.rh_agent_form .rh_agent_form__field input[type=email],
				.rh_agent_form .rh_agent_form__field input[type=number],
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field .rh_form__item input,
				.rh_property__sat_wrap .rh_property__sat .user-info .rh_sat_field button,
				.rh_property__sat_wrap .rh_property__sat .schedule-fields .rh_sat_field button,
				.comment-form .comment-form-author input,
				.comment-form .comment-form-email input,
				.comment-form .comment-form-url input,
				.design_modern .rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input,
				.rh_property__mc_wrap .inspiry_select_picker_trigger>.dropdown-toggle,
				.rh_contact__form .rh_contact__input input,
				.rh_property__mc_wrap .rh_property__mc .rh-mc-slider-fields,
				.rh_property__mc_wrap .rh_property__mc .rh-mc-slider-fields input,
				.comment-form .rh-ultra-form-field-wrapper,
				.comment-form .rh-ultra-form-field-wrapper.comment-form-email,
				.comment-form .rh-ultra-form-field-wrapper.comment-form-url,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper input,
				.rh_property__sat_wrap .rh-sat-select-field .bootstrap-select button.dropdown-toggle,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper input,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper input,
				.rh_agent_form .rh_agent_form__textarea textarea,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field .rh_form__item textarea,
				.comment-form p textarea,
				.rh_contact__form .rh_contact__input textarea,
				.comment-form .rh-ultra-form-field-wrapper.rh-ultra-form-textarea,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper.rh-ultra-form-textarea,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper.rh-ultra-form-textarea,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper.rh-ultra-form-textarea,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper input,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper textarea,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper input,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper textarea
			',
	'property' => 'background-color',
	'value'    =>  $general_form_styles['realhomes_form_field_background_color']
);

$general_form_array[] = array(
	'elements' => '
				.rh_agent_form .rh_agent_form__field input[type=text],
				.rh_agent_form .rh_agent_form__field input[type=email],
				.rh_agent_form .rh_agent_form__field input[type=number],
				.rh_agent_form .rh_agent_form__field input[type=text]::placeholder,
				.rh_agent_form .rh_agent_form__field input[type=email]::placeholder,
				.rh_agent_form .rh_agent_form__field input[type=number]::placeholder,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field .rh_form__item input,
				.rh_property__sat_wrap .rh_property__sat .user-info .rh_sat_field button,
				.rh_property__sat_wrap .rh_property__sat .schedule-fields .rh_sat_field button,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field .rh_form__item input::placeholder,
				.comment-form .comment-form-author input,
				.comment-form .comment-form-email input,
				.comment-form .comment-form-url input,
				.comment-form .comment-form-author input::placeholder,
				.comment-form .comment-form-email input::placeholder,
				.comment-form .comment-form-url input::placeholder,
				.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input,
				.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input::placeholder,
				.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item .bootstrap-select .dropdown-toggle,
				.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item .bootstrap-select .dropdown-toggle .filter-option-inner-inner,
				.rh_property__mc_wrap .inspiry_select_picker_trigger>.dropdown-toggle,
				.rh_property__mc_wrap .inspiry_select_picker_trigger>.dropdown-toggle::placeholder,
				.rh_contact__form .rh_contact__input input,
				.rh_contact__form .rh_contact__input input::placeholder,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper input,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper input::placeholder,
				.rh_property__sat_wrap .rh-sat-select-field .bootstrap-select button.dropdown-toggle,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper input,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper input::placeholder,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper input,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper:not(.rh-ultra-form-textarea) input::placeholder,
				.rh_agent_form .rh_agent_form__textarea textarea,
				.rh_agent_form .rh_agent_form__textarea textarea::placeholder,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field .rh_form__item textarea,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field .rh_form__item textarea::placeholder,
				.comment-form p textarea,
				.comment-form p textarea::placeholder,
				.rh_contact__form .rh_contact__input textarea::placeholder,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea,
				.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea::placeholder,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea,
				.rh_property__sat_wrap .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea::placeholder,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea,
				.agent-contact-form-wrapper .rh-ultra-form-field-wrapper.rh-ultra-form-textarea textarea::placeholder,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper input,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper input::placeholder,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper textarea,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper textarea::placeholder,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper input,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper input::placeholder,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper textarea,
				.agency-contact-form-wrapper .rh-ultra-form-field-wrapper textarea::placeholder
			',
	'property' => 'color',
	'value'    =>  $general_form_styles['realhomes_form_field_text_color']
);

if ( REALHOMES_DESIGN_VARIATION == 'ultra' ) {
	$general_form_array[] = array(
		'elements' => '				
					.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item .feather-calendar,
					.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item .rh-ultra-dark,
					.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper svg,
					.rh_property__sat_wrap .rh-ultra-form-field-wrapper label[for=sat-date] .rh-ultra-stroke-dark,
					.rh_property__sat_wrap .rh-ultra-form-field-wrapper svg,
					.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper svg,
					.rh-ultra-form-field-wrapper .rh-ultra-form .rh-ultra-form-field-wrapper svg,
					.agency-contact-form-wrapper .rh-ultra-form-field-wrapper svg
				',
		'property' => 'stroke',
		'value'    =>  $general_form_styles_ultra['realhomes_form_field_icon_color']
	);

	$general_form_array[] = array(
		'elements' => '
					.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item .feather-calendar,
					.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item .rh-ultra-dark path,
					.rh-property-agent-enquiry-form .rh-ultra-form-field-wrapper svg,
					.rh_property__sat_wrap .rh-ultra-form-field-wrapper label[for=sat-date] .rh-ultra-stroke-dark,
					.rh_property__sat_wrap .rh-ultra-form-field-wrapper svg,
					.rh-ultra-contact-form .rh-ultra-form .rh-ultra-form-field-wrapper svg,
					.agency-contact-form-wrapper .rh-ultra-form-field-wrapper svg
				',
		'property' => 'fill',
		'value'    =>  $general_form_styles_ultra['realhomes_form_field_icon_second_color']
	);
}

// GDPR statement color
$general_form_array[] = array(
	'elements' => '
				.rh-gdpr-text-inner-wrapper,
				.comment-form .comment-form-cookies-consent,
				.comment-form .comment-form-cookies-consent label
			',
	'property' => 'color',
	'value'    =>  $general_form_styles['realhomes_form_gdpr_text_color']
);

// Action buttons background color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label,
				.rh_property__sat_wrap .rh_property__sat .submit-wrap #schedule-submit,
				.realhomes_comments .comment-form .form-submit input[type=submit],
				.rh_contact__form .rh_contact__input input[type=submit],
				.rh-ultra-property-detail-agent .rh-ultra-button,
				.rh_agent_profile__contact_form input[type=submit],
				.agent-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-submit-wrapper .submit-button,
				.comment-respond .form-submit input[type=submit],
				.agency-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button
			',
	'property' => 'background-color',
	'value'    =>  $general_form_styles['realhomes_form_button_bg_color']
);

// Action buttons text color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label,
				.rh_property__sat_wrap .rh_property__sat .submit-wrap #schedule-submit,
				.realhomes_comments .comment-form .form-submit input[type=submit],
				.rh_contact__form .rh_contact__input input[type=submit],
				.rh-ultra-property-detail-agent .rh-ultra-button,
				.rh_agent_profile__contact_form input[type=submit],
				.agent-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-submit-wrapper .submit-button,
				.comment-respond .form-submit input[type=submit],
				.agency-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button
			',
	'property' => 'color',
	'value'    =>  $general_form_styles['realhomes_form_button_text_color']
);

// Action buttons border color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label,
				.rh_property__sat_wrap .rh_property__sat .submit-wrap #schedule-submit,
				.realhomes_comments .comment-form .form-submit input[type=submit],
				.rh_contact__form .rh_contact__input input[type=submit],
				.rh-ultra-property-detail-agent .rh-ultra-button,
				.rh_agent_profile__contact_form input[type=submit],
				.agent-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-submit-wrapper .submit-button,
				.comment-respond .form-submit input[type=submit],
				.agency-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button
			',
	'property' => 'border-color',
	'value'    =>  $general_form_styles['realhomes_form_button_border_color']
);

// Action buttons icon color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button svg,
				.agent-form-contact-methods-wrapper .submit-button svg path
			',
	'property' => 'fill',
	'value'    =>  $general_form_styles['realhomes_form_button_text_color']
);

// Action buttons hover background color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button:hover,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label:hover,
				.rh_property__sat_wrap .rh_property__sat .submit-wrap #schedule-submit:hover,
				.realhomes_comments .comment-form .form-submit input[type=submit]:hover,
				.rh_contact__form .rh_contact__input input[type=submit]:hover,
				.rh-ultra-property-detail-agent .rh-ultra-button:hover,
				.rh_agent_profile__contact_form input[type=submit]:hover,
				.agent-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button:hover,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-submit-wrapper .submit-button:hover,
				.comment-respond .form-submit input[type=submit]:hover,
				.agency-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button:hover
			',
	'property' => 'background-color',
	'value'    =>  $general_form_styles['realhomes_form_button_hover_bg_color']
);

// Action buttons hover text color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button:hover,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label:hover,
				.rh_property__sat_wrap .rh_property__sat .submit-wrap #schedule-submit:hover,
				.realhomes_comments .comment-form .form-submit input[type=submit]:hover,
				.rh_contact__form .rh_contact__input input[type=submit]:hover,
				.rh-ultra-property-detail-agent .rh-ultra-button:hover,
				.rh_agent_profile__contact_form input[type=submit]:hover,
				.agent-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button:hover,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-submit-wrapper .submit-button:hover,
				.comment-respond .form-submit input[type=submit]:hover,
				.agency-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button:hover
			',
	'property' => 'color',
	'value'    =>  $general_form_styles['realhomes_form_button_hover_text_color']
);

// Action buttons hover border color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button:hover,
				.rh_property__sat_wrap .rh_property__sat .rh_sat_field.tour-type .middle-fields .tour-field input:checked+label:hover,
				.rh_property__sat_wrap .rh_property__sat .submit-wrap #schedule-submit:hover,
				.realhomes_comments .comment-form .form-submit input[type=submit]:hover,
				.rh_contact__form .rh_contact__input input[type=submit]:hover,
				.rh-ultra-property-detail-agent .rh-ultra-button:hover,
				.rh_agent_profile__contact_form input[type=submit]:hover,
				.agent-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button:hover,
				.rh-ultra-contact-form .rh-ultra-form .rh-ultra-submit-wrapper .submit-button:hover,
				.comment-respond .form-submit input[type=submit]:hover,
				.agency-contact-form-wrapper .rh-ultra-submit-wrapper .submit-button:hover
			',
	'property' => 'border-color',
	'value'    =>  $general_form_styles['realhomes_form_button_hover_border_color']
);

// Action buttons hover text color
$general_form_array[] = array(
	'elements' => '
				.agent-form-contact-methods-wrapper .submit-button:hover svg,
				.agent-form-contact-methods-wrapper .submit-button:hover svg path
			',
	'property' => 'fill',
	'value'    =>  $general_form_styles['realhomes_form_button_hover_text_color']
);

return $general_form_styles;