<?php
/**
 * Containing dynamic css buttons style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage ultra
 */

$buttons_keys = array(
	'theme_button_hover_text_color',
	'theme_button_bg_color',
	'theme_button_hover_bg_color',
	'theme_button_text_color'
);

$buttons_options = realhomes_get_options( $buttons_keys );

// Button primary
$button_selectors       = '.rh-btn-primary, .pages-navigation a, .rh-form button, .rh-form input[type=submit], .post-password-form button, .post-password-form input[type=submit], .wpcf7-form button, .wpcf7-form input[type=submit], .wpforms-form button, .wpforms-form input[type=submit], button, .rh-filled-button, .rh-ultra-filled-button';
$button_hover_selectors = '.rh-btn-primary:hover, .pages-navigation a:hover, .rh-form button:hover, .rh-form input[type=submit]:hover, .post-password-form button:hover, .post-password-form input[type=submit]:hover, .wpcf7-form button:hover, .wpcf7-form input[type=submit]:hover, .wpforms-form button:hover, .wpforms-form input[type=submit]:hover, button:hover, .rh-filled-button:hover, .rh-ultra-filled-button:hover';

$buttons_css[] = array(
	'elements' => $button_selectors,
	'property' => 'background-color',
	'value'    => $buttons_options['theme_button_bg_color']
);
$buttons_css[] = array(
	'elements' => $button_selectors,
	'property' => 'border-color',
	'value'    => $buttons_options['theme_button_bg_color']
);
$buttons_css[] = array(
	'elements' => $button_selectors,
	'property' => 'color',
	'value'    => $buttons_options['theme_button_text_color']
);
$buttons_css[] = array(
	'elements' => $button_hover_selectors,
	'property' => 'color',
	'value'    => $buttons_options['theme_button_hover_text_color']
);

// Button outline primary
$outline_button_selectors       = '.rh-btn-outline-primary, .rh-hollow-button,.rh-ultra-hollow-button';
$outline_button_hover_selectors = '.rh-btn-outline-primary:hover, .rh-hollow-button:hover,.rh-ultra-hollow-button:hover';

$buttons_css[] = array(
	'elements' => $outline_button_selectors,
	'property' => 'background-color',
	'value'    => 'transparent'
);
$buttons_css[] = array(
	'elements' => $outline_button_selectors,
	'property' => 'border-color',
	'value'    => $buttons_options['theme_button_hover_bg_color']
);
$buttons_css[] = array(
	'elements' => $outline_button_selectors,
	'property' => 'color',
	'value'    => $buttons_options['theme_button_hover_text_color']
);
$buttons_css[] = array(
	'elements' => $outline_button_hover_selectors,
	'property' => 'background-color',
	'value'    => $buttons_options['theme_button_hover_bg_color']
);
$buttons_css[] = array(
	'elements' => $outline_button_hover_selectors,
	'property' => 'color',
	'value'    => $buttons_options['theme_button_hover_text_color']
);


return $buttons_css;