<?php
$enable_user_nav = get_option( 'theme_enable_user_nav' );

if ( ! empty( $enable_user_nav ) && 'true' === $enable_user_nav ) {
	$theme_login_url   = inspiry_get_login_register_url(); // login and register page URL
	$prop_detail_login = inspiry_prop_detail_login();
	$skip_prop_single  = ( 'yes' == $prop_detail_login && ! is_user_logged_in() && is_singular( 'property' ) );

	if ( is_user_logged_in() ) {
		?>
        <div class="rh-ultra-menu-user-profile">
            <a href="<?php echo esc_url( realhomes_get_dashboard_page_url() ); ?>">
	            <?php
	            $gravatar = RealHomes_Cache::get_cached_avatar( null, 150, 'user-icon' );
	            if ( $gravatar ) {
		            echo wp_kses_post( $gravatar );

	            } else {
		            inspiry_safe_include_svg( '/icons/user-dash/icon-profile.svg' );
	            }
	            ?>
            </a>
			<?php realhomes_render_user_menu( 'ultra' ); ?>
        </div><!-- /.rh-ultra-menu-user-profile -->
		<?php
	} else if (
		empty( $theme_login_url ) &&
		( ! is_page_template( 'templates/login-register.php' ) ) &&
		( ! is_user_logged_in() ) &&
		! $skip_prop_single ) {
		?>
        <div class="rh-ultra-menu-user-profile">
			<?php
			inspiry_safe_include_svg( '/icons/user-dash/icon-profile.svg' );

			// User Menu
			realhomes_render_user_menu( 'ultra' );
			?>
        </div><!-- /.rh-ultra-menu-user-profile -->
		<?php
	} else if ( ! empty( $theme_login_url ) && ( ! is_user_logged_in() ) ) {
		?>
        <a class="rh-ultra-menu-user-profile" href="<?php echo esc_url( $theme_login_url ); ?>">
			<?php inspiry_safe_include_svg( '/icons/user-dash/icon-profile.svg' ); ?>
        </a><!-- /.rh-ultra-menu-user-profile -->
		<?php
	}

}
