<?php
/**
 * Sticky Header
 *
 * @since 4.1.1
 *
 * @package realhomes/ultra
 */
?>
<div class="site-header rh-ultra-header-wrapper rh-sticky-header">
	<?php
	$sticky_header_logo        = get_option( 'realhomes_sticky_header_logo' );
	$sticky_header_retina_logo = get_option( 'realhomes_sticky_header_retina_logo' );

	if ( ! empty( $sticky_header_logo ) || ! empty( $sticky_header_retina_logo ) ) {
		?>
        <a title="<?php bloginfo( 'name' ); ?>" href="<?php echo esc_url( home_url() ); ?>">
			<?php inspiry_logo_img( $sticky_header_logo, $sticky_header_retina_logo ); ?>
        </a>
		<?php
	} else {
		get_template_part( 'assets/ultra/partials/header/site-logo' );
	}
	?>
    <div class="rh-ultra-header-inner">
        <div class="rh-ultra-nav">
			<?php get_template_part( 'assets/ultra/partials/header/menu-list-large-screens' ); ?>
        </div>
    </div>
</div>