<?php
/**
 * Similar Blog Posts
 * Similar blog posts to be displayed under single blog post
 * @since      4.4.2
 * @package    realhomes
 * @subpackage ultra
 */
$post_id = get_the_ID();

$tag_ids      = wp_get_post_terms( $post_id, 'post_tag', [ 'fields' => 'ids' ] );
$category_ids = wp_get_post_terms( $post_id, 'category', [ 'fields' => 'ids' ] );

$tax_query = [];

if ( ! empty( $category_ids ) ) {
	$tax_query[] = [
		'taxonomy' => 'category',
		'field'    => 'term_id',
		'terms'    => $category_ids,
	];
}

if ( ! empty( $tag_ids ) ) {
	$tax_query[] = [
		'taxonomy' => 'post_tag',
		'field'    => 'term_id',
		'terms'    => $tag_ids,
	];
}

$args = [
	'post_type'           => 'post',
	'post__not_in'        => [ $post_id ],
	'posts_per_page'      => 3,
	'ignore_sticky_posts' => true,
	'tax_query'           => array_merge( [ 'relation' => 'OR' ], $tax_query ),
];

$news_query = new WP_Query( apply_filters( 'realhomes_similar_posts_query', $args ) );
if ( $news_query->have_posts() ) {
	?>
    <div class="rhea_ele_property_ajax_target rh-similar-posts-wrapper">
        <div class="home-properties-section-inner-target">
            <h3 class="rh_property__heading"> <?php echo esc_html__( 'Similar Posts', RH_TEXT_DOMAIN ) ?></h3>
            <section class="rh-ultra-similar-posts">
				<?php
				while ( $news_query->have_posts() ) {
					$news_query->the_post();
					?>

                    <article>
                        <div class="rhea_ultra_news_thumbnail">
                            <figure>
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
									<?php
									if ( ! empty( get_the_post_thumbnail() ) ) {
										the_post_thumbnail( 'post-featured-image' );
									} else {
										inspiry_image_placeholder( 'post-featured-image' );
									}
									?>
                                </a>
                            </figure>
                            <div class="rhea_ultra_post_author">
                                <div class="rhea_author_avatar">
									<?php echo get_avatar( get_the_author_meta( 'email' ) ); ?>
                                </div>
                                <span class="by-author">
                                    <span class="rhea_by">
                                        <?php esc_html_e( 'By', 'realhomes-elementor-addon' ); ?>
                                    </span>
                                    <span class="author-link"><?php the_author(); ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="rhea_ultra_post_detail">
                            <p class="rhea_ultra_news_date">
                                <time class="rhea_ultra_date" datetime="<?php the_modified_time( 'c' ); ?>"> <?php the_time( get_option( 'date_format' ) ); ?></time>
                            </p>
                            <h3 class="rhea_ultra_post_title">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
                            </h3>
                        </div>
                    </article>

					<?php
				}
				?>
            </section>
        </div>
    </div>
	<?php
	wp_reset_postdata();
}
?>
