<?php
/**
 * Containing dynamic css search style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$search_styles_keys = array(
	'inspiry_search_form_primary_color',
	'inspiry_search_form_secondary_color',
	'inspiry_search_form_active_text',
	'theme_core_mod_color_green',
	'theme_core_mod_color_green_dark'
);

$search_style_options = realhomes_get_options( $search_styles_keys );

$search_form_primary_color   = $search_style_options['inspiry_search_form_primary_color'];
$search_form_secondary_color = $search_style_options['inspiry_search_form_secondary_color'];
$search_form_active_text     = $search_style_options['inspiry_search_form_active_text'];
$core_green_color            = $search_style_options['theme_core_mod_color_green'];
$core_green_dark_color       = $search_style_options['theme_core_mod_color_green_dark'];

$search_options_array = array(
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__searchBtn .rh_btn__prop_search,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open .inspiry_select_picker_trigger button.dropdown-toggle,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a,
			.rtl .rh_cfos .cfos_phone_icon:before, .rh_prop_search__form_smart .rh_form_smart_top_fields .inspiry_select_picker_trigger.open button.dropdown-toggle,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger.open button.dropdown-toggle,
			form.rh_sfoi_advance_search_form .inspiry_bs_is_open,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu,
			.rh_mode_sfoi_search_btn button
		',
		'property' => 'background',
		'value'    => $search_form_primary_color
	),
	array(
		'elements' => '.rh_prop_search__form_smart .inspiry_select_picker_trigger.open button.dropdown-toggle
				',
		'property' => 'border-color',
		'value'    => $search_form_primary_color
	),
	array(
		'elements' => '
			.rtl .rh_cfos .cfos_phone_icon:before,
			.rh_prop_search__form_smart .rh_form_smart_top_fields .inspiry_select_picker_trigger.open button.dropdown-toggle
		',
		'property' => 'border-right-color',
		'value'    => $search_form_primary_color
	),
	array(
		'elements' => '.inspiry_mod_search_form_smart .rh_prop_search__wrap_smart .open_more_features',
		'property' => 'color',
		'value'    => $search_form_primary_color
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__searchBtn .rh_btn__prop_search:hover,
			span.open_more_features.featured-open,
			span.open_more_features:hover
		',
		'property' => 'background',
		'value'    => $search_form_secondary_color
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons div.rh_prop_search__advance,
			span.open_more_features,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button:hover,
			.rh_mode_sfoi_search_btn button:hover,
			div.rh_mod_sfoi_advanced_expander
		',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $search_form_primary_color, 4 )
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons div.rh_prop_search__advance a:hover, 
			div.rh_mod_sfoi_advanced_expander:hover, 
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu li.selected,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu li:hover,
			div.rh_mod_sfoi_advanced_expander.rh_sfoi_is_open,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu .actions-btn:hover,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li.no-results,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li.selected a,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li:hover a,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-select-all:hover,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-deselect-all:hover,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu li.selected,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu li:hover,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu .actions-btn:hover,
			.rh_mod_sfoi_advanced_expander.rh_sfoi_is_open
		',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $search_form_primary_color, 8 )
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
			.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb
        ',
		'property' => 'outline-color',
		'value'    => inspiry_hex_darken( $search_form_primary_color, 8 )
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb
		',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $search_form_primary_color, 8 )
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track, 
			form.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track
		',
		'property' => 'box-shadow',
		'value'    => ' inset 0 0 6px ' . inspiry_hex_darken( $search_form_primary_color, 8 )
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__searchBtn .rh_btn__prop_search,
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__searchBtn .rh_btn__prop_search:hover,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open label,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open .inspiry_select_picker_trigger button.dropdown-toggle,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu li a,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger .form-control,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button,
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button:hover,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger.open button.dropdown-toggle,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li a,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li.selected a,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li.no-results,
			span.open_more_features,
			.rh_mode_sfoi_search_btn button,
			.rh_mode_sfoi_search_btn button:hover,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu li a,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger .form-control
		',
		'property' => 'color',
		'value'    => $search_form_active_text
	),
	array(
		'elements' => '
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .form-control,
			form.rh_sfoi_advance_search_form .inspiry_bs_is_open label
		',
		'property' => 'color',
		'value'    => $search_form_active_text . '!important'
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger .form-control,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu .btn-block,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .form-control,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger .form-control,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger > .dropdown-menu .btn-block,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu .btn-block
		',
		'property' => 'border-color',
		'value'    => $search_form_active_text
	),
	array(
		'elements' => '.rh_prop_search__form_smart .inspiry_select_picker_trigger .form-control
				',
		'property' => 'border-color',
		'value'    => $search_form_active_text . '!important'
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open .inspiry_select_picker_trigger button.dropdown-toggle .caret,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger.open span.caret,
			form.rh_sfoi_advance_search_form .inspiry_bs_is_open .inspiry_select_picker_trigger button.dropdown-toggle span.caret
		',
		'property' => 'border-top-color',
		'value'    => $search_form_active_text
	),
	array(
		'elements' => '
			.rh_prop_search__form .rh_btn__prop_search .icon-search, 
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart button .icon-search,
			.rh_prop_search__form .rh_btn__prop_search:hover .icon-search, 
			.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart button:hover .icon-search,
			form.rh_sfoi_advance_search_form .icon-search,
			.icon-search-plus,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu .actions-btn svg .rh-st0,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-deselect-all .inspiry_bs_deselect svg .rh-st0,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-deselect-all:hover .inspiry_bs_deselect svg .rh-st0,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu .actions-btn svg .rh-st0
		',
		'property' => 'stroke',
		'value'    => $search_form_active_text
	),
	array(
		'elements' => '
			form.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu .actions-btn svg,
			.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu .actions-btn:hover svg,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-select-all .inspiry_bs_select svg,
			.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-select-all:hover .inspiry_bs_select svg,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu .actions-btn svg,
			form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu .actions-btn:hover svg
		',
		'property' => 'fill',
		'value'    => $search_form_active_text
	)
);

if ( empty( $inspiry_advance_search_btn_bg ) ) {
	$search_options_array[] = array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__advance,
			.rh_mod_sfoi_advanced_expander
		',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $core_green_color, 4 ),
	);
}

if ( empty( $inspiry_advance_search_btn_hover_bg ) ) {
	$search_options_array[] = array(
		'elements' => '
			.rh_prop_search__form .rh_prop_search__buttons .rh_prop_search__advance a:hover,
			.rh_mod_sfoi_advanced_expander:hover,
			.rh_mod_sfoi_advanced_expander.rh_sfoi_is_open
		',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $core_green_color, 8 )
	);
}

return $search_options_array;