<?php
/**
 * Containing dynamic css footer style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */
global $dynamic_css;

$footer_styles_keys = array(
	'inspiry_footer_bg',
	'theme_footer_widget_text_color',
	'theme_footer_widget_link_color',
	'theme_footer_widget_link_hover_color',
	'theme_footer_widget_title_hover_color'
);

$footer_style_options = realhomes_get_options( $footer_styles_keys );

$inspiry_footer_bg                     = $footer_style_options['inspiry_footer_bg'];
$theme_footer_widget_text_color        = $footer_style_options['theme_footer_widget_text_color'];
$theme_footer_widget_link_color        = $footer_style_options['theme_footer_widget_link_color'];
$theme_footer_widget_link_hover_color  = $footer_style_options['theme_footer_widget_link_hover_color'];
$theme_footer_widget_title_hover_color = $footer_style_options['theme_footer_widget_title_hover_color'];

return array(
	array(
		'elements' => '.rh_footer',
		'property' => 'background',
		'value'    => $inspiry_footer_bg,
	),
	array(
		'elements' => '.rh_footer:before',
		'property' => 'border-right-color',
		'value'    => $inspiry_footer_bg,
	),
	array(
		'elements' => '
			.rh_footer a,
			.rh_footer .rh_footer__wrap .designed-by a,
			.rh_footer .rh_footer__wrap .copyrights a,
			.rh_footer .rh_footer__social a
		',
		'property' => 'color',
		'value'    => $theme_footer_widget_link_color,
	),
	array(
		'elements' => '
			.rh_footer .Property_Types_Widget li::before, 
			.rh_footer .widget_recent_comments li::before, 
			.rh_footer .widget_recent_entries li::before, 
			.rh_footer .widget_categories li::before, 
			.rh_footer .widget_nav_menu li::before, 
			.rh_footer .widget_archive li::before, 
			.rh_footer .widget_pages li::before, 
			.rh_footer .widget_meta li::before
		',
		'property' => $is_rtl ? 'border-right-color' : 'border-left-color',
		'value'    => $theme_footer_widget_link_color,
	),
	array(
		'elements' => '
			.rh_footer a:hover,
			.rh_footer .rh_contact_widget .rh_contact_widget__item a.content:hover,
			.rh_footer .rh_footer__wrap .designed-by a:hover,
			.rh_footer .rh_footer__wrap .copyrights a:hover,
			.rh_footer .rh_footer__social a:hover
		',
		'property' => 'color',
		'value'    => $theme_footer_widget_link_hover_color,
	),
	array(
		'elements' => '.rh_footer__widgets .widget .title',
		'property' => 'color',
		'value'    => $theme_footer_widget_title_hover_color,
	),
	array(
		'elements' => '
			.rh_footer,
			.rh_footer .rh_footer__logo .tag-line,
			.rh_footer__widgets .textwidget p,
			.rh_footer__widgets .textwidget,
			.rh_footer .rh_footer__wrap .copyrights,
			.rh_footer .rh_footer__wrap .designed-by,
			.rh_contact_widget .rh_contact_widget__item .content
		',
		'property' => 'color',
		'value'    => $theme_footer_widget_text_color,
	),
	array(
		'elements' => '.rh_contact_widget .rh_contact_widget__item .icon svg',
		'property' => 'fill',
		'value'    => $theme_footer_widget_text_color,
	)
);