<?php
/**
 * Containing dynamic css CTA style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$inspiry_home_cta_contact_bg_image = get_post_meta( get_the_ID(), 'inspiry_home_cta_contact_bg_image', true );
$inspiry_cta_background_image      = get_post_meta( get_the_ID(), 'inspiry_cta_background_image', true );

if ( ! empty( $inspiry_home_cta_contact_bg_image ) ) {
	$inspiry_home_cta_contact_bg_image = wp_get_attachment_url( $inspiry_home_cta_contact_bg_image );
}

if ( ! empty( $inspiry_cta_background_image ) ) {
	$inspiry_cta_background_image = wp_get_attachment_url( $inspiry_cta_background_image );
}

$cta_styles = array();

if ( ! empty( $inspiry_home_cta_contact_bg_image ) ) {
	$cta_styles[] = array(
		'elements' => '.rh_cta--contact .rh_cta',
		'property' => 'background-image',
		'value'    => 'url("' . $inspiry_home_cta_contact_bg_image . '")',
	);
}

if ( ! empty( $inspiry_cta_background_image ) ) {
	$cta_styles[] = array(
		'elements' => '.rh_cta--featured .rh_cta',
		'property' => 'background-image',
		'value'    => 'url("' . $inspiry_cta_background_image . '")',
	);
}

$prop_count_cta = count( $cta_styles );
if ( $prop_count_cta > 0 ) {
	foreach ( $cta_styles as $css_unit ) {
		if ( ! empty( $css_unit['value'] ) ) {
			$realhomes_modern_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
		}
	}
}

return $cta_styles;