<?php
/**
 * Containing dynamic css banner style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$inspiry_SFOI_overlay_opacity   = get_post_meta( get_the_ID(), 'inspiry_SFOI_overlay_opacity', true );
$inspiry_SFOI_overlay_color     = inspiry_hex2rgb( get_post_meta( get_the_ID(), 'inspiry_SFOI_overlay_color', true ), $inspiry_SFOI_overlay_opacity );
$inspiry_SFOI_title_color       = get_post_meta( get_the_ID(), 'inspiry_SFOI_title_color', true );
$inspiry_SFOI_description_color = get_post_meta( get_the_ID(), 'inspiry_SFOI_description_color', true );

$banner_styles_keys = array(
	'inspiry_banner_height',
	array( 'inspiry_banner_image_attachment', 'parallax' ),
	array( 'inspiry_banner_image_position', 'default' ),
	array( 'inspiry_banner_image_size', 'default' ),
	'theme_banner_bg_color',
	'theme_banner_bg_overlay_color',
	'theme_banner_bg_overlay_opacity',
	array( 'theme_banner_text_color', '#ffffff' )
);

$banner_style_options = realhomes_get_options( $banner_styles_keys );

$banner_height             = $banner_style_options['inspiry_banner_height'];
$banner_image_attachment   = $banner_style_options['inspiry_banner_image_attachment'];
$banner_image_position     = $banner_style_options['inspiry_banner_image_position'];
$banner_image_size         = $banner_style_options['inspiry_banner_image_size'];
$banner_bg_color           = $banner_style_options['theme_banner_bg_color'];
$banner_bg_overlay_color   = $banner_style_options['theme_banner_bg_overlay_color'];
$banner_bg_overlay_opacity = $banner_style_options['theme_banner_bg_overlay_opacity'];
$banner_text_color         = $banner_style_options['theme_banner_text_color'];
$banner_styles_array       = array();

if ( ! empty( $banner_height ) ) {
	$banner_styles_array[] = array(
		'elements' => '
			.rh_banner,
			.inspiry_mod_header_variation_two.inspiry_mod_search_form_default .rh_banner__image,
			.inspiry_mod_header_variation_three .rh_banner__image
		',
		'property' => 'height',
		'value'    => $banner_height,
	);
}

if ( 'fixed' === $banner_image_attachment ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_banner__image',
		'property' => 'background-attachment',
		'value'    => 'fixed',
	);
}

if ( 'default' !== $banner_image_position ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_banner__image',
		'property' => 'background-position',
		'value'    => esc_html( str_replace( '-', ' ', $banner_image_position ) )
	);
}

if ( 'default' !== $banner_image_size ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_banner__image',
		'property' => 'background-size',
		'value'    => esc_html( $banner_image_size )
	);
}

if ( ! empty( $inspiry_SFOI_overlay_color ) ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_mod_sfoi_overlay',
		'property' => 'background-color',
		'value'    => $inspiry_SFOI_overlay_color,
	);
}

if ( ! empty( $inspiry_SFOI_title_color ) ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_mod_sfoi_wrapper h2',
		'property' => 'color',
		'value'    => $inspiry_SFOI_title_color,
	);
}

if ( ! empty( $inspiry_SFOI_description_color ) ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_mod_sfoi_wrapper .SFOI__description',
		'property' => 'color',
		'value'    => $inspiry_SFOI_description_color,
	);
}

if ( ! empty( $banner_bg_color ) ) {
	$banner_styles_array[] = array(
		'elements' => 'body .rh_banner',
		'property' => 'background-color',
		'value'    => $banner_bg_color,
	);
}

if ( ! empty( $banner_bg_overlay_color ) ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_banner__cover',
		'property' => 'background',
		'value'    => $banner_bg_overlay_color,
	);
}

if ( ! empty( $banner_bg_overlay_opacity ) ) {
	$banner_styles_array[] = array(
		'elements' => '.rh_banner__cover',
		'property' => 'opacity',
		'value'    => $banner_bg_overlay_opacity,
	);
}

$banner_styles[] = array(
	'elements' => '.rh_banner .rh_banner__title',
	'property' => 'color',
	'value'    => $banner_text_color,
);

return $banner_styles_array;