<?php
/**
 * Property meta of single property template.
 *
 * @package    realhomes
 * @subpackage modern
 */

global $post;
$property_id      = get_the_ID();
$post_meta_data   = get_post_custom( $property_id );
$size_postfix     = realhomes_get_area_unit( $property_id );
$lot_size_postfix = realhomes_get_lot_unit( $property_id );

// Meta config
$meta_fields = [
	'bedrooms' => [
		'id'       => 'REAL_HOMES_property_bedrooms',
		'label'    => 'inspiry_bedrooms_field_label',
		'default'  => esc_html__( 'Bedrooms', RH_TEXT_DOMAIN ),
		'icon'     => '/images/icons/icon-bed.svg',
		'post-fix' => ''
	],
	'bathrooms' => [
		'id'       => 'REAL_HOMES_property_bathrooms',
		'label'    => 'inspiry_bathrooms_field_label',
		'default'  => esc_html__( 'Bathrooms', RH_TEXT_DOMAIN ),
		'icon'     => '/images/icons/icon-shower.svg',
		'post-fix' => ''
	],
	'garage' => [
		'id'       => 'REAL_HOMES_property_garage',
		'label'    => 'inspiry_garages_field_label',
		'default'  => esc_html__( 'Garage', RH_TEXT_DOMAIN ),
		'icon'     => '/images/icons/icon-garage.svg',
		'post-fix' => ''
	],
	'year-built' => [
		'id'       => 'REAL_HOMES_property_year_built',
		'label'    => 'inspiry_year_built_field_label',
		'default'  => esc_html__( 'Year Built', RH_TEXT_DOMAIN ),
		'icon'     => '/images/icons/icon-calendar.svg',
		'post-fix' => ''
	],
	'area' => [
		'id'       => 'REAL_HOMES_property_size',
		'label'    => 'inspiry_area_field_label',
		'default'  => esc_html__( 'Area', RH_TEXT_DOMAIN ),
		'icon'     => '/images/icons/icon-area.svg',
		'post-fix' => $size_postfix,
	],
	'lot-size' => [
		'id'       => 'REAL_HOMES_property_lot_size',
		'label'    => 'inspiry_lot_size_field_label',
		'default'  => esc_html__( 'Lot Size', RH_TEXT_DOMAIN ),
		'icon'     => '/images/icons/icon-lot.svg',
		'post-fix' => $lot_size_postfix,
	],
];

// Add RVR fields if enabled
if ( inspiry_is_rvr_enabled() ) {
	$meta_fields += [
		'guests' => [
			'id'       => 'rvr_guests_capacity',
			'label'    => 'inspiry_rvr_guests_field_label',
			'default'  => esc_html__( 'Capacity', RH_TEXT_DOMAIN ),
			'icon'     => '/images/guests-icons.svg',
			'post-fix' => ''
		],
		'min-stay' => [
			'id'       => 'rvr_min_stay',
			'label'    => 'inspiry_rvr_min_stay_label',
			'default'  => esc_html__( 'Min Stay', RH_TEXT_DOMAIN ),
			'icon'     => '/images/icons/icon-min-stay.svg',
			'post-fix' => ''
		],
	];
}

// Reusable meta renderer
function realhomes_render_property_meta_field( $meta_key, $meta_value, $label_option, $default_label, $icon_path, $postfix = '' ) {
	if ( empty( $meta_value ) ) {
		return;
	}

	$label = get_option( $label_option );
	$label = ! empty( $label ) ? esc_html( $label ) : $default_label;
	?>
    <div class="rh_property__meta prop_<?php echo esc_attr( str_replace( 'REAL_HOMES_property_', '', $meta_key ) ); ?>">
        <span class="rh_meta_titles"><?php echo $label; ?></span>
        <div>
	        <?php
	        if ( 'rvr_guests_capacity' === $meta_key ) {
		        realhomes_property_meta_icon( $meta_key, $icon_path, '/common/' );
	        } else {
		        realhomes_property_meta_icon( $meta_key, $icon_path );
	        }
	        ?>
            <span class="figure"><?php echo esc_html( $meta_value ); ?></span>
			<?php if ( ! empty( $postfix ) ) : ?>
                <span class="label"><?php echo esc_html( $postfix ); ?></span>
			<?php endif; ?>
        </div>
    </div>
	<?php
}

$default_order = array( 'bedrooms', 'bathrooms', 'area' );
$user_order    = get_option( 'inspiry_property_card_meta', $default_order );
$user_order    = array_filter( (array)$user_order );

$sorted = [];
foreach ( $user_order as $slug ) {
	if ( isset( $meta_fields[ $slug ] ) ) {
		$sorted[] = $meta_fields[ $slug ];
	}
}

$meta_fields = $sorted;
?>
<div class="rh_property__row rh_property__meta_wrap">
	<?php
	if ( ! empty( $sorted ) ) {
		foreach ( $meta_fields as $config ) {
			$meta_key      = $config['id'];
			$label_option  = $config['label'];
			$default_label = $config['default'];
			$icon_path     = $config['icon'];
			$postfix       = $config['post-fix'] ?? '';
			$meta_value    = $post_meta_data[ $meta_key ][0] ?? '';

			realhomes_render_property_meta_field( $meta_key, $meta_value, $label_option, $default_label, $icon_path, $postfix );
		}
	}
	/**
	 * This hook can be used to display more property meta fields
	 */
	do_action( 'inspiry_additional_property_meta_fields', $property_id );

	/**
	 * Custom property fields
	 */
	if ( is_singular( 'property' ) ) {
		$custom_fields  = apply_filters(
			'inspiry_property_custom_fields', array(
				array(
					'tab'    => array(),
					'fields' => array(),
				),
			)
		);

		if ( isset( $custom_fields['fields'] ) && ! empty( $custom_fields['fields'] ) ) {
			$prefix    = 'REAL_HOMES_';
			$icons_dir = INSPIRY_THEME_DIR . '/icons/';
			$icons_uri = INSPIRY_DIR_URI . '/icons/';

			foreach ( $custom_fields['fields'] as $field ) {
				if ( isset( $field['display'] ) && true === $field['display'] ) {

					$meta_key = $prefix . inspiry_backend_safe_string( $field['id'] );

					if ( isset( $post_meta_data[ $meta_key ] ) && ! empty( $post_meta_data[ $meta_key ][0] ) ) {

						$field_label = ( ! empty( $field['postfix'] ) ) ? $field['postfix'] : '';
						?>
                        <div class="rh_property__meta <?php echo esc_attr( $meta_key ); ?>">
                            <span class="rh_meta_titles"><?php echo esc_html( $field['name'] ); ?></span>
                            <div>
								<?php
								if ( file_exists( $icons_dir . $field['icon'] . '.png' ) ) {

									$data_rjs = ( file_exists( $icons_dir . $field['icon'] . '@2x.png' ) ) ? '2' : '';

									echo '<img src="' . esc_url( $icons_uri . $field['icon'] ) . '.png" alt="icon" data-rjs="' . esc_attr( $data_rjs ) . '">';
								}
								?>

                                <span class="figure">
									<?php echo esc_html( $post_meta_data[ $meta_key ][0] ); ?>
								</span>
								<?php if ( ! empty( $field_label ) ) : ?>
                                    <span class="label">
										<?php echo esc_html( $field_label ); ?>
									</span>
								<?php endif; ?>
                            </div>
                        </div>
						<?php
					}
				}
			}
		}
	}
	?>
</div>
