<?php
$enable_user_nav = get_option( 'theme_enable_user_nav' );

if ( ! empty( $enable_user_nav ) && 'true' === $enable_user_nav ) {
	$theme_login_url   = inspiry_get_login_register_url(); // login and register page URL
	$prop_detail_login = inspiry_prop_detail_login();
	$skip_prop_single  = ( 'yes' == $prop_detail_login && ! is_user_logged_in() && is_singular( 'property' ) );

	if ( is_user_logged_in() ) {
		?>
        <div class="rh_menu__user_profile">
            <a href="<?php echo esc_url( realhomes_get_dashboard_page_url() ); ?>">
	            <?php
	            $gravatar = RealHomes_Cache::get_cached_avatar( null, 150, 'user-icon' );
	             if ( $gravatar ) {
		            echo wp_kses_post( $gravatar );

	            } else {
		            inspiry_safe_include_svg( 'images/icon-profile.svg', '/common/' );
	            }
	            ?>
            </a>
			<?php
			// User Menu
			realhomes_render_user_menu( 'modern' );
			?>
        </div><!-- /.rh_menu__user_profile -->
		<?php
	} else if (
		empty( $theme_login_url ) &&
		( ! is_page_template( 'templates/login-register.php' ) ) &&
		( ! is_user_logged_in() ) &&
		! $skip_prop_single ) {
		?>
        <div class="rh_menu__user_profile">
			<?php
			inspiry_safe_include_svg( '/images/icons/icon-profile.svg' );

			// User Menu
			realhomes_render_user_menu( 'modern' );
			?>
        </div><!-- /.rh_menu__user_profile -->
		<?php
	} else if ( ! empty( $theme_login_url ) && ( ! is_user_logged_in() ) ) {
		?>
        <a class="rh_menu__user_profile" href="<?php echo esc_url( $theme_login_url ); ?>">
			<?php inspiry_safe_include_svg( '/images/icons/icon-profile.svg' ); ?>
        </a><!-- /.rh_menu__user_profile -->
		<?php
	}

}
