<?php
/**
 * Agency Search Form
 *
 * @since      4.0.0
 * @package    realhomes/modern
 */
?>
<form class="rh_agency_search__form rh_agent_search_form_header advance-agency-search-form" method="get">
	<?php
	get_template_part( 'assets/modern/partials/agency/search/fields/agency-keyword' );
	get_template_part( 'assets/modern/partials/agency/search/fields/number-of-agents' );
	get_template_part( 'assets/modern/partials/agency/search/fields/agency-locations' );
	?>
    <input type="hidden" id="agency-search-nonce" name="agency-search-nonce" value="<?php echo wp_create_nonce( 'agency_search_nonce' ); ?>">
</form>

<?php
$verified_agencies_placeholder      = esc_html__( 'Verified Agencies', RH_TEXT_DOMAIN );
$verified_agencies_placeholder_text = get_option( 'realhomes_verified_agencies_placeholder', $verified_agencies_placeholder );
if ( empty( $verified_agencies_placeholder_text ) ) {
	$verified_agencies_placeholder_text = $verified_agencies_placeholder;
}
?>
<div class="verified-agencies">
    <label class="toggle-switch">
        <span class="label-text">
            <?php echo esc_html( $verified_agencies_placeholder_text ); ?>
        </span>
        <input type="checkbox" id="verified-agencies" name="verified-agencies" value="yes"
			<?php checked( isset( $_GET['verified-agencies'] ) && $_GET['verified-agencies'] === 'yes' ); ?> >
        <span class="slider"></span>
    </label>
</div>