<?php
/**
 * View: Agency Card
 *
 * Agency card for agency listing.
 *
 * @since    3.5.0
 * @package realhomes/modern
 */

global $post;
$agency_id = get_the_ID();

/* Agency Contact Info */
$agency_mobile       = get_post_meta( $agency_id, 'REAL_HOMES_mobile_number', true );
$agency_whatsapp     = get_post_meta( $agency_id, 'REAL_HOMES_whatsapp_number', true );
$agency_office_phone = get_post_meta( $agency_id, 'REAL_HOMES_office_number', true );
$agency_office_fax   = get_post_meta( $agency_id, 'REAL_HOMES_fax_number', true );
$agency_email        = get_post_meta( $agency_id, 'REAL_HOMES_agency_email', true );

$listed_properties = 0;
if ( function_exists( 'ere_get_agency_properties_count' ) ) {
	$listed_properties = ere_get_agency_properties_count( $agency_id );
}
?>

<article class="rh_agent_card">

    <div class="rh_agent_card__wrap">

        <div class="rh_agent_card__head">

			<?php if ( has_post_thumbnail( $agency_id ) ) : ?>
                <figure class="rh_agent_card__dp">
                    <a title="<?php echo esc_attr( get_the_title( $agency_id ) ); ?>" href="<?php echo get_permalink( $agency_id ); ?>">
						<?php echo get_the_post_thumbnail( $agency_id, 'agent-image' ); ?>
                    </a>
                </figure>            <!-- /.rh_agent_card__dp -->
			<?php endif; ?>

            <div class="rh_agent_card__name">
                <h4 class="name">
                    <a href="<?php echo get_permalink( $agency_id ); ?>"><?php echo get_the_title( $agency_id ); ?></a>
                    <?php
                    realhomes_verification_badge( 'agency', $agency_id );
                    ?>
                </h4>
                <!-- /.name -->

                <div class="social social-networks-brand-color">
					<?php
					$facebook_url = get_post_meta( $agency_id, 'REAL_HOMES_facebook_url', true );
					if ( ! empty( $facebook_url ) ) {
						?><a class="facebook" target="_blank" href="<?php echo esc_url( $facebook_url ); ?>"><i class="fab fa-facebook fa-lg"></i></a><?php
					}

					$twitter_url = get_post_meta( $agency_id, 'REAL_HOMES_twitter_url', true );
					if ( ! empty( $twitter_url ) ) {
						?><a class="twitter" target="_blank" href="<?php echo esc_url( $twitter_url ); ?>"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor" viewBox="0 0 16 16"><path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"></path></svg></a><?php
					}

					$linked_in_url = get_post_meta( $agency_id, 'REAL_HOMES_linked_in_url', true );
					if ( ! empty( $linked_in_url ) ) {
						?><a class="linkedin" target="_blank" href="<?php echo esc_url( $linked_in_url ); ?>"><i class="fab fa-linkedin fa-lg"></i></a><?php
					}

					$instagram_url = get_post_meta( $agency_id, 'inspiry_instagram_url', true );
					if ( ! empty( $instagram_url ) ) {
						?><a class="instagram" target="_blank" href="<?php echo esc_url( $instagram_url ); ?>"><i class="fab fa-instagram fa-lg"></i></a><?php
					}

					$agency_website = get_post_meta( $agency_id, 'REAL_HOMES_website', true );
					if ( ! empty( $agency_website ) ) {
						?><a class="website-icon" target="_blank" href="<?php echo esc_url( $agency_website ); ?>"><i class="fas fa-globe fa-lg"></i></a><?php
					}

					$youtube_url = get_post_meta( $agency_id, 'inspiry_youtube_url', true );
					if ( ! empty( $youtube_url ) ) {
						?><a class="youtube" target="_blank" href="<?php echo esc_url( $youtube_url ); ?>"><i class="fab fa-youtube-square fa-lg"></i></a><?php
					}

					$pinterest_url = get_post_meta( $agency_id, 'inspiry_pinterest_url', true );
					if ( ! empty( $pinterest_url ) ) {
						?><a class="pinterest" target="_blank" href="<?php echo esc_url( $pinterest_url ); ?>"><i class="fab fa-pinterest fa-lg"></i></a><?php
					}
					?>
                </div>
                <!-- /.social -->

	            <?php
                // Display average ratings
	            if ( realhomes_get_rating_status() ) {
		            inspiry_rating_average();
	            }
	            ?>
            </div>
            <!-- /.rh_agent_card__name -->

            <?php
            $rh_agency_properties_count = get_option('inspiry_agencies_properties_count', 'show');
            if ('show' === $rh_agency_properties_count) { ?>
                <div class="rh_agent_card__listings">
                    <p class="head"><?php ( 1 === $listed_properties ) ? esc_html_e( 'Listed Property', RH_TEXT_DOMAIN ) : esc_html_e( 'Listed Properties', RH_TEXT_DOMAIN ); ?></p>
                    <!-- /.head -->
                    <p class="count"><?php echo ( ! empty( $listed_properties ) ) ? esc_html( $listed_properties ) : 0; ?></p>
                    <!-- /.count -->
                </div>
            <?php } ?>
            <!-- /.rh_agent_card__listings -->

        </div>
        <!-- /.rh_agent_card__head -->

        <div class="rh_agent_card__details">

            <p class="content"><?php framework_excerpt( 45 ); ?></p>
            <!-- /.content -->

            <div class="rh_agent_card__contact">

                <div class="rh_agent_card__contact_wrap">
					<?php
					if ( ! empty( $agency_office_phone ) ) {
						?><p class="contact office"><?php esc_html_e( 'Office', RH_TEXT_DOMAIN ); ?>:
                        <a href="tel:<?php echo esc_attr( $agency_office_phone ); ?>"><?php echo esc_html( $agency_office_phone ); ?></a>
                        </p><?php
					}
					if ( ! empty( $agency_mobile ) ) {
						?><p class="contact mobile"><?php esc_html_e( 'Mobile', RH_TEXT_DOMAIN ); ?>:
                        <a href="tel:<?php echo esc_attr( $agency_mobile ); ?>"><?php echo esc_html( $agency_mobile ); ?></a>
                        </p><?php
					}
					if ( ! empty( $agency_office_fax ) ) {
						?><p class="contact fax"><?php esc_html_e( 'Fax', RH_TEXT_DOMAIN ); ?>:
                        <a href="fax:<?php echo esc_attr( $agency_office_fax ); ?>"><?php echo esc_html( $agency_office_fax ); ?></a>
                        </p><?php
					}
					if ( ! empty( $agency_whatsapp ) ) {
						?><p class="contact whatsapp"><?php esc_html_e( 'WhatsApp', RH_TEXT_DOMAIN ); ?>:
                        <a href="https://wa.me/<?php echo esc_attr( preg_replace('/\D/', '', $agency_whatsapp ) ); ?>"><?php echo esc_html( $agency_whatsapp ); ?></a>
                        </p><?php
					}
					if ( ! empty( $agency_email ) ) {
						?><p class="contact email"><?php esc_html_e( 'Email', RH_TEXT_DOMAIN ); ?>:
                        <a href="mailto:<?php echo esc_attr( antispambot( $agency_email ) ); ?>"><?php echo esc_html( antispambot( $agency_email ) ); ?></a>
                        </p><?php
					}
					?>
                </div>
                <!-- /.rh_agent_card__contact_wrap -->
                <a href="<?php the_permalink(); ?>" class="rh_agent_card__link">
                    <p><?php esc_html_e( 'Know More', RH_TEXT_DOMAIN ); ?></p>
                    <i class="fas fa-angle-right"></i>
                </a>
                <!-- /.rh_agent_card__link -->

            </div>
            <!-- /.rh_agent_card__contact -->

        </div>
        <!-- /.rh_agent_card__details -->

    </div>
    <!-- /.rh_agent_card__wrap -->

</article><!-- /.rh_agent_card -->
