<?php
/**
 * Containing dynamic css slider style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$slider_keys = array(
	'theme_slide_title_color',
	'theme_slide_title_hover_color',
	'theme_slide_desc_text_color',
	'theme_slide_price_color',
	'theme_slide_know_more_text_color',
	'theme_slide_know_more_bg_color',
	'theme_slide_know_more_hover_bg_color'
);

$slider_options = realhomes_get_options( $slider_keys );

$slider_css = array(
	'elements' => '
		.slide-description h3,
		.slide-description h3 a
	',
	'property' => 'color',
	'value'    => $slider_options[ 'theme_slide_title_color' ]
);

$slider_css = array(
	'elements' => '
		.slide-description h3 a:hover,
		.slide-description h3 a:focus,
		.slide-description h3 a:active
	',
	'property' => 'color',
	'value'    => $slider_options[ 'theme_slide_title_hover_color' ]
);

$slider_css = array(
	'elements' => '.slide-description p',
	'property' => 'color',
	'value'    => $slider_options[ 'theme_slide_desc_text_color' ]
);

$slider_css = array(
	'elements' => '.slide-description span',
	'property' => 'color',
	'value'    => $slider_options[ 'theme_slide_price_color' ]
);

$slider_css = array(
	'elements' => '.slide-description .know-more',
	'property' => 'color',
	'value'    => $slider_options[ 'theme_slide_know_more_text_color' ]
);

$slider_css = array(
	'elements' => '.slide-description .know-more',
	'property' => 'background-color',
	'value'    => $slider_options[ 'theme_slide_know_more_bg_color' ]
);

$slider_css = array(
	'elements' => '.slide-description .know-more:hover',
	'property' => 'background-color',
	'value'    => $slider_options[ 'theme_slide_know_more_hover_bg_color' ]
);

return $slider_css;