<?php
/**
 * Containing dynamic css rating stars style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$rating_star_keys = array(
	'realhomes_rating_stars_color',
	'realhomes_unrated_stars_color',
	'realhomes_rating_percentage_inactive_color',
	'realhomes_rating_percentage_active_color'
);

$rating_stars_colors = realhomes_get_options( $rating_star_keys );

$ratings_css[] = array(
	'elements' => '.rating-stars i.rated,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-selected,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-selected:after,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-active,
		.rating-box .br-theme-fontawesome-stars .br-widget a.br-active:after',
	'property' => 'color',
	'value'    => $rating_stars_colors[ 'realhomes_rating_stars_color' ]
);
$ratings_css[] = array(
	'elements' => '.rating-stars i,
		.rating-box .br-theme-fontawesome-stars .br-widget a,
		.rating-box .br-theme-fontawesome-stars .br-widget a:after',
	'property' => 'color',
	'value'    => $rating_stars_colors[ 'realhomes_unrated_stars_color' ]
);
$ratings_css[] = array(
	'elements' => 'body.design_classic .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line',
	'property' => 'background-color',
	'value'    => $rating_stars_colors[ 'realhomes_rating_percentage_inactive_color' ]
);
$ratings_css[] = array(
	'elements' => 'body.design_classic .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line .inspiry_rating_line_inner',
	'property' => 'background-color',
	'value'    => $rating_stars_colors[ 'realhomes_rating_percentage_active_color' ]
);

return $ratings_css;