<?php
/**
 * Containing dynamic css property style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$property_keys = array(
	'theme_property_item_bg_color',
	'theme_property_item_border_color',
	'theme_property_title_color',
	'theme_property_title_hover_color',
	'theme_property_price_text_color',
	'theme_property_price_bg_color',
	'theme_property_status_text_color',
	'theme_property_status_bg_color',
	'theme_property_desc_text_color',
	'theme_more_details_text_color',
	'theme_more_details_text_hover_color',
	'theme_property_meta_text_color',
	'theme_property_meta_bg_color'
);

$property_options = realhomes_get_options( $property_keys );

$property_css = array(
	'elements' => '.property-item',
	'property' => 'background-color',
	'value'    => $property_options[ 'theme_property_item_bg_color' ]
);

$property_css = array(
	'elements' => '
		.property-item,
		.property-item .property-meta,
		.property-item .property-meta span
	',
	'property' => 'border-color',
	'value'    => $property_options[ 'theme_property_item_border_color' ]
);

$property_css = array(
	'elements' => '
		.property-item h4,
		.property-item h4 a,
		.es-carousel-wrapper ul li h4 a
	',
	'property' => 'color',
	'value'    => $property_options[ 'theme_property_title_color' ]
);

$property_css = array(
	'elements' => '
		.property-item h4 a:hover,
		.property-item h4 a:focus,
		.property-item h4 a:active,
		.es-carousel-wrapper ul li h4 a:hover,
		.es-carousel-wrapper ul li h4 a:focus,
		.es-carousel-wrapper ul li h4 a:active
	',
	'property' => 'color',
	'value'    => $property_options[ 'theme_property_title_hover_color' ]
);

$property_css = array(
	'elements' => '
	.property-item .price,
	.es-carousel-wrapper ul li .price,
	.property-item .price small
	',
	'property' => 'color',
	'value'    => $property_options[ 'theme_property_price_text_color' ]
);

$property_css = array(
	'elements' => '
		.property-item .price,
		.es-carousel-wrapper ul li .price
	',
	'property' => 'background-color',
	'value'    => $property_options[ 'theme_property_price_bg_color' ]
);

$property_css = array(
	'elements' => '.property-item figure figcaption',
	'property' => 'color',
	'value'    => $property_options[ 'theme_property_status_text_color' ]
);

$property_css = array(
	'elements' => '.property-item figure figcaption',
	'property' => 'background-color',
	'value'    => $property_options[ 'theme_property_status_bg_color' ]
);

$property_css = array(
	'elements' => '
		.property-item p,
		.es-carousel-wrapper ul li p
	',
	'property' => 'color',
	'value'    => $property_options[ 'theme_property_desc_text_color' ]
);

$property_css = array(
	'elements' => '
		.more-details,
		.es-carousel-wrapper ul li p a
	',
	'property' => 'color',
	'value'    => $property_options[ 'theme_more_details_text_color' ]
);

$property_css = array(
	'elements' => '
		.more-details:hover,
		.more-details:focus,
		.more-details:active,
		.es-carousel-wrapper ul li p a:hover,
		.es-carousel-wrapper ul li p a:focus,
		.es-carousel-wrapper ul li p a:active
	',
	'property' => 'color',
	'value'    => $property_options[ 'theme_more_details_text_hover_color' ]
);

$property_css = array(
	'elements' => '.property-item .property-meta span',
	'property' => 'color',
	'value'    => $property_options[ 'theme_property_meta_text_color' ]
);

$property_css = array(
	'elements' => '.property-item .property-meta',
	'property' => 'background-color',
	'value'    => $property_options[ 'theme_property_meta_bg_color' ]
);

return $property_css;